/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.data.mineral;

import com.igteam.immersivegeology.common.block.helper.MineralWeathering;
import com.igteam.immersivegeology.common.world.features.helper.noise.IGGenerationType;
import com.igteam.immersivegeology.core.material.data.enums.MetalEnum;
import com.igteam.immersivegeology.core.material.data.types.MaterialMineral;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialColorHelper;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.material.helper.material.StoneFormation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGMethodBuilder;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGRecipeChain;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.tags.BiomeTags;

public class MaterialCuprite
extends MaterialMineral {
    Function<Integer, Integer> coloredWeathering = MaterialColorHelper.setupWeatheredColors(List.of(MaterialColorHelper.weatheredColor(MineralWeathering.PRISTINE, 10365487), MaterialColorHelper.weatheredColor(MineralWeathering.TARNISHED, 4033661)));

    public MaterialCuprite() {
        this.acceptableStoneTypes.add(StoneFormation.SEDIMENTARY);
        this.acceptableStoneTypes.add(StoneFormation.IGNEOUS_EXTRUSIVE);
        this.acceptableStoneTypes.add(StoneFormation.MINECRAFT_STONE);
        this.addFlags(ItemCategoryFlags.PELLET);
        this.CONFIG = new MaterialMineral.MineralConfig(30, 50, 1, -64, 200, 3570, 0.7, false, Optional.of(BiomeTags.f_215817_), IGGenerationType.DEFAULT);
    }

    @Override
    public boolean canTarnish() {
        return true;
    }

    @Override
    protected BiFunction<IFlagType<?>, Integer, Integer> materialColorFunction() {
        return (p, i) -> this.coloredWeathering.apply((Integer)i);
    }

    @Override
    public Set<IGRecipeChain> getRecipeChains() {
        return Set.of(this.directBlasting);
    }

    @Override
    public void setupRecipeStages() {
        super.setupRecipeStages();
        IGMethodBuilder.separating(this, IGStageDesignation.EXTRACTION).create(this.getItemTag(ItemCategoryFlags.POWDER), MetalEnum.Copper.getStack(ItemCategoryFlags.METAL_OXIDE), MetalEnum.Manganese.getStack(ItemCategoryFlags.METAL_OXIDE), 0.075f, 200, 250);
        IGMethodBuilder.blasting(this, IGStageDesignation.EXTRACTION).create("crushed_ore_" + this.getName() + "_to_ingot", this.getItemTag(ItemCategoryFlags.CRUSHED_ORE), this.getPrimaryProduct().getStack(ItemCategoryFlags.INGOT));
        IGMethodBuilder.bloomery(this, IGStageDesignation.REFINEMENT).create(ItemCategoryFlags.CRUSHED_ORE, 2, ItemCategoryFlags.INGOT, 1, 400);
    }

    @Override
    public LinkedHashSet<MaterialInterface<?>> getDerivedMaterials() {
        return new LinkedHashSet(List.of(MetalEnum.Copper, MetalEnum.Manganese));
    }

    @Override
    public float getNoiseProbability() {
        return 0.19122314f;
    }
}

