/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.data.mineral;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.igteam.immersivegeology.common.world.features.helper.noise.IGGenerationType;
import com.igteam.immersivegeology.core.material.data.enums.ChemicalEnum;
import com.igteam.immersivegeology.core.material.data.enums.MetalEnum;
import com.igteam.immersivegeology.core.material.data.enums.MineralEnum;
import com.igteam.immersivegeology.core.material.data.types.MaterialMineral;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.CrystalFamily;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.material.helper.material.StoneFormation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGMethodBuilder;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.Tags;

public class MaterialMonazite
extends MaterialMineral {
    public MaterialMonazite() {
        this.acceptableStoneTypes.add(StoneFormation.SEDIMENTARY);
        this.acceptableStoneTypes.add(StoneFormation.MINECRAFT_STONE);
        this.acceptableStoneTypes.add(StoneFormation.IGNEOUS_EXTRUSIVE);
        this.addFlags(ItemCategoryFlags.SEDIMENT);
        this.CONFIG = new MaterialMineral.MineralConfig(22, 90, 1, 12, 120, 900, 0.5, true, Optional.of(Tags.Biomes.IS_DRY), IGGenerationType.DEFAULT);
    }

    @Override
    protected BiFunction<IFlagType<?>, Integer, Integer> materialColorFunction() {
        return (p, i) -> -4055466;
    }

    @Override
    public CrystalFamily getCrystalFamily() {
        return CrystalFamily.MONOCLINIC;
    }

    @Override
    public LinkedHashSet<MaterialInterface<?>> getDerivedMaterials() {
        return new LinkedHashSet(List.of(MetalEnum.Neodymium, MetalEnum.Thorium));
    }

    @Override
    public void setupRecipeStages() {
        super.setupRecipeStages();
        IGMethodBuilder.crushing(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.CRUSHED_ORE, ItemCategoryFlags.GRIT, 6000, 100);
        IGMethodBuilder.pulverization(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.CRUSHED_ORE, ItemCategoryFlags.POWDER);
        IGMethodBuilder.pulverization(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.GRIT, ItemCategoryFlags.POWDER, 400, 32000);
        IGMethodBuilder.chemical(this, IGStageDesignation.LEECHING).create(this.getName() + "ore_to_slurry", this.getStack(ItemCategoryFlags.SEDIMENT, 3), ChemicalEnum.SulfuricAcid.getSlurryWith(MetalEnum.Neodymium, 648), IngredientWithSize.of((ItemStack)this.getStack(ItemCategoryFlags.POWDER, 3)), new FluidTagInput(ChemicalEnum.SulfuricAcid.getFluidTag(BlockCategoryFlags.FLUID), 750), null, null, 200, 51200);
        IGMethodBuilder.chemical(this, IGStageDesignation.LEECHING).create(this.getName() + "ore_to_slurry", MetalEnum.Thorium.getStack(ItemCategoryFlags.METAL_OXIDE, 1), ChemicalEnum.ChemicalWaste.getSlurryWith(MineralEnum.Monazite, 216), IngredientWithSize.of((ItemStack)this.getStack(ItemCategoryFlags.SEDIMENT, 1)), new FluidTagInput(ChemicalEnum.SodiumHydroxide.getFluidTag(BlockCategoryFlags.FLUID), 250), null, null, 200, 51200);
    }

    @Override
    public float getNoiseProbability() {
        return 0.05505371f;
    }
}

