/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.data.mineral;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.igteam.immersivegeology.common.world.features.helper.noise.IGGenerationType;
import com.igteam.immersivegeology.core.material.data.enums.ChemicalEnum;
import com.igteam.immersivegeology.core.material.data.enums.MetalEnum;
import com.igteam.immersivegeology.core.material.data.enums.MineralEnum;
import com.igteam.immersivegeology.core.material.data.types.MaterialMineral;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.MaterialFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.material.helper.material.StoneFormation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGMethodBuilder;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.Tags;

public class MaterialUraninite
extends MaterialMineral {
    public MaterialUraninite() {
        this.addFlags(MaterialFlags.EXISTING_IMPLEMENTATION);
        this.acceptableStoneTypes.add(StoneFormation.MINECRAFT_STONE);
        this.acceptableStoneTypes.add(StoneFormation.IGNEOUS_INTRUSIVE);
        this.CONFIG = new MaterialMineral.MineralConfig(33, 80, 1, -64, 32, 800, 0.5, true, Optional.of(Tags.Biomes.IS_COLD), IGGenerationType.DEFAULT);
    }

    @Override
    protected BiFunction<IFlagType<?>, Integer, Integer> materialColorFunction() {
        return (p, i) -> -5062987;
    }

    @Override
    public LinkedHashSet<MaterialInterface<?>> getDerivedMaterials() {
        return new LinkedHashSet(List.of(MetalEnum.Uranium, MetalEnum.Thorium));
    }

    @Override
    public void setupRecipeStages() {
        super.setupRecipeStages();
        IGMethodBuilder.crushing(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.CRUSHED_ORE, ItemCategoryFlags.GRIT, 6000, 100);
        IGMethodBuilder.pulverization(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.CRUSHED_ORE, ItemCategoryFlags.POWDER);
        IGMethodBuilder.pulverization(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.GRIT, ItemCategoryFlags.POWDER, 400, 32000);
        IGMethodBuilder.chemical(this, IGStageDesignation.LEECHING).create(this.getName() + "ore_to_slurry", ItemStack.f_41583_, ChemicalEnum.PhosphoricAcid.getCloudySlurryWith(MineralEnum.Uraninite, 648), IngredientWithSize.of((ItemStack)this.getStack(ItemCategoryFlags.POWDER, 1)), new FluidTagInput(ChemicalEnum.PhosphoricAcid.getFluidTag(BlockCategoryFlags.FLUID), 250), new FluidTagInput(ChemicalEnum.SodiumHydroxide.getFluidTag(BlockCategoryFlags.FLUID), 250), new FluidTagInput(IETags.fluidEthanol, 250), 200, 51200);
        IGMethodBuilder.chemical(this, IGStageDesignation.LEECHING).create(this.getName() + "ore_to_slurry", ItemStack.f_41583_, ChemicalEnum.NitricAcid.getCloudySlurryWith(MineralEnum.Uraninite, 648), IngredientWithSize.of((ItemStack)ItemStack.f_41583_), new FluidTagInput(ChemicalEnum.PhosphoricAcid.getCloudySlurryTagWith(MineralEnum.Uraninite), 216), new FluidTagInput(ChemicalEnum.Ammonia.getFluidTag(BlockCategoryFlags.FLUID), 250), new FluidTagInput(ChemicalEnum.NitricAcid.getFluidTag(BlockCategoryFlags.FLUID), 250), 200, 51200);
        IGMethodBuilder.centrifuge(this, IGStageDesignation.REFINEMENT).create(ChemicalEnum.NitricAcid.getCloudySlurryTagWith(MineralEnum.Uraninite), 144, MetalEnum.Uranium, ItemCategoryFlags.COMPOUND_DUST, 1, ChemicalEnum.ChemicalWaste.getCloudySlurryWith(MineralEnum.Uraninite), 120, ChemicalEnum.NitricAcid.getSlurryWith(MetalEnum.Thorium), 120, 1200, 614400);
    }

    @Override
    public float getNoiseProbability() {
        return 0.15179443f;
    }
}

