/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.data.mineral;

import com.igteam.immersivegeology.common.world.features.helper.noise.IGGenerationType;
import com.igteam.immersivegeology.core.material.data.enums.MetalEnum;
import com.igteam.immersivegeology.core.material.data.types.MaterialMineral;
import com.igteam.immersivegeology.core.material.data.types.MaterialSulphideMineral;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.CrystalFamily;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.material.helper.material.StoneFormation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGMethodBuilder;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;

public class MaterialVanadinite
extends MaterialSulphideMineral {
    public MaterialVanadinite() {
        this.acceptableStoneTypes.add(StoneFormation.MINECRAFT_STONE);
        this.acceptableStoneTypes.add(StoneFormation.IGNEOUS_INTRUSIVE);
        this.addFlags(ItemCategoryFlags.SLAG);
        this.addFlags(ItemCategoryFlags.PELLET);
        this.addFlags(ItemCategoryFlags.POWDERED_SLAG);
        this.CONFIG = new MaterialMineral.MineralConfig(12, 70, 1, -32, 140, 700, 0.5, false, Optional.of(Tags.Biomes.IS_HOT), IGGenerationType.TUBE);
    }

    @Override
    protected BiFunction<IFlagType<?>, Integer, Integer> materialColorFunction() {
        return (p, i) -> -1105567;
    }

    @Override
    public CrystalFamily getCrystalFamily() {
        return CrystalFamily.HEXAGONAL;
    }

    @Override
    public void setupRecipeStages() {
        logged_recipes.add(this.getName());
        IGMethodBuilder.separating(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.DIRTY_CRUSHED_ORE, ItemCategoryFlags.CRUSHED_ORE, new ItemStack((ItemLike)Blocks.f_49994_), 0.33f, 100, 100);
        IGMethodBuilder.crushing(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.CRUSHED_ORE, ItemCategoryFlags.GRIT, 6000, 100);
        IGMethodBuilder.blasting(this, IGStageDesignation.EXTRACTION).create("pellet_" + this.getName() + "_to_ingot", this.getItemTag(ItemCategoryFlags.CRUSHED_ORE), this.getSecondaryProduct().getStack(ItemCategoryFlags.INGOT), this.getStack(ItemCategoryFlags.SLAG, 1), 1800);
        IGMethodBuilder.blasting(this, IGStageDesignation.EXTRACTION).create("pellet_" + this.getName() + "_to_ingot", this.getItemTag(ItemCategoryFlags.PELLET), this.getSecondaryProduct().getStack(ItemCategoryFlags.INGOT), this.getStack(ItemCategoryFlags.SLAG, 1), 200);
        IGMethodBuilder.pulverization(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.SLAG, ItemCategoryFlags.POWDERED_SLAG);
        IGMethodBuilder.separating(this, IGStageDesignation.EXTRACTION).create(this.getItemTag(ItemCategoryFlags.POWDERED_SLAG), this.getPrimaryProduct().getStack(ItemCategoryFlags.METAL_OXIDE), this.getSecondaryProduct().getStack(ItemCategoryFlags.METAL_OXIDE), 0.0075f, 200, 250);
    }

    @Override
    public LinkedHashSet<MaterialInterface<?>> getDerivedMaterials() {
        return new LinkedHashSet(List.of(MetalEnum.Vanadium, MetalEnum.Lead));
    }

    @Override
    public float getNoiseProbability() {
        return 0.019104004f;
    }

    @Override
    public List<String> getAcceptableDimensions() {
        return List.of("minecraft:overworld", "minecraft:the_nether");
    }
}

