/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.data.types;

import com.igteam.immersivegeology.common.world.features.helper.noise.IGGenerationType;
import com.igteam.immersivegeology.core.lib.IGLib;
import com.igteam.immersivegeology.core.material.data.enums.ChemicalEnum;
import com.igteam.immersivegeology.core.material.data.types.MaterialMineral;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialHelper;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGMethodBuilder;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.Tags;

public class MaterialEvaporateMineral
extends MaterialMineral {
    public MaterialEvaporateMineral() {
        this.addFlags(BlockCategoryFlags.EVAPORATE, BlockCategoryFlags.EVAPORATE_CRYSTAL, ItemCategoryFlags.CRYSTAL, ItemCategoryFlags.SEDIMENT, BlockCategoryFlags.STORAGE_BLOCK);
        this.removeMaterialFlags(ItemCategoryFlags.SLAG, ItemCategoryFlags.POWDERED_SLAG, ItemCategoryFlags.NORMAL_ORE, ItemCategoryFlags.POOR_ORE, ItemCategoryFlags.RICH_ORE, ItemCategoryFlags.DIRTY_CRUSHED_ORE, ItemCategoryFlags.CRUSHED_ORE, BlockCategoryFlags.ORE_BLOCK);
        int minSea = 62;
        int maxSea = 72;
        this.CONFIG = new MaterialMineral.MineralConfig(8, 50, 1, minSea, maxSea, 5, 0.5, true, Optional.of(Tags.Biomes.IS_DESERT), IGGenerationType.EVAPORATE);
    }

    @Override
    public BlockBehaviour.Properties getProperties(IFlagType<?> flag) {
        return flag.equals(BlockCategoryFlags.STORAGE_BLOCK) ? IGLib.CRYSTAL_DECO_PROPS : super.getProperties(flag);
    }

    @Override
    public ResourceLocation getTextureLocation(IFlagType<?> flag) {
        if (flag instanceof BlockCategoryFlags) {
            BlockCategoryFlags blockFlag = (BlockCategoryFlags)flag;
            switch (blockFlag) {
                case EVAPORATE: {
                    return new ResourceLocation("immersivegeology", "block/colored/" + this.name + "/sediment");
                }
            }
        }
        return super.getTextureLocation(flag);
    }

    @Override
    public void setupRecipeStages() {
        super.setupRecipeStages();
        IGMethodBuilder.mixing(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.SEDIMENT, (TagKey<Fluid>)FluidTags.f_13131_, 64, ChemicalEnum.Brine.getCloudySlurryWith(this), 64);
        IGMethodBuilder.mixing(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.CRYSTAL, (TagKey<Fluid>)FluidTags.f_13131_, 64, ChemicalEnum.Brine.getSlurryWith(this), 64);
        IGMethodBuilder.centrifuge(this, IGStageDesignation.PURIFICATION).create(ChemicalEnum.Brine.getCloudySlurryTagWith(this), 1000, (MaterialHelper)this, Items.f_41830_, 1, ChemicalEnum.Brine.getSlurryWith(this), 976, null, 0, 1200, 614400);
    }
}

