/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.data.types;

import com.igteam.immersivegeology.client.helper.IGVeinTextureType;
import com.igteam.immersivegeology.common.world.features.helper.noise.IGGenerationType;
import com.igteam.immersivegeology.core.material.GeologyMaterial;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.MaterialFlags;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGMethodBuilder;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGRecipeChain;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGRecipeNode;
import java.util.Optional;
import java.util.Set;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;

public class MaterialMineral
extends GeologyMaterial {
    public MineralConfig CONFIG = new MineralConfig(8, 50, 1, -48, 112, 50, 0.5, false, Optional.empty(), IGGenerationType.DEFAULT);

    public MaterialMineral() {
        this.addFlags(MaterialFlags.HAS_SLURRY, ItemCategoryFlags.GRIT, ItemCategoryFlags.POWDER);
    }

    @Override
    public Set<IGRecipeChain> getRecipeChains() {
        return this.directBlasting.getRootNodes().isEmpty() ? Set.of() : Set.of(this.directBlasting);
    }

    @Override
    public void setupRecipeStages() {
        logged_recipes.add(this.getName());
        boolean f = false;
        if (this.hasFlag(ItemCategoryFlags.PELLET)) {
            f = true;
            IGRecipeNode grit = IGMethodBuilder.crushing(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.CRUSHED_ORE, ItemCategoryFlags.GRIT, 6000, 100).addOptionalToTree(this.directBlasting);
            IGRecipeNode powder_b = IGMethodBuilder.pulverization(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.CRUSHED_ORE, ItemCategoryFlags.POWDER).addOptionalToTree(this.directBlasting);
            IGRecipeNode powder_a = IGMethodBuilder.pulverization(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.GRIT, ItemCategoryFlags.POWDER, 200, 16000).addToTree(this.directBlasting, grit);
            IGMethodBuilder.pelletize(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.POWDER).joinBranches(this.directBlasting, powder_a, powder_b);
            IGMethodBuilder.blasting(this, IGStageDesignation.EXTRACTION).create("pellet_" + this.getName() + "_to_ingot", this.getItemTag(ItemCategoryFlags.PELLET), this.getPrimaryProduct().getStack(ItemCategoryFlags.INGOT)).addToTree(this.directBlasting);
        }
        if (this.hasFlag(ItemCategoryFlags.DIRTY_CRUSHED_ORE) && this.hasFlag(ItemCategoryFlags.CRUSHED_ORE)) {
            IGMethodBuilder.separating(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.DIRTY_CRUSHED_ORE, ItemCategoryFlags.CRUSHED_ORE, new ItemStack((ItemLike)Blocks.f_49994_), 0.33f, 100, 100);
            if (!f && this.hasFlag(ItemCategoryFlags.GRIT)) {
                IGMethodBuilder.crushing(this, IGStageDesignation.PREPARATION).create(ItemCategoryFlags.CRUSHED_ORE, ItemCategoryFlags.GRIT, 6000, 100);
            }
        }
    }

    @Override
    public IGVeinTextureType getVeinTextureType() {
        return IGVeinTextureType.MINERAL;
    }

    public record MineralConfig(int veinSize, int rarity, int veinsPerChunk, int minY, int maxY, int generationChance, double density, boolean useSparsePlacement, Optional<TagKey<Biome>> preferredBiome, IGGenerationType generationType) {
    }
}

