/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.helper.flags;

import com.igteam.immersivegeology.client.IGClientRenderHandler;
import com.igteam.immersivegeology.client.menu.ItemSubGroup;
import com.igteam.immersivegeology.common.block.helper.OreRichness;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.ModFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialHelper;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import java.util.ArrayList;
import java.util.List;

public interface IFlagType<T extends Enum<T>> {
    public T getValue();

    public String getTagPrefix();

    public static List<IFlagType<?>> getAllRegistryFlags() {
        ArrayList list = new ArrayList();
        list.addAll(List.of(BlockCategoryFlags.values()));
        list.addAll(List.of(ItemCategoryFlags.values()));
        return list;
    }

    default public String getRegistryKey(MaterialHelper material) {
        return ((Enum)this.getValue()).name().toLowerCase() + "_" + material.getName().toLowerCase();
    }

    default public String getRegistryKey(MaterialHelper ore, MaterialHelper stone) {
        return ((Enum)this.getValue()).name().toLowerCase() + "_" + ore.getName().toLowerCase() + "_" + stone.getName().toLowerCase();
    }

    default public String getRegistryKey(MaterialInterface<?> material) {
        return this.getRegistryKey((MaterialHelper)material.instance());
    }

    default public String getRegistryKey(MaterialInterface<?> ore, MaterialInterface<?> stone) {
        return this.getRegistryKey((MaterialHelper)ore.instance(), (MaterialHelper)stone.instance());
    }

    default public String getRegistryKey(MaterialInterface<?> ore, MaterialInterface<?> stone, OreRichness richness) {
        Object prefix = "";
        for (ModFlags modflag : ModFlags.values()) {
            if (!stone.hasFlag(modflag)) continue;
            prefix = modflag.name().toLowerCase() + "_";
        }
        return (String)prefix + richness.name().toLowerCase() + "_" + this.getRegistryKey((MaterialHelper)ore.instance(), (MaterialHelper)stone.instance());
    }

    default public String getRegistryKey(MaterialHelper ore, MaterialInterface<?> stone, OreRichness richness) {
        Object prefix = "";
        for (ModFlags modflag : ModFlags.values()) {
            if (!stone.hasFlag(modflag)) continue;
            prefix = modflag.name().toLowerCase() + "_";
        }
        return (String)prefix + richness.name().toLowerCase() + "_" + this.getRegistryKey(ore, (MaterialHelper)stone.instance());
    }

    default public String getRegistryKey(MaterialHelper ore, MaterialHelper stone, OreRichness richness) {
        Object prefix = "";
        for (ModFlags modflag : ModFlags.values()) {
            if (!stone.hasFlag(modflag)) continue;
            prefix = modflag.name().toLowerCase() + "_";
        }
        return (String)prefix + richness.name().toLowerCase() + "_" + this.getRegistryKey(ore, stone);
    }

    default public String getRegistryKey(MaterialInterface<?> material, BlockCategoryFlags blockCategory) {
        return ((Enum)this.getValue()).name().toLowerCase() + "_" + material.getName().toLowerCase() + "_" + blockCategory.getName().toLowerCase();
    }

    default public ItemSubGroup getSubGroup() {
        return ItemSubGroup.values()[0];
    }

    default public String getName() {
        return ((Enum)this.getValue()).name().toLowerCase();
    }

    default public IGClientRenderHandler.RenderTypeSkeleton getRenderType() {
        return IGClientRenderHandler.RenderTypeSkeleton.SOLID;
    }
}

