/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.helper.material;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEItems;
import com.igteam.immersivegeology.client.helper.IGVeinTextureType;
import com.igteam.immersivegeology.common.block.helper.IOreBlock;
import com.igteam.immersivegeology.common.block.helper.OreRichness;
import com.igteam.immersivegeology.common.item.IGGenericDrillHead;
import com.igteam.immersivegeology.common.tag.IGTags;
import com.igteam.immersivegeology.core.lib.IGLib;
import com.igteam.immersivegeology.core.material.data.enums.MetalEnum;
import com.igteam.immersivegeology.core.material.data.enums.MineralEnum;
import com.igteam.immersivegeology.core.material.data.enums.StoneEnum;
import com.igteam.immersivegeology.core.material.data.types.MaterialStone;
import com.igteam.immersivegeology.core.material.helper.ScaffoldingHelper;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.ModFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeStage;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGStageProvider;
import com.igteam.immersivegeology.core.registration.IGRegistrationHolder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public interface MaterialHelper {
    public static final Set<String> logged_recipes = new HashSet<String>();

    default public ItemStack getStack(IFlagType<?> unknownFlag, int amount) {
        if (unknownFlag instanceof ItemCategoryFlags) {
            ItemCategoryFlags flag = (ItemCategoryFlags)unknownFlag;
            return new ItemStack((ItemLike)this.getItem(flag), amount);
        }
        if (unknownFlag instanceof BlockCategoryFlags) {
            BlockCategoryFlags flag = (BlockCategoryFlags)unknownFlag;
            return new ItemStack((ItemLike)this.getItem(flag), amount);
        }
        IGLib.IG_LOGGER.error("{} is not an Item or Block Flag", (Object)unknownFlag.getName());
        return ItemStack.f_41583_;
    }

    default public boolean canTarnish() {
        return false;
    }

    default public Item getItem(ItemCategoryFlags flag) {
        if (flag == null) {
            flag = ItemCategoryFlags.INGOT;
            IGLib.getNewLogger().error("Attempted to grab an item from registry with a null flag, replacing with INGOT to prevent crash");
        }
        try {
            if (Arrays.stream(EnumMetals.values()).anyMatch(e -> e.name().equalsIgnoreCase(this.getName()))) {
                switch (flag) {
                    case INGOT: {
                        return ((IEItems.ItemRegObject)IEItems.Metals.INGOTS.get(EnumMetals.valueOf((String)this.getName().toUpperCase()))).get().m_5456_();
                    }
                    case GRIT: {
                        return ((IEBaseItem)((IEItems.ItemRegObject)IEItems.Metals.DUSTS.get(EnumMetals.valueOf((String)this.getName().toUpperCase()))).get()).m_5456_();
                    }
                    case PLATE: {
                        return ((IEBaseItem)((IEItems.ItemRegObject)IEItems.Metals.PLATES.get(EnumMetals.valueOf((String)this.getName().toUpperCase()))).get()).m_5456_();
                    }
                    case NUGGET: {
                        return ((IEItems.ItemRegObject)IEItems.Metals.NUGGETS.get(EnumMetals.valueOf((String)this.getName().toUpperCase()))).get().m_5456_();
                    }
                    case WIRE: {
                        if (this.equals(MetalEnum.Aluminum.instance())) {
                            return IEItems.Ingredients.WIRE_ALUMINUM.get();
                        }
                        if (this.equals(MetalEnum.Copper.instance())) {
                            return IEItems.Ingredients.WIRE_COPPER.get();
                        }
                        if (this.equals(MetalEnum.Lead.instance())) {
                            return IEItems.Ingredients.WIRE_LEAD.get();
                        }
                        if (!this.equals(MetalEnum.Steel.instance())) break;
                        return IEItems.Ingredients.WIRE_STEEL.get();
                    }
                    case POWDER: {
                        if (!this.equals(MineralEnum.Saltpeter.instance())) break;
                        return IEItems.Ingredients.DUST_SALTPETER.get();
                    }
                }
            }
        }
        catch (Exception e2) {
            IGLib.IG_LOGGER.info("Unable to find an IE variant for {}", (Object)flag.getName());
            IGLib.IG_LOGGER.error("Exception: {}", (Object)e2.getMessage());
        }
        if (IGRegistrationHolder.getItemRegistryMap().containsKey(flag.getRegistryKey(this))) {
            return IGRegistrationHolder.getItem.apply(flag.getRegistryKey(this));
        }
        IGLib.IG_LOGGER.error("Attempting to get a missing Item? {}", (Object)flag.getRegistryKey(this));
        return Items.f_42572_;
    }

    default public Fluid getFluid(BlockCategoryFlags flag) {
        if (flag == null) {
            flag = BlockCategoryFlags.FLUID;
            IGLib.IG_LOGGER.warn("Null Flag Pass for fluid getter, defaulting to FLUID");
        }
        String id = flag.getRegistryKey(this);
        if (IGRegistrationHolder.getFluidRegistryMap().containsKey(id)) {
            return IGRegistrationHolder.getFluid.apply(id);
        }
        IGLib.IG_LOGGER.warn("Unable to find Fluid for material {}", (Object)id);
        return Fluids.f_76191_;
    }

    default public Fluid getFluid(BlockCategoryFlags flag, MaterialInterface<?> secondary) {
        return this.getFluid(flag, (MaterialHelper)secondary.instance());
    }

    default public Fluid getFluid(BlockCategoryFlags flag, MaterialHelper secondary) {
        if (flag == null) {
            flag = BlockCategoryFlags.SLURRY;
            IGLib.IG_LOGGER.warn("Null Flag Pass for slurry fluid getter, defaulting to SLURRY");
        }
        String id = flag.getRegistryKey(this, secondary);
        if (IGRegistrationHolder.getFluidRegistryMap().containsKey(id)) {
            return IGRegistrationHolder.getFluid.apply(id);
        }
        IGLib.IG_LOGGER.warn("Unable to find Fluid/Slurry for material {}, {}", (Object)this, (Object)secondary);
        return Fluids.f_76191_;
    }

    public TagKey<Fluid> getFluidTag(BlockCategoryFlags var1, MaterialHelper ... var2);

    default public TagKey<Fluid> getSlurryTagWith(BlockCategoryFlags type, MaterialHelper ... helper) {
        return this.getFluidTag(type, helper);
    }

    default public Item getItem(BlockCategoryFlags flag) {
        return this.getBlock(flag).m_5456_();
    }

    public boolean hasFlag(IFlagType<?> var1);

    public void addExistingFlag(ModFlags var1, ItemCategoryFlags ... var2);

    public void addExistingFlag(ModFlags var1, BlockCategoryFlags ... var2);

    public boolean checkExistingImplementation(IFlagType<?> var1);

    public boolean checkExistingImplementation(ModFlags var1, IFlagType<?> var2);

    public boolean weakCheckExistingImplementation(IFlagType<?> var1);

    public String getName();

    default public LinkedHashSet<MaterialInterface<?>> getDerivedMaterials() {
        return new LinkedHashSet();
    }

    public void addStage(IGRecipeStage var1);

    public Set<IGRecipeStage> getMaterialStageSet();

    default public Set<IGRecipeStage> getStageSet() {
        return IGStageProvider.get(this);
    }

    public void setupRecipeStages();

    default public void buildRecipe() {
        this.setupRecipeStages();
        IGStageProvider.add(this, this.getMaterialStageSet());
    }

    public static void logRecipeStages() {
        IGLib.IG_LOGGER.info("{} Recipe Stages have been registered", (Object)logged_recipes.size());
    }

    default public TagKey<Item> getItemTag(IFlagType<?> unknownFlag) {
        try {
            if (!(unknownFlag instanceof ItemCategoryFlags)) {
                throw new IllegalArgumentException("Non Item Category Flag Parsed to getItemTag");
            }
            ItemCategoryFlags flag = (ItemCategoryFlags)unknownFlag;
            try {
                EnumMetals IEMetal = EnumMetals.valueOf((String)this.getName().toUpperCase());
                IETags.MetalTags ieMetalTags = IETags.getTagsFor((EnumMetals)IEMetal);
                switch (flag.getValue()) {
                    case INGOT: {
                        return ieMetalTags.ingot;
                    }
                    case POWDER: {
                        return ieMetalTags.dust;
                    }
                    case NUGGET: {
                        return ieMetalTags.nugget;
                    }
                    case PLATE: {
                        return ieMetalTags.plate;
                    }
                }
            }
            catch (Exception IEMetal) {
                // empty catch block
            }
            HashMap data_map = IGTags.ITEM_TAG_HOLDER.get(flag);
            LinkedHashSet<MaterialHelper> material_set = new LinkedHashSet<MaterialHelper>(Collections.singletonList(this));
            String key = IGTags.getWrapFromSet(material_set);
            return (TagKey)data_map.get(key);
        }
        catch (Exception e) {
            IGLib.IG_LOGGER.error(e.getLocalizedMessage());
            IGLib.IG_LOGGER.warn("Null Tag Returned for {} {}", (Object)this.getName(), unknownFlag);
            return null;
        }
    }

    default public Block getBlock(BlockCategoryFlags flag) {
        try {
            EnumMetals IEMetal = EnumMetals.valueOf((String)this.getName().toUpperCase());
            switch (flag.getValue()) {
                case STORAGE_BLOCK: {
                    return ((IEBlocks.BlockEntry)IEBlocks.Metals.STORAGE.get(IEMetal)).get();
                }
                case SCAFFOLDING: {
                    return ((IEBlocks.BlockEntry)IEBlocks.Metals.SHEETMETAL.get(IEMetal)).get();
                }
                case SHEETMETAL_BLOCK: {
                    if (!this.checkExistingImplementation(flag)) break;
                    return ((IEBlocks.BlockEntry)IEBlocks.Metals.SHEETMETAL.get(IEMetal)).get();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (flag.equals(BlockCategoryFlags.ORE_BLOCK)) {
            return IGRegistrationHolder.getBlock.apply(flag.getRegistryKey(this, StoneEnum.Shale, OreRichness.RICH));
        }
        if (IGRegistrationHolder.getBlockRegistryMap().containsKey(flag.getRegistryKey(this))) {
            return IGRegistrationHolder.getBlock.apply(flag.getRegistryKey(this));
        }
        IGLib.IG_LOGGER.error("Attempting to get a missing block? {}", (Object)flag.getRegistryKey(this));
        return Blocks.f_50016_;
    }

    default public IOreBlock getOreBlock(StoneEnum stone, OreRichness richness) {
        try {
            return (IOreBlock)IGRegistrationHolder.getBlock.apply(BlockCategoryFlags.ORE_BLOCK.getRegistryKey(this, stone, richness));
        }
        catch (Exception exception) {
            return null;
        }
    }

    default public IOreBlock getOreBlock(MaterialHelper stone, OreRichness richness) {
        try {
            return (IOreBlock)IGRegistrationHolder.getBlock.apply(BlockCategoryFlags.ORE_BLOCK.getRegistryKey(this, stone, richness));
        }
        catch (Exception exception) {
            IGLib.IG_LOGGER.error("Unable to get Ore Block: {}", (Object)exception.getMessage());
            return null;
        }
    }

    default public IGVeinTextureType getVeinTextureType() {
        return IGVeinTextureType.METALLIC;
    }

    public MaterialInterface<?> getPrimaryProduct();

    public MaterialInterface<?> getSecondaryProduct();

    public MaterialInterface<?> getTraceProduct(int var1);

    default public boolean useColumnBlockStyle(IFlagType<?> flag) {
        return false;
    }

    default public ScaffoldingHelper getScaffoldingBlock() {
        return new ScaffoldingHelper(this);
    }

    public boolean acceptableStoneType(MaterialStone var1);

    default public boolean acceptableStoneType(StoneEnum stone) {
        return this.acceptableStoneType(stone.instance());
    }

    default public Set<MaterialHelper> getOriginMaterials() {
        return Set.of();
    }

    default public IGGenericDrillHead.DrillHeadProps drillHeadInstance() {
        return new IGGenericDrillHead.DrillHeadProps(this.getName(), (TagKey<Item>)IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot, 3, 1, (Tier)Tiers.DIAMOND, 10.0f, 7, 10000, () -> ImmersiveEngineering.rl((String)"item/drill_diesel"));
    }

    default public int getToolDamage() {
        return 3;
    }

    default public int getToolSpeed() {
        return 3;
    }

    default public Tier getToolTier() {
        return Tiers.IRON;
    }

    default public boolean hasCustomTexture(BlockCategoryFlags blockCategoryFlags) {
        return false;
    }
}

