/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.helper.material.recipe.helper;

import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGRecipeChain;
import com.igteam.immersivegeology.core.material.helper.material.recipe.helper.IGRecipeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class IGGraphLayoutManager {
    private final Map<Integer, Map<Integer, IGRecipeNode>> grid = new HashMap<Integer, Map<Integer, IGRecipeNode>>();
    private final Map<IGRecipeNode, int[]> positions = new HashMap<IGRecipeNode, int[]>();
    private final Set<IGRecipeNode> processedNodes = new HashSet<IGRecipeNode>();

    public void layoutChain(IGRecipeChain chain) {
        this.grid.clear();
        this.positions.clear();
        this.processedNodes.clear();
        List<Set<IGRecipeNode>> sccs = this.findStronglyConnectedComponents(chain);
        Map<IGRecipeNode, Integer> layers = this.assignLayers(chain.getRootNodes(), sccs);
        this.placeNodesOnGrid(chain.getRootNodes(), layers, sccs);
        for (Map.Entry<IGRecipeNode, int[]> entry : this.positions.entrySet()) {
            IGRecipeNode node = entry.getKey();
            int[] pos = entry.getValue();
            node.setX(pos[0]);
            node.setY(pos[1]);
        }
    }

    private List<Set<IGRecipeNode>> findStronglyConnectedComponents(IGRecipeChain chain) {
        Stack<IGRecipeNode> stack = new Stack<IGRecipeNode>();
        HashSet<IGRecipeNode> visited = new HashSet<IGRecipeNode>();
        ArrayList<Set<IGRecipeNode>> sccs = new ArrayList<Set<IGRecipeNode>>();
        for (IGRecipeNode root : chain.getRootNodes()) {
            if (visited.contains(root)) continue;
            this.dfsFirst(root, visited, stack);
        }
        visited.clear();
        while (!stack.isEmpty()) {
            IGRecipeNode node = (IGRecipeNode)stack.pop();
            if (visited.contains(node)) continue;
            HashSet<IGRecipeNode> scc = new HashSet<IGRecipeNode>();
            this.dfsSecond(node, visited, scc);
            sccs.add(scc);
        }
        return sccs;
    }

    private void dfsFirst(IGRecipeNode node, Set<IGRecipeNode> visited, Stack<IGRecipeNode> stack) {
        visited.add(node);
        for (IGRecipeNode child : node.getChildren()) {
            if (visited.contains(child)) continue;
            this.dfsFirst(child, visited, stack);
        }
        stack.push(node);
    }

    private void dfsSecond(IGRecipeNode node, Set<IGRecipeNode> visited, Set<IGRecipeNode> scc) {
        visited.add(node);
        scc.add(node);
        for (IGRecipeNode parent : node.getParents()) {
            if (visited.contains(parent)) continue;
            this.dfsSecond(parent, visited, scc);
        }
    }

    private Map<IGRecipeNode, Integer> assignLayers(List<IGRecipeNode> rootNodes, List<Set<IGRecipeNode>> sccs) {
        HashMap<IGRecipeNode, Integer> layers = new HashMap<IGRecipeNode, Integer>();
        HashMap<IGRecipeNode, Set<IGRecipeNode>> sccMap = new HashMap<IGRecipeNode, Set<IGRecipeNode>>();
        for (Set<IGRecipeNode> scc : sccs) {
            for (IGRecipeNode node : scc) {
                sccMap.put(node, scc);
            }
        }
        for (IGRecipeNode root : rootNodes) {
            this.assignLayer(root, 0, layers, sccMap);
        }
        return layers;
    }

    private int assignLayer(IGRecipeNode node, int currentLayer, Map<IGRecipeNode, Integer> layers, Map<IGRecipeNode, Set<IGRecipeNode>> sccMap) {
        Set<IGRecipeNode> scc;
        if (layers.containsKey(node)) {
            return layers.get(node);
        }
        layers.put(node, currentLayer);
        if (sccMap.containsKey(node) && (scc = sccMap.get(node)).size() > 1) {
            for (IGRecipeNode sccNode : scc) {
                layers.put(sccNode, currentLayer);
            }
        }
        int maxChildLayer = currentLayer;
        for (IGRecipeNode child : node.getChildren()) {
            if (sccMap.getOrDefault(node, Collections.emptySet()).contains(child)) continue;
            int childLayer = this.assignLayer(child, currentLayer + 1, layers, sccMap);
            maxChildLayer = Math.max(maxChildLayer, childLayer);
        }
        return maxChildLayer;
    }

    private void placeNodesOnGrid(List<IGRecipeNode> rootNodes, Map<IGRecipeNode, Integer> layers, List<Set<IGRecipeNode>> sccs) {
        HashMap nodesByLayer = new HashMap();
        layers.forEach((node, layer) -> nodesByLayer.computeIfAbsent(layer, k -> new ArrayList()).add(node));
        Iterator iterator = nodesByLayer.keySet().stream().sorted().toList().iterator();
        while (iterator.hasNext()) {
            int layer2 = (Integer)iterator.next();
            List nodes = (List)nodesByLayer.get(layer2);
            nodes.sort((a, b) -> {
                double xA = this.calculateOptimalX((IGRecipeNode)a);
                double xB = this.calculateOptimalX((IGRecipeNode)b);
                return Double.compare(xA, xB);
            });
            for (IGRecipeNode node2 : nodes) {
                if (this.positions.containsKey(node2)) continue;
                int optimalX = (int)Math.round(this.calculateOptimalX(node2));
                int x = this.findNearestAvailableX(optimalX, layer2);
                this.positions.put(node2, new int[]{x, layer2});
                this.grid.computeIfAbsent(layer2, k -> new HashMap()).put(x, node2);
            }
        }
    }

    private double calculateOptimalX(IGRecipeNode node) {
        ArrayList<Integer> connectedX = new ArrayList<Integer>();
        for (IGRecipeNode parent : node.getParents()) {
            if (!this.positions.containsKey(parent)) continue;
            connectedX.add(this.positions.get(parent)[0]);
        }
        for (IGRecipeNode child : node.getChildren()) {
            if (!this.positions.containsKey(child)) continue;
            connectedX.add(this.positions.get(child)[0]);
        }
        if (connectedX.isEmpty()) {
            return this.positions.size();
        }
        return connectedX.stream().mapToInt(Integer::intValue).average().orElse(0.0);
    }

    private int findNearestAvailableX(int optimalX, int layer) {
        int x = optimalX;
        int step = 1;
        Map layerGrid = this.grid.getOrDefault(layer, new HashMap());
        while (layerGrid.containsKey(x)) {
            x += step;
            if ((step = -step) <= 0) continue;
            ++step;
        }
        return x;
    }
}

