/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.helper.material.recipe.methods;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.builders.ArcFurnaceRecipeBuilder;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.lib.manual.gui.ManualScreen;
import com.igteam.immersivegeology.core.lib.IGLib;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialHelper;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeMethod;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeStage;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class IEArcSmeltingMethod
extends IGRecipeMethod {
    private String method_name;
    private IngredientWithSize input;
    private ItemStack slag;
    private ItemStack output;
    private List<IngredientWithSize> additives;
    int energy;
    int time;
    List<Pair<TagKey<Item>, Float>> secondaries = new ArrayList<Pair<TagKey<Item>, Float>>();

    public IEArcSmeltingMethod(IGRecipeStage stage) {
        super(stage);
    }

    public IEArcSmeltingMethod(MaterialHelper material, IGStageDesignation stage) {
        super(new IGRecipeStage(material, stage){});
    }

    public IEArcSmeltingMethod create(String method_name, TagKey<Item> input, int inputAmount, ItemStack output, ItemStack iSlag, IngredientWithSize ... additives) {
        this.input = new IngredientWithSize(input, inputAmount);
        this.output = output;
        this.slag = iSlag;
        this.additives = Arrays.asList(additives);
        this.method_name = method_name;
        return this;
    }

    public IEArcSmeltingMethod create(String method_name, Item input, int inputAmount, ItemStack output, ItemStack iSlag, IngredientWithSize ... additives) {
        this.input = new IngredientWithSize(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), inputAmount);
        this.output = output;
        this.slag = iSlag;
        this.additives = Arrays.asList(additives);
        this.method_name = method_name;
        return this;
    }

    public IEArcSmeltingMethod create(String method_name, TagKey<Item> input, int inputAmount, ItemStack output, ItemStack iSlag) {
        this.input = new IngredientWithSize(input, inputAmount);
        this.output = output;
        this.slag = iSlag;
        this.additives = List.of();
        this.method_name = method_name;
        return this;
    }

    public IEArcSmeltingMethod create(IFlagType<?> input_form, int inputAmount, IFlagType<?> output_form, int output_amount, int slag_amount) {
        this.input = new IngredientWithSize(this.parentMaterial.getItemTag(input_form), inputAmount);
        this.output = this.parentMaterial.getStack(output_form, output_amount);
        this.slag = slag_amount == 0 ? ItemStack.f_41583_ : this.parentMaterial.getStack(ItemCategoryFlags.SLAG, slag_amount);
        this.additives = List.of();
        this.method_name = this.create_advanced_method_name(input_form, output_form);
        this.setTimeAndEnergy(400, 204800);
        return this;
    }

    public IEArcSmeltingMethod create(IFlagType<?> input_form, int inputAmount, IFlagType<?> output_form, int output_amount, int slag_amount, IngredientWithSize ... additives) {
        this.input = new IngredientWithSize(this.parentMaterial.getItemTag(input_form), inputAmount);
        this.output = this.parentMaterial.getStack(output_form, output_amount);
        this.slag = slag_amount == 0 ? ItemStack.f_41583_ : this.parentMaterial.getStack(ItemCategoryFlags.SLAG, slag_amount);
        this.additives = List.of(additives);
        this.method_name = this.create_advanced_method_name(input_form, output_form);
        this.setTimeAndEnergy(400, 204800);
        return this;
    }

    public IEArcSmeltingMethod create(MaterialHelper input_mat, IFlagType<?> input_form, int inputAmount, IFlagType<?> output_form, int output_amount, int slag_amount, IngredientWithSize ... additives) {
        this.input = new IngredientWithSize(input_mat.getItemTag(input_form), inputAmount);
        this.output = this.parentMaterial.getStack(output_form, output_amount);
        this.slag = slag_amount == 0 ? ItemStack.f_41583_ : new ItemStack((ItemLike)IEItems.Ingredients.SLAG.m_5456_(), slag_amount);
        this.additives = List.of(additives);
        this.method_name = this.create_advanced_method_name(input_form, output_form);
        return this;
    }

    public IEArcSmeltingMethod addExtras(TagKey<Item> extra, Float chance) {
        this.secondaries.add((Pair<TagKey<Item>, Float>)Pair.of(extra, (Object)chance));
        return this;
    }

    public IEArcSmeltingMethod setTimeAndEnergy(int time, int energy) {
        this.time = time;
        this.energy = energy;
        return this;
    }

    @Override
    @NotNull
    public IGRecipeMethod.RecipeMethod getMethod() {
        return IGRecipeMethod.RecipeMethod.ARC_SMELTING;
    }

    @Override
    public ResourceLocation getLocation() {
        return this.toRL("arc_smelting/arc_" + this.getName());
    }

    @Override
    public String getName() {
        return this.method_name;
    }

    @Override
    public ItemStack getIconStack() {
        return new ItemStack((ItemLike)IEMultiblocks.ARC_FURNACE.getBlock().m_5456_());
    }

    @Override
    public void render(GuiGraphics graphics, ManualScreen screen, int x, int y, int mx, int my) {
        this.renderItemStack(graphics, this.input.getRandomizedExampleStack(0), x + 25, y + 2, mx, my);
        for (IngredientWithSize ingredient : this.additives) {
            this.renderItemStack(graphics, ingredient.getRandomizedExampleStack(0), x + 7, y + 2 + 18 * this.additives.indexOf(ingredient), mx, my);
        }
        this.renderItemStack(graphics, this.output, x + 59, y + 2, mx, my);
        if (!this.slag.m_41619_()) {
            this.renderItemStack(graphics, this.slag, x + 59, y + 20, mx, my);
        }
    }

    @Override
    public void renderDisplayStack(GuiGraphics graphics, ManualScreen screen, int x, int y, int mx, int my) {
    }

    @Override
    public void renderFinalStack(GuiGraphics graphics, ManualScreen screen, int baseX, int baseY, int mx, int my) {
    }

    @Override
    public boolean build(Consumer<FinishedRecipe> consumer) {
        try {
            ArcFurnaceRecipeBuilder builder = ArcFurnaceRecipeBuilder.builder((ItemStack)this.output);
            if (!this.slag.m_41619_()) {
                builder.addSlag(this.slag);
            }
            builder.setEnergy(this.energy);
            builder.setTime(this.time);
            builder.addIngredient("input", this.input);
            this.additives.forEach(arg_0 -> ((ArcFurnaceRecipeBuilder)builder).addMultiInput(arg_0));
            for (Pair<TagKey<Item>, Float> entry : this.secondaries) {
                builder.addSecondary((TagKey)entry.getFirst(), ((Float)entry.getSecond()).floatValue());
            }
            builder.build(consumer, this.getLocation());
            return true;
        }
        catch (Exception e) {
            IGLib.IG_LOGGER.error(e.getLocalizedMessage());
            return false;
        }
    }
}

