/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.helper.material.recipe.methods;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.builders.CrusherRecipeBuilder;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.gui.ManualScreen;
import com.igteam.immersivegeology.core.lib.IGLib;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.material.MaterialHelper;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeMethod;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeStage;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.jetbrains.annotations.NotNull;

public class IECrushingMethod
extends IGRecipeMethod {
    private ItemStack output;
    private IngredientWithSize input;
    private List<Pair<IngredientWithSize, Float>> secondaries = new ArrayList<Pair<IngredientWithSize, Float>>();
    private int energy;
    private int time;
    private String name;

    public IECrushingMethod(MaterialHelper parentMaterial, IGStageDesignation stage) {
        super(new IGRecipeStage(parentMaterial, stage){});
    }

    public IECrushingMethod create(String method_name, IngredientWithSize input, ItemStack output, int energy, int time) {
        this.input = input;
        this.output = output;
        this.name = method_name;
        this.energy = energy;
        this.time = time;
        return this;
    }

    public IECrushingMethod create(IFlagType<?> input_form, IFlagType<?> output_form, int energy, int time) {
        this.input = IngredientWithSize.of((ItemStack)this.parentMaterial.getStack(input_form, 1));
        this.output = this.parentMaterial.getStack(output_form, 1);
        this.name = this.create_advanced_method_name(input_form, output_form);
        this.energy = energy;
        this.time = time;
        return this;
    }

    public IECrushingMethod create(IFlagType<?> input_form, MaterialHelper output_material, IFlagType<?> output_form, int output_amount, int energy, int time) {
        this.input = IngredientWithSize.of((ItemStack)this.parentMaterial.getStack(input_form, 1));
        this.output = output_material.getStack(output_form, output_amount);
        this.name = this.create_advanced_method_name(input_form, output_form);
        this.energy = energy;
        this.time = time;
        return this;
    }

    public IECrushingMethod create(MaterialHelper input_material, IFlagType<?> input_form, int input_amount, MaterialHelper output_material, IFlagType<?> output_form, int output_amount, int energy, int time) {
        this.input = IngredientWithSize.of((ItemStack)input_material.getStack(input_form, input_amount));
        this.output = output_material.getStack(output_form, output_amount);
        this.name = this.create_advanced_method_name(input_form, output_form);
        this.energy = energy;
        this.time = time;
        return this;
    }

    public IECrushingMethod create(IFlagType<?> input_form, MaterialHelper output_material, IFlagType<?> output_form, int energy, int time) {
        this.input = IngredientWithSize.of((ItemStack)this.parentMaterial.getStack(input_form, 1));
        this.output = output_material.getStack(output_form, 1);
        this.name = this.create_advanced_method_name(input_form, output_form);
        this.energy = energy;
        this.time = time;
        return this;
    }

    public IECrushingMethod create(MaterialHelper input_material, IFlagType<?> input_form, MaterialHelper output_material, IFlagType<?> output_form, int energy, int time) {
        this.input = IngredientWithSize.of((ItemStack)input_material.getStack(input_form, 1));
        this.output = output_material.getStack(output_form, 1);
        this.name = this.create_advanced_method_name(input_form, output_form);
        this.energy = energy;
        this.time = time;
        return this;
    }

    public IECrushingMethod create(String method_name, ItemStack input, ItemStack output, int energy, int time) {
        this.input = IngredientWithSize.of((ItemStack)input);
        this.output = output;
        this.name = method_name;
        this.energy = energy;
        this.time = time;
        return this;
    }

    public IECrushingMethod addSecondary(ItemStack secondary, float chance) {
        this.secondaries.add((Pair<IngredientWithSize, Float>)Pair.of((Object)IngredientWithSize.of((ItemStack)secondary), (Object)Float.valueOf(chance)));
        return this;
    }

    public IECrushingMethod create(String method_name, IngredientWithSize input, ItemStack output, IngredientWithSize secondary, int energy, int time, float chance) {
        this.input = input;
        this.output = output;
        this.name = method_name;
        this.energy = energy;
        this.time = time;
        this.secondaries.add((Pair<IngredientWithSize, Float>)Pair.of((Object)secondary, (Object)Float.valueOf(chance)));
        return this;
    }

    public IECrushingMethod create(String method_name, ItemStack input, ItemStack output, ItemStack secondary, int energy, int time, float chance) {
        this.input = IngredientWithSize.of((ItemStack)input);
        this.output = output;
        this.name = method_name;
        this.energy = energy;
        this.time = time;
        this.secondaries.add((Pair<IngredientWithSize, Float>)Pair.of((Object)IngredientWithSize.of((ItemStack)secondary), (Object)Float.valueOf(chance)));
        return this;
    }

    @Override
    @NotNull
    public IGRecipeMethod.RecipeMethod getMethod() {
        return IGRecipeMethod.RecipeMethod.CRUSHING;
    }

    @Override
    public ResourceLocation getLocation() {
        return this.toRL("crushing/crush_" + Objects.requireNonNull(this.getName()));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ItemStack getIconStack() {
        return IEMultiblocks.CRUSHER.getBlock().m_5456_().m_7968_();
    }

    @Override
    public void render(GuiGraphics graphics, ManualScreen screen, int x, int y, int mx, int my) {
        this.renderItemStack(graphics, this.input.getRandomizedExampleStack(0), x + 25, y + 11, mx, my);
        this.renderItemStack(graphics, this.output, x + 59, y + 2, mx, my);
        int i = 0;
        for (Pair<IngredientWithSize, Float> secondaryPair : this.secondaries) {
            IngredientWithSize secondary = (IngredientWithSize)secondaryPair.getFirst();
            float chance = ((Float)secondaryPair.getSecond()).floatValue();
            if (secondary == null || secondary.hasNoMatchingItems()) continue;
            this.renderItemStack(graphics, secondary.getRandomizedExampleStack(0), x + 59 + 18 * i, y + 20, mx, my);
            ManualUtils.drawSplitString((GuiGraphics)graphics, (Font)screen.getManual().fontRenderer(), List.of(String.format("%.1f", Float.valueOf(chance * 100.0f)) + "%"), (int)(x + 79), (int)(y + 24), (int)-8947849);
            ++i;
        }
    }

    @Override
    public void renderDisplayStack(GuiGraphics graphics, ManualScreen screen, int x, int y, int mx, int my) {
    }

    @Override
    public void renderFinalStack(GuiGraphics graphics, ManualScreen screen, int baseX, int baseY, int mx, int my) {
    }

    @Override
    public boolean build(Consumer<FinishedRecipe> consumer) {
        try {
            CrusherRecipeBuilder builder = (CrusherRecipeBuilder)((CrusherRecipeBuilder)((CrusherRecipeBuilder)CrusherRecipeBuilder.builder((ItemStack)this.output).addInput(this.input)).setTime(this.time)).setEnergy(this.energy);
            for (Pair<IngredientWithSize, Float> additionalIngredients : this.secondaries) {
                IngredientWithSize secondary = (IngredientWithSize)additionalIngredients.getFirst();
                float chance = ((Float)additionalIngredients.getSecond()).floatValue();
                if (!(chance > 0.0f)) continue;
                builder.addSecondary(secondary, chance, new ICondition[0]);
            }
            builder.build(consumer, this.getLocation());
            return true;
        }
        catch (Exception e) {
            IGLib.IG_LOGGER.error("Exception Building IG Crushing Recipe: {}", (Object)e.getMessage());
            return false;
        }
    }
}

