/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.helper.material.recipe.methods;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.lib.manual.gui.ManualScreen;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.builder.BallmillRecipeBuilder;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.material.MaterialHelper;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeMethod;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeStage;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import com.igteam.immersivegeology.core.registration.IGMultiblockProvider;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class IGBallmillMethod
extends IGRecipeMethod {
    private int energy;
    private int time;
    private IngredientWithSize input;
    private ItemStack output;
    private String name;

    public IGBallmillMethod(MaterialHelper parent, IGStageDesignation stage) {
        super(new IGRecipeStage(parent, stage){});
    }

    public IGBallmillMethod create(IFlagType<?> input_form, IFlagType<?> output_form) {
        this.name = this.create_advanced_method_name(input_form, output_form);
        this.output = this.parentMaterial.getStack(output_form, 1);
        this.input = new IngredientWithSize(this.parentMaterial.getItemTag(input_form), 1);
        this.time = 800;
        this.energy = 64000;
        return this;
    }

    public IGBallmillMethod create(IFlagType<?> input_form, IFlagType<?> output_form, int time, int energy) {
        this.name = this.create_advanced_method_name(input_form, output_form);
        this.output = this.parentMaterial.getStack(output_form, 1);
        this.input = new IngredientWithSize(this.parentMaterial.getItemTag(input_form), 1);
        this.time = time;
        this.energy = energy;
        return this;
    }

    public IGBallmillMethod create(IFlagType<?> input_form, int input_amount, IFlagType<?> output_form, int output_amount, int time, int energy) {
        this.name = this.create_advanced_method_name(input_form, output_form);
        this.output = this.parentMaterial.getStack(output_form, input_amount);
        this.input = new IngredientWithSize(this.parentMaterial.getItemTag(input_form), output_amount);
        this.time = time;
        this.energy = energy;
        return this;
    }

    public IGBallmillMethod create(MaterialHelper input_mat, IFlagType<?> input_form, int input_amount, MaterialHelper output_mat, IFlagType<?> output_form, int output_amount, int time, int energy) {
        this.name = this.create_advanced_method_name(input_form, output_form);
        this.output = output_mat.getStack(output_form, input_amount);
        this.input = new IngredientWithSize(output_mat.getItemTag(input_form), output_amount);
        this.time = time;
        this.energy = energy;
        return this;
    }

    @Override
    @NotNull
    public IGRecipeMethod.RecipeMethod getMethod() {
        return IGRecipeMethod.RecipeMethod.REFINING;
    }

    @Override
    public ResourceLocation getLocation() {
        return this.toRL("ballmill/refine_" + this.getName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ItemStack getIconStack() {
        return IGMultiblockProvider.BALLMILL.iconStack();
    }

    @Override
    public void render(GuiGraphics graphics, ManualScreen screen, int x, int y, int mx, int my) {
        this.renderItemStack(graphics, this.input.getRandomizedExampleStack(0), x + 25, y + 2, mx, my);
        this.renderItemStack(graphics, this.output, x + 59, y + 2, mx, my);
    }

    @Override
    public void renderDisplayStack(GuiGraphics graphics, ManualScreen screen, int x, int y, int mx, int my) {
        this.renderItemStack(graphics, this.input.getRandomizedExampleStack(0), x, y, mx, my);
    }

    @Override
    public void renderFinalStack(GuiGraphics graphics, ManualScreen screen, int baseX, int baseY, int mx, int my) {
    }

    @Override
    public boolean build(Consumer<FinishedRecipe> consumer) {
        try {
            BallmillRecipeBuilder builder = BallmillRecipeBuilder.builder(this.output);
            builder.addInput(this.input);
            builder.setEnergy(this.energy);
            builder.setTime(this.time);
            builder.build(consumer, this.getLocation());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

