/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.helper.material.recipe.methods;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.builders.BlastFurnaceRecipeBuilder;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.lib.manual.gui.ManualScreen;
import com.igteam.immersivegeology.core.lib.IGLib;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialHelper;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeMethod;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeStage;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class IGBlastingMethod
extends IGRecipeMethod {
    private TagKey<Item> input;
    private ItemStack output;
    private String name;
    private ItemStack slag;
    private int time;

    public IGBlastingMethod(MaterialHelper parentMaterial, IGStageDesignation stage) {
        super(new IGRecipeStage(parentMaterial, stage){});
    }

    public IGBlastingMethod create(String method_name, TagKey<Item> input, ItemStack output) {
        this.input = input;
        this.output = output;
        this.name = method_name;
        this.slag = new ItemStack((ItemLike)IEItems.Ingredients.SLAG);
        this.time = 200;
        return this;
    }

    public IGBlastingMethod create(String method_name, TagKey<Item> input, ItemStack output, ItemStack slag) {
        this.input = input;
        this.output = output;
        this.name = method_name;
        this.slag = slag;
        this.time = 200;
        return this;
    }

    public IGBlastingMethod create(String method_name, TagKey<Item> input, ItemStack output, int time) {
        this.input = input;
        this.output = output;
        this.name = method_name;
        this.slag = new ItemStack((ItemLike)IEItems.Ingredients.SLAG);
        this.time = time;
        return this;
    }

    public IGBlastingMethod create(String method_name, TagKey<Item> input, ItemStack output, ItemStack slag, int time) {
        this.input = input;
        this.output = output;
        this.name = method_name;
        this.slag = slag;
        this.time = time;
        return this;
    }

    public IGBlastingMethod create(IFlagType<?> input_form, IFlagType<?> output_form, int time) {
        this.input = this.parentMaterial.getItemTag(input_form);
        this.output = this.parentMaterial.getStack(output_form, 1);
        this.name = this.create_advanced_method_name(input_form, output_form);
        this.slag = this.parentMaterial.getStack(ItemCategoryFlags.SLAG, 1);
        this.time = time;
        return this;
    }

    public IGBlastingMethod create(IFlagType<?> input_form, IFlagType<?> output_form, IFlagType<?> slag_form, int time) {
        this.input = this.parentMaterial.getItemTag(input_form);
        this.output = this.parentMaterial.getStack(output_form, 1);
        this.name = this.create_advanced_method_name(input_form, output_form);
        this.slag = this.parentMaterial.getStack(slag_form, 1);
        this.time = time;
        return this;
    }

    public IGBlastingMethod create(IFlagType<?> input_form, IFlagType<?> output_form, ItemStack slag, int time) {
        this.input = this.parentMaterial.getItemTag(input_form);
        this.output = this.parentMaterial.getStack(output_form, 1);
        this.name = this.create_advanced_method_name(input_form, output_form);
        this.slag = slag;
        this.time = time;
        return this;
    }

    public IGBlastingMethod create(MaterialHelper input_material, IFlagType<?> input_form, MaterialHelper output_material, IFlagType<?> output_form, MaterialHelper slag_material, IFlagType<?> slag_form, int time) {
        this.input = input_material.getItemTag(input_form);
        this.output = output_material.getStack(output_form, 1);
        this.name = this.create_advanced_method_name(input_form, output_form);
        this.slag = slag_material.getStack(slag_form, 1);
        this.time = time;
        return this;
    }

    public IGBlastingMethod create(MaterialHelper input_material, IFlagType<?> input_form, MaterialHelper output_material, IFlagType<?> output_form, ItemStack slag, int time) {
        this.input = input_material.getItemTag(input_form);
        this.output = output_material.getStack(output_form, 1);
        this.name = this.create_advanced_method_name(input_form, output_form);
        this.slag = slag;
        this.time = time;
        return this;
    }

    @Override
    @NotNull
    public IGRecipeMethod.RecipeMethod getMethod() {
        return IGRecipeMethod.RecipeMethod.BLASTING;
    }

    @Override
    public ResourceLocation getLocation() {
        return this.toRL("blasting/blast_" + this.getName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ItemStack getIconStack() {
        return new ItemStack((ItemLike)IEMultiblocks.BLAST_FURNACE.getBlock());
    }

    @Override
    public void render(GuiGraphics graphics, ManualScreen screen, int x, int y, int mx, int my) {
        IngredientWithSize ingredient = new IngredientWithSize(Ingredient.m_204132_(this.input));
        this.renderItemStack(graphics, ingredient.getRandomizedExampleStack(0), x + 25, y + 2, mx, my);
        this.renderItemStack(graphics, this.output, x + 59, y + 2, mx, my);
    }

    @Override
    public void renderDisplayStack(GuiGraphics graphics, ManualScreen screen, int x, int y, int mx, int my) {
    }

    @Override
    public void renderFinalStack(GuiGraphics graphics, ManualScreen screen, int x, int y, int mx, int my) {
    }

    @Override
    public boolean build(Consumer<FinishedRecipe> consumer) {
        try {
            BlastFurnaceRecipeBuilder builder = BlastFurnaceRecipeBuilder.builder((ItemStack)this.output);
            builder.addInput(this.input);
            builder.addSlag(this.slag);
            builder.setTime(this.time);
            builder.build(consumer, this.getLocation());
            return true;
        }
        catch (Exception e) {
            IGLib.IG_LOGGER.info("Failed To build due to {}", (Object)e.getMessage());
            return false;
        }
    }
}

