/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.helper.material.recipe.methods;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.lib.manual.gui.ManualScreen;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.builder.BloomeryRecipeBuilder;
import com.igteam.immersivegeology.core.lib.IGLib;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.material.MaterialHelper;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeMethod;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeStage;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import com.igteam.immersivegeology.core.registration.IGMultiblockProvider;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class IGBloomeryMethod
extends IGRecipeMethod {
    private int time;
    private String name;
    private IngredientWithSize itemInput;
    private ItemStack itemResult;

    public IGBloomeryMethod(MaterialHelper parentMaterial, IGStageDesignation stage) {
        super(new IGRecipeStage(parentMaterial, stage){});
    }

    public IGBloomeryMethod create(IFlagType<?> input, int inputAmount, MaterialHelper outputMaterial, IFlagType<?> output, int outputAmount, int time) {
        this.name = input.getName().toLowerCase() + "_" + this.parentMaterial.getName().toLowerCase() + "_to_" + output.getName().toLowerCase() + "_" + outputMaterial.getName().toLowerCase();
        this.itemResult = outputMaterial.getStack(output, outputAmount);
        this.itemInput = new IngredientWithSize(this.parentMaterial.getItemTag(input), inputAmount);
        this.time = time;
        return this;
    }

    public IGBloomeryMethod create(IFlagType<?> input, int inputAmount, IFlagType<?> output, int outputAmount, int time) {
        this.name = this.create_advanced_method_name(input, output);
        MaterialInterface<?> outputMaterial = this.parentMaterial.getPrimaryProduct();
        this.itemResult = outputMaterial.getStack(output, outputAmount);
        this.itemInput = new IngredientWithSize(this.parentMaterial.getItemTag(input), inputAmount);
        this.time = time;
        return this;
    }

    @Override
    @NotNull
    public IGRecipeMethod.RecipeMethod getMethod() {
        return IGRecipeMethod.RecipeMethod.BLOOMERY;
    }

    @Override
    public ResourceLocation getLocation() {
        return this.toRL("roasting/bloomery_" + this.getName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ItemStack getIconStack() {
        return IGMultiblockProvider.BLOOMERY.iconStack();
    }

    @Override
    public void render(GuiGraphics graphics, ManualScreen screen, int x, int y, int mx, int my) {
        this.renderItemStack(graphics, this.itemInput.getRandomizedExampleStack(0), x + 25, y + 2, mx, my);
        this.renderItemStack(graphics, this.itemResult, x + 59, y + 2, mx, my);
    }

    @Override
    public void renderDisplayStack(GuiGraphics graphics, ManualScreen screen, int x, int y, int mx, int my) {
    }

    @Override
    public void renderFinalStack(GuiGraphics graphics, ManualScreen screen, int baseX, int baseY, int mx, int my) {
    }

    @Override
    public boolean build(Consumer<FinishedRecipe> consumer) {
        IGLib.IG_LOGGER.info("Attempting Build for Bloomery Method {}", (Object)this.name);
        try {
            BloomeryRecipeBuilder builder = BloomeryRecipeBuilder.builder(this.itemResult);
            builder.addInput(this.itemInput);
            builder.setTime(this.time);
            builder.build(consumer, this.getLocation());
            return true;
        }
        catch (Exception e) {
            IGLib.IG_LOGGER.error("Exception Building Immersive Geology Crude Bloomery Recipe: {}", (Object)e.getMessage());
            return false;
        }
    }
}

