/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.helper.material.recipe.methods;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.lib.manual.gui.ManualScreen;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.builder.BasicChemicalRecipeBuilder;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.builder.ChemicalRecipeBuilder;
import com.igteam.immersivegeology.core.lib.IGLib;
import com.igteam.immersivegeology.core.material.data.enums.ChemicalEnum;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.material.MaterialHelper;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeMethod;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeStage;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import com.igteam.immersivegeology.core.registration.IGMultiblockProvider;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class IGChemicalMethod
extends IGRecipeMethod {
    private ItemStack itemOutput;
    private FluidStack fluidOutput;
    private IngredientWithSize itemIn;
    private FluidTagInput fluidInA;
    private FluidTagInput fluidInB;
    private FluidTagInput fluidInC;
    private int energy;
    private int time;
    private String name;

    public IGChemicalMethod(MaterialHelper material, IGStageDesignation stage) {
        super(new IGRecipeStage(material, stage){});
    }

    @Override
    @NotNull
    public IGRecipeMethod.RecipeMethod getMethod() {
        return IGRecipeMethod.RecipeMethod.CHEMICAL;
    }

    public IGChemicalMethod create(String name, ItemStack itemOutput, FluidStack fluidOutput, IngredientWithSize itemIn, FluidTagInput fluidInA, FluidTagInput fluidInB, FluidTagInput fluidInC, int time, int energy) {
        this.name = name;
        this.itemOutput = itemOutput;
        this.fluidOutput = fluidOutput;
        this.itemIn = itemIn;
        this.fluidInA = fluidInA;
        this.fluidInB = fluidInB;
        this.fluidInC = fluidInC;
        this.energy = energy;
        this.time = time;
        return this;
    }

    public IGChemicalMethod create(IFlagType<?> inputFlag, IFlagType<?> outputFlag, ItemStack itemOutput, FluidStack fluidOutput, IngredientWithSize itemIn, FluidTagInput fluidInA, FluidTagInput fluidInB, FluidTagInput fluidInC, int time, int energy) {
        this.name = this.create_basic_method_name(inputFlag, outputFlag);
        this.itemOutput = itemOutput;
        this.fluidOutput = fluidOutput;
        this.itemIn = itemIn;
        this.fluidInA = fluidInA;
        this.fluidInB = fluidInB;
        this.fluidInC = fluidInC;
        this.energy = energy;
        this.time = time;
        return this;
    }

    @Override
    public ResourceLocation getLocation() {
        return this.toRL("chemical_reactor/leach_" + this.getName());
    }

    @Override
    public ItemStack getIconStack() {
        return IGMultiblockProvider.CHEMICAL_REACTOR.iconStack();
    }

    @Override
    public void render(GuiGraphics graphics, ManualScreen screen, int x, int y, int mx, int my) {
        if (this.fluidInA != null && this.fluidInA.getRandomizedExampleStack(0) != null) {
            this.renderFluidStack(graphics, this.fluidInA.getRandomizedExampleStack(0), x + 15, y + 3, 16, 16, mx, my);
        }
        if (this.fluidInB != null && this.fluidInB.getRandomizedExampleStack(0) != null) {
            this.renderFluidStack(graphics, this.fluidInB.getRandomizedExampleStack(0), x + 15, y + 23, 16, 16, mx, my);
        }
        if (this.fluidInC != null && this.fluidInC.getRandomizedExampleStack(0) != null) {
            this.renderFluidStack(graphics, this.fluidInC.getRandomizedExampleStack(0), x + 15, y + 43, 16, 16, mx, my);
        }
        if (this.itemIn != null && !this.itemIn.hasNoMatchingItems()) {
            this.renderItemStack(graphics, this.itemIn.getRandomizedExampleStack(0), x + 34, y + 23, mx, my);
        }
        if (this.itemOutput != null && !this.itemOutput.m_41619_()) {
            this.renderItemStack(graphics, this.itemOutput, x + 70, y + 14, mx, my);
        }
        if (this.fluidOutput != null && !this.fluidOutput.isEmpty()) {
            this.renderFluidStack(graphics, this.fluidOutput, x + 70, y + 33, 16, 16, mx, my);
        }
    }

    @Override
    public void renderFinalStack(GuiGraphics graphics, ManualScreen screen, int baseX, int baseY, int mx, int my) {
    }

    @Override
    public void renderDisplayStack(GuiGraphics graphics, ManualScreen screen, int x, int y, int mx, int my) {
        if (this.itemIn != null && !this.itemIn.hasNoMatchingItems()) {
            this.renderItemStack(graphics, this.itemIn.getRandomizedExampleStack(0), x, y, mx, my);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean build(Consumer<FinishedRecipe> consumer) {
        try {
            ChemicalRecipeBuilder builder = ChemicalRecipeBuilder.builder(this.itemOutput, this.fluidOutput, this.itemIn, this.fluidInA, this.fluidInB, this.fluidInC);
            builder.setEnergy(this.energy);
            builder.setTime(this.time);
            builder.build(consumer, this.getLocation());
            int nullCount = 0;
            if (this.fluidInA == null) {
                ++nullCount;
            }
            if (this.fluidInB == null) {
                ++nullCount;
            }
            if (this.fluidInC == null) {
                ++nullCount;
            }
            if (nullCount >= 1) {
                ArrayList<FluidTagInput> tempFluids = new ArrayList<FluidTagInput>(2);
                if (this.fluidInA != null) {
                    tempFluids.add(this.fluidInA);
                }
                if (this.fluidInB != null) {
                    tempFluids.add(this.fluidInB);
                }
                if (this.fluidInC != null) {
                    tempFluids.add(this.fluidInC);
                }
                int damage = ChemicalEnum.getChemicalDamage((FluidTagInput)tempFluids.get(0)) + (nullCount == 1 ? ChemicalEnum.getChemicalDamage((FluidTagInput)tempFluids.get(0)) : 0);
                ((BasicChemicalRecipeBuilder)((BasicChemicalRecipeBuilder)BasicChemicalRecipeBuilder.builder(this.itemOutput, this.fluidOutput, this.itemIn, (FluidTagInput)tempFluids.get(0), nullCount == 2 ? null : (FluidTagInput)tempFluids.get(1), damage).setEnergy(this.energy / 2)).setTime(this.time)).build(consumer, this.toRL("small_chemical_reactor/leach_" + this.getName()));
            }
            return true;
        }
        catch (Exception e) {
            IGLib.IG_LOGGER.error("Error: {}", (Object)e.getMessage());
            return false;
        }
    }
}

