/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.helper.material.recipe.methods;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.lib.manual.gui.ManualScreen;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.builder.PelletizerRecipeBuilder;
import com.igteam.immersivegeology.core.material.data.enums.ChemicalEnum;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialHelper;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeMethod;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeStage;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import com.igteam.immersivegeology.core.registration.IGMultiblockProvider;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class IGPelletizerMethod
extends IGRecipeMethod {
    private int energy;
    private int time;
    private IngredientWithSize input;
    private ItemStack output;
    private String name;

    public IGPelletizerMethod(MaterialHelper parent, IGStageDesignation stage) {
        super(new IGRecipeStage(parent, stage){});
    }

    public IGPelletizerMethod create() {
        this.name = this.create_advanced_method_name(ItemCategoryFlags.POWDER, ItemCategoryFlags.PELLET);
        this.output = this.parentMaterial.getStack(ItemCategoryFlags.PELLET, 1);
        this.input = new IngredientWithSize(this.parentMaterial.getItemTag(ItemCategoryFlags.POWDER), 1);
        this.time = 600;
        this.energy = 4800;
        return this;
    }

    public IGPelletizerMethod create(MaterialHelper output_material) {
        this.name = this.create_advanced_method_name(ItemCategoryFlags.POWDER, ItemCategoryFlags.PELLET);
        this.output = output_material.getStack(ItemCategoryFlags.PELLET, 1);
        this.input = new IngredientWithSize(this.parentMaterial.getItemTag(ItemCategoryFlags.POWDER), 1);
        this.time = 600;
        this.energy = 4800;
        return this;
    }

    public IGPelletizerMethod create(IFlagType<?> input_form) {
        this.name = this.create_advanced_method_name(input_form, ItemCategoryFlags.PELLET);
        this.output = this.parentMaterial.getStack(ItemCategoryFlags.PELLET, 1);
        this.input = new IngredientWithSize(this.parentMaterial.getItemTag(input_form), 1);
        this.time = 600;
        this.energy = 4100;
        return this;
    }

    public IGPelletizerMethod create(IFlagType<?> input_form, MaterialHelper output_material) {
        this.name = this.create_advanced_method_name(input_form, ItemCategoryFlags.PELLET);
        this.output = output_material.getStack(ItemCategoryFlags.PELLET, 1);
        this.input = new IngredientWithSize(this.parentMaterial.getItemTag(input_form), 1);
        this.time = 600;
        this.energy = 4800;
        return this;
    }

    public IGPelletizerMethod create(IFlagType<?> input_form, IFlagType<?> output_form) {
        this.name = this.create_advanced_method_name(input_form, output_form);
        this.output = this.parentMaterial.getStack(output_form, 1);
        this.input = new IngredientWithSize(this.parentMaterial.getItemTag(input_form), 1);
        this.time = 600;
        this.energy = 4800;
        return this;
    }

    @Override
    @NotNull
    public IGRecipeMethod.RecipeMethod getMethod() {
        return IGRecipeMethod.RecipeMethod.PELLETIZE;
    }

    @Override
    public ResourceLocation getLocation() {
        return this.toRL("pelletizer/pelletize_" + this.getName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ItemStack getIconStack() {
        return IGMultiblockProvider.PELLETIZER.iconStack();
    }

    @Override
    public void render(GuiGraphics graphics, ManualScreen screen, int x, int y, int mx, int my) {
        this.renderItemStack(graphics, this.input.getRandomizedExampleStack(0), x + 34, y + 3, mx, my);
        this.renderItemStack(graphics, this.output, x + 68, y + 3, mx, my);
        this.renderFluidStack(graphics, ChemicalEnum.BindingAgent.getFluid(BlockCategoryFlags.FLUID), x + 16, y + 3, 16, 16, mx, my);
    }

    @Override
    public void renderDisplayStack(GuiGraphics graphics, ManualScreen screen, int x, int y, int mx, int my) {
        this.renderItemStack(graphics, this.input.getRandomizedExampleStack(0), x, y, mx, my);
    }

    @Override
    public void renderFinalStack(GuiGraphics graphics, ManualScreen screen, int baseX, int baseY, int mx, int my) {
    }

    @Override
    public boolean hasAdditionalInputRenders() {
        return true;
    }

    @Override
    public boolean build(Consumer<FinishedRecipe> consumer) {
        try {
            PelletizerRecipeBuilder builder = PelletizerRecipeBuilder.builder(this.output);
            builder.addInput(this.input);
            builder.setEnergy(this.energy);
            builder.setTime(this.time);
            builder.build(consumer, this.getLocation());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

