/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.helper.material.recipe.methods;

import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.gui.ManualScreen;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.builder.GravitySeparatorRecipeBuilder;
import com.igteam.immersivegeology.core.lib.IGLib;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialHelper;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeMethod;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeStage;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import com.igteam.immersivegeology.core.registration.IGMultiblockProvider;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

public class IGSeparatorMethod
extends IGRecipeMethod {
    private ItemStack result;
    private TagKey<Item> input;
    private ItemStack waste;
    private String name;
    private float waste_chance;
    private int time;
    private int water_amount;

    public IGSeparatorMethod(MaterialHelper parentMaterial, IGStageDesignation stage) {
        super(new IGRecipeStage(parentMaterial, stage){});
    }

    @Override
    @NotNull
    public IGRecipeMethod.RecipeMethod getMethod() {
        return IGRecipeMethod.RecipeMethod.SEPARATOR;
    }

    public IGSeparatorMethod create(TagKey<Item> input, ItemStack output, ItemStack waste, float waste_chance, int time, int water) {
        this.name = input.toString().substring(input.toString().lastIndexOf("/") + 1, input.toString().indexOf("]"));
        this.result = output;
        this.input = input;
        this.waste = waste;
        this.waste_chance = waste_chance;
        this.time = time;
        this.water_amount = water;
        return this;
    }

    public IGSeparatorMethod create(ItemCategoryFlags input, ItemCategoryFlags output, ItemStack waste, float waste_chance, int time, int water) {
        this.name = this.create_basic_method_name(input, output);
        this.result = this.parentMaterial.getStack(output, 1);
        this.input = this.parentMaterial.getItemTag(input);
        this.waste = waste;
        this.waste_chance = waste_chance;
        this.time = time;
        this.water_amount = water;
        return this;
    }

    @Override
    public ResourceLocation getLocation() {
        return this.toRL("wash/wash_" + this.getName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ItemStack getIconStack() {
        return IGMultiblockProvider.GRAVITY_SEPARATOR.iconStack();
    }

    @Override
    public void render(GuiGraphics graphics, ManualScreen screen, int x, int y, int mx, int my) {
        Ingredient ingredient = Ingredient.m_204132_(this.input);
        this.renderItemStack(graphics, ingredient.m_43908_()[0], x + 25, y + 11, mx, my);
        this.renderItemStack(graphics, this.result, x + 59, y + 2, mx, my);
        if (!this.waste.m_41619_()) {
            this.renderItemStack(graphics, this.waste, x + 59, y + 20, mx, my);
            ManualUtils.drawSplitString((GuiGraphics)graphics, (Font)screen.getManual().fontRenderer(), List.of(String.format("%.1f", Float.valueOf(this.waste_chance * 100.0f)) + "%"), (int)(x + 79), (int)(y + 24), (int)-8947849);
        }
        this.renderFluidStack(graphics, (Fluid)Fluids.f_76193_, x + 7, y + 11, 16, 16, mx, my);
    }

    @Override
    public void renderDisplayStack(GuiGraphics graphics, ManualScreen screen, int x, int y, int mx, int my) {
        Ingredient ingredient = Ingredient.m_204132_(this.input);
        this.renderItemStack(graphics, ingredient.m_43908_()[0], x, y, mx, my);
    }

    @Override
    public void renderFinalStack(GuiGraphics graphics, ManualScreen screen, int x, int y, int mx, int my) {
        this.renderItemStack(graphics, this.result, x - 7, y, mx, my);
        this.renderItemStack(graphics, this.waste, x + 8, y, mx, my);
    }

    @Override
    public boolean build(Consumer<FinishedRecipe> consumer) {
        try {
            GravitySeparatorRecipeBuilder builder = (GravitySeparatorRecipeBuilder)GravitySeparatorRecipeBuilder.builder(this.result).addInput((TagKey)this.input).setWater(this.water_amount).setByproduct(this.waste).setChance(this.waste_chance).setTime(this.time);
            builder.build(consumer, this.getLocation());
            return true;
        }
        catch (Exception e) {
            IGLib.IG_LOGGER.error("Error Building Gravity Separator Recipe: {}", (Object)e.getMessage());
            return false;
        }
    }
}

