/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.material.helper.material.recipe.methods;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.lib.manual.gui.ManualScreen;
import com.igteam.immersivegeology.common.block.multiblocks.recipe.builder.IndustrialSluiceRecipeBuilder;
import com.igteam.immersivegeology.core.material.helper.material.MaterialHelper;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeMethod;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGRecipeStage;
import com.igteam.immersivegeology.core.material.helper.material.recipe.IGStageDesignation;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class IGTrommelMethod
extends IGRecipeMethod {
    private int energy;
    private int time;
    private int water;
    private IngredientWithSize input;
    private ItemStack output;
    private NonNullList<StackWithChance> byproducts;
    private String name;

    public IGTrommelMethod(MaterialHelper parent, IGStageDesignation stage) {
        super(new IGRecipeStage(parent, stage){});
    }

    public void create(String name, TagKey<Item> input_item, int input_amount, ItemStack primary_output_item, int water_used, int energy_used, int time_taken, StackWithChance ... byproducts) {
        this.name = name;
        this.energy = energy_used;
        this.time = time_taken;
        this.water = water_used;
        this.input = new IngredientWithSize(input_item, input_amount);
        this.output = primary_output_item;
        this.byproducts = NonNullList.m_122779_();
        this.byproducts.addAll(Arrays.asList(byproducts));
    }

    @Override
    @NotNull
    public IGRecipeMethod.RecipeMethod getMethod() {
        return IGRecipeMethod.RecipeMethod.PELLETIZE;
    }

    @Override
    public ResourceLocation getLocation() {
        return this.toRL("trommel/wash_" + this.getName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ItemStack getIconStack() {
        return new ItemStack((ItemLike)Items.f_42410_);
    }

    @Override
    public void render(GuiGraphics graphics, ManualScreen screen, int x, int y, int mx, int my) {
    }

    @Override
    public void renderDisplayStack(GuiGraphics graphics, ManualScreen screen, int x, int y, int mx, int my) {
    }

    @Override
    public void renderFinalStack(GuiGraphics graphics, ManualScreen screen, int baseX, int baseY, int mx, int my) {
    }

    @Override
    public boolean build(Consumer<FinishedRecipe> consumer) {
        try {
            IndustrialSluiceRecipeBuilder builder = IndustrialSluiceRecipeBuilder.builder(this.output);
            builder.addInput(this.input);
            builder.setWater(this.water);
            builder.setEnergy(this.energy);
            builder.setTime(this.time);
            builder.setByproducts(this.byproducts);
            builder.build(consumer, this.getLocation());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

