/*
 * Decompiled with CFR 0.152.
 */
package com.igteam.immersivegeology.core.registration;

import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import blusunrize.immersiveengineering.api.multiblocks.blocks.MultiblockRegistration;
import blusunrize.immersiveengineering.api.multiblocks.blocks.MultiblockRegistrationBuilder;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.ComparatorManager;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IMultiblockComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.common.blocks.metal.MetalScaffoldingType;
import com.google.common.collect.ImmutableSet;
import com.igteam.immersivegeology.client.menu.IGItemGroup;
import com.igteam.immersivegeology.common.block.IGBlockContainerItem;
import com.igteam.immersivegeology.common.block.IGGenericBlock;
import com.igteam.immersivegeology.common.block.entity.cable.IGEnergyPipe;
import com.igteam.immersivegeology.common.block.entity.cable.IGEnergyPipeEntity;
import com.igteam.immersivegeology.common.block.entity.crate.IGCrateEntity;
import com.igteam.immersivegeology.common.block.entity.crate.IGCrateEntityType;
import com.igteam.immersivegeology.common.block.entity.vent.IGHydroVent;
import com.igteam.immersivegeology.common.block.entity.vent.IGHydroVentEntity;
import com.igteam.immersivegeology.common.block.helper.IGBlockType;
import com.igteam.immersivegeology.common.block.helper.OreRichness;
import com.igteam.immersivegeology.common.block.multiblocks.IGAlternatorMultiblock;
import com.igteam.immersivegeology.common.block.multiblocks.IGBallmillMultiblock;
import com.igteam.immersivegeology.common.block.multiblocks.IGBloomeryMultiblock;
import com.igteam.immersivegeology.common.block.multiblocks.IGCentrifugeMultiblock;
import com.igteam.immersivegeology.common.block.multiblocks.IGChemicalReactorMultiblock;
import com.igteam.immersivegeology.common.block.multiblocks.IGCoreDrillMultiblock;
import com.igteam.immersivegeology.common.block.multiblocks.IGCrystalizerMultiblock;
import com.igteam.immersivegeology.common.block.multiblocks.IGFoundryMultiblock;
import com.igteam.immersivegeology.common.block.multiblocks.IGGeothermalExchangerMultiblock;
import com.igteam.immersivegeology.common.block.multiblocks.IGGravitySeparatorMultiblock;
import com.igteam.immersivegeology.common.block.multiblocks.IGPelletizerMultiblock;
import com.igteam.immersivegeology.common.block.multiblocks.IGReverberationFurnaceMultiblock;
import com.igteam.immersivegeology.common.block.multiblocks.IGRotaryKilnMultiblock;
import com.igteam.immersivegeology.common.block.multiblocks.IGSmallChemicalReactorMultiblock;
import com.igteam.immersivegeology.common.block.multiblocks.IGSteamTurbineMultiblock;
import com.igteam.immersivegeology.common.block.multiblocks.logic.helper.IGMultiblockBuilder;
import com.igteam.immersivegeology.common.block.multiblocks.skins.IGAlternatorSkins;
import com.igteam.immersivegeology.common.block.multiblocks.skins.IGBloomerySkins;
import com.igteam.immersivegeology.common.block.multiblocks.skins.IGChemicalReactorSkins;
import com.igteam.immersivegeology.common.block.multiblocks.skins.IGCrystallizerSkins;
import com.igteam.immersivegeology.common.block.multiblocks.skins.IGGeothermalSkins;
import com.igteam.immersivegeology.common.block.multiblocks.skins.IGGravitySeparatorSkins;
import com.igteam.immersivegeology.common.block.multiblocks.skins.IGPelletizerSkins;
import com.igteam.immersivegeology.common.block.multiblocks.skins.IGRevFurnaceSkins;
import com.igteam.immersivegeology.common.block.multiblocks.skins.IGRotaryKilnSkins;
import com.igteam.immersivegeology.common.block.multiblocks.skins.IGSmallChemicalReactorSkins;
import com.igteam.immersivegeology.common.block.multiblocks.skins.IGSteamTurbineSkins;
import com.igteam.immersivegeology.common.block.ore.IGCrystalBlock;
import com.igteam.immersivegeology.common.block.ore.IGEvaporateMineralBlock;
import com.igteam.immersivegeology.common.block.ore.IGOreBlock;
import com.igteam.immersivegeology.common.block.ore.IGWeatheringOreBlock;
import com.igteam.immersivegeology.common.block.structural.IGFenceBlock;
import com.igteam.immersivegeology.common.block.structural.IGScaffoldingBlock;
import com.igteam.immersivegeology.common.block.structural.IGSlabBlock;
import com.igteam.immersivegeology.common.block.structural.IGStairBlock;
import com.igteam.immersivegeology.common.fluid.IGFluid;
import com.igteam.immersivegeology.common.fluid.IGFluidBlock;
import com.igteam.immersivegeology.common.item.IGCustomTool;
import com.igteam.immersivegeology.common.item.IGGenericBlockItem;
import com.igteam.immersivegeology.common.item.IGGenericBucketItem;
import com.igteam.immersivegeology.common.item.IGGenericDrillHead;
import com.igteam.immersivegeology.common.item.IGGenericItem;
import com.igteam.immersivegeology.common.item.IGGenericOreItem;
import com.igteam.immersivegeology.common.item.IGItemPellet;
import com.igteam.immersivegeology.common.item.IGMBFormationItem;
import com.igteam.immersivegeology.common.item.IGMineralTestingItem;
import com.igteam.immersivegeology.common.item.IGMultiblockSkinItem;
import com.igteam.immersivegeology.common.item.helper.IGFlagItem;
import com.igteam.immersivegeology.common.loot.IGLootModifier;
import com.igteam.immersivegeology.common.particle.IGParticles;
import com.igteam.immersivegeology.core.lib.IGLib;
import com.igteam.immersivegeology.core.lib.ResourceUtils;
import com.igteam.immersivegeology.core.material.GeologyMaterial;
import com.igteam.immersivegeology.core.material.data.enums.MetalEnum;
import com.igteam.immersivegeology.core.material.data.enums.MineralEnum;
import com.igteam.immersivegeology.core.material.data.enums.MiscEnum;
import com.igteam.immersivegeology.core.material.data.enums.StoneEnum;
import com.igteam.immersivegeology.core.material.data.types.MaterialChemical;
import com.igteam.immersivegeology.core.material.helper.flags.BlockCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.IFlagType;
import com.igteam.immersivegeology.core.material.helper.flags.ItemCategoryFlags;
import com.igteam.immersivegeology.core.material.helper.flags.MaterialFlags;
import com.igteam.immersivegeology.core.material.helper.flags.ModFlags;
import com.igteam.immersivegeology.core.material.helper.material.MaterialHelper;
import com.igteam.immersivegeology.core.material.helper.material.MaterialInterface;
import com.igteam.immersivegeology.core.registration.IGMenuTypes;
import com.igteam.immersivegeology.core.registration.IGMultiblockProvider;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.data.loading.DatagenModLoader;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class IGRegistrationHolder {
    private static final DeferredRegister<Block> BLOCK_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256747_, (String)"immersivegeology");
    private static final DeferredRegister<Item> ITEM_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256913_, (String)"immersivegeology");
    private static final DeferredRegister<Fluid> FLUID_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"immersivegeology");
    private static final DeferredRegister<FluidType> FLUIDTYPE_REGISTER = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"immersivegeology");
    private static final DeferredRegister<BlockEntityType<?>> TE_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_256922_, (String)"immersivegeology");
    public static final DeferredRegister<CreativeModeTab> TAB_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"immersivegeology");
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> LOOT_SERIALIZER_REGISTER = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"immersivegeology");
    private static final LinkedHashMap<String, RegistryObject<Block>> BLOCK_REGISTRY_MAP = new LinkedHashMap();
    private static final LinkedHashMap<String, RegistryObject<BlockEntityType<?>>> TE_REGISTRY_MAP = new LinkedHashMap();
    private static final LinkedHashMap<String, RegistryObject<Item>> ITEM_REGISTRY_MAP = new LinkedHashMap();
    private static final LinkedHashMap<String, RegistryObject<Fluid>> FLUID_REGISTRY_MAP = new LinkedHashMap();
    private static final LinkedHashMap<String, RegistryObject<FluidType>> FLUID_TYPE_REGISTRY_MAP = new LinkedHashMap();
    public static LinkedHashMap<String, MultiblockRegistration<?>> MB_REGISTRY_MAP = new LinkedHashMap();
    public static final LinkedHashMap<String, TemplateMultiblock> MB_TEMPLATE_MAP = new LinkedHashMap();
    public static Function<String, Item> getItem = key -> (Item)ITEM_REGISTRY_MAP.get(key).get();
    public static Function<String, Block> getBlock = key -> (Block)BLOCK_REGISTRY_MAP.get(key).get();
    public static Function<String, BlockEntityType<?>> getTE = key -> (BlockEntityType)TE_REGISTRY_MAP.get(key).get();
    public static Function<String, TemplateMultiblock> getMBTemplate = MB_TEMPLATE_MAP::get;
    public static Function<String, Fluid> getFluid = key -> (Fluid)FLUID_REGISTRY_MAP.get(key).get();
    public static final RegistryObject<CreativeModeTab> IG_BASE_TAB = TAB_REGISTER.register("main", () -> new CreativeModeTab.Builder(CreativeModeTab.Row.TOP, 0).m_257737_(() -> getItem.apply("prospector_kit").m_7968_()).m_257941_((Component)Component.m_237115_((String)"itemGroup.immersivegeology")).m_257501_(IGRegistrationHolder::fillIGTab).withTabFactory(IGItemGroup::new).withSearchBar().m_257652_());
    private static final List<Consumer<IEventBus>> MOD_BUS_CALLBACKS = new ArrayList<Consumer<IEventBus>>();
    public static RegistryObject<BlockEntityType<IGEnergyPipeEntity>> ENERGY_PIPE;
    public static RegistryObject<BlockEntityType<IGHydroVentEntity>> IG_HYDROVENT;
    public static RegistryObject<Codec<? extends IGlobalLootModifier>> IG_LOOT_MODIFICATION;

    private static <T extends MultiblockHandler.IMultiblock> T registerMultiblock(T multiblock) {
        MultiblockHandler.registerMultiblock(multiblock);
        return multiblock;
    }

    public static DeferredRegister<Block> getBlockRegister() {
        return BLOCK_REGISTER;
    }

    public static DeferredRegister<Item> getItemRegister() {
        return ITEM_REGISTER;
    }

    public static DeferredRegister<BlockEntityType<?>> getTeRegister() {
        return TE_REGISTER;
    }

    private static void fillIGTab(CreativeModeTab.ItemDisplayParameters parms, CreativeModeTab.Output out) {
        HashMap itemMap = new HashMap();
        for (Item item : IGRegistrationHolder.getIGItems()) {
            ArrayList list;
            if (!(item instanceof IGFlagItem)) continue;
            IGFlagItem iGFlagItem = (IGFlagItem)item;
            IFlagType<?> pattern = iGFlagItem.getFlag();
            if (itemMap.containsKey(pattern)) {
                list = (ArrayList)itemMap.get(pattern);
                list.add(item);
                itemMap.replace(pattern, list);
                continue;
            }
            list = new ArrayList();
            list.add(item);
            itemMap.put(pattern, list);
        }
        ArrayList<ItemCategoryFlags> allPatternList = new ArrayList<ItemCategoryFlags>(Arrays.asList(ItemCategoryFlags.values()));
        allPatternList.addAll(Arrays.asList(BlockCategoryFlags.values()));
        for (IFlagType iFlagType : allPatternList) {
            if (!itemMap.containsKey(iFlagType)) continue;
            ArrayList list = (ArrayList)itemMap.get(iFlagType);
            for (Item item : list) {
                out.m_246342_(new ItemStack((ItemLike)item));
            }
        }
    }

    private static boolean checkModMaterialsForOverlap(StoneEnum stoneType, GeologyMaterial ore, IFlagType<?> flag) {
        Map<ModFlags, Map<IFlagType<?>, MaterialHelper>> ore_map = ore.getExistingImplementationMap();
        for (ModFlags mod : ModFlags.values()) {
            if (!ore_map.containsKey(mod) || !ore_map.get(mod).containsKey(flag) || !stoneType.hasFlag(mod)) continue;
            return true;
        }
        return false;
    }

    private static MultiblockHandler.IMultiblock[] formationFormat(List<MultiblockHandler.IMultiblock> list) {
        MultiblockHandler.IMultiblock[] array = new MultiblockHandler.IMultiblock[list.size()];
        array = list.toArray(array);
        return array;
    }

    private static void registerBlockAndItem(String registryKey, BlockCategoryFlags blockCategory, MaterialInterface<?> material) {
        Supplier<Block> blockProvider = () -> new IGGenericBlock(blockCategory, material);
        IGRegistrationHolder.registerBlock(registryKey, blockProvider);
        IGRegistrationHolder.registerItem(registryKey, () -> new IGGenericBlockItem((IGGenericBlock)getBlock.apply(registryKey)){

            @Override
            @NotNull
            public Component m_7626_(ItemStack pStack) {
                return Component.m_237115_((String)this.m_5671_(pStack));
            }
        });
    }

    private static void registerBlockAndItem(String registryKey, BlockCategoryFlags blockCategory, MaterialInterface<?> material, BlockBehaviour.Properties properties) {
        Supplier<Block> blockProvider = () -> new IGGenericBlock(blockCategory, material, properties);
        IGRegistrationHolder.registerBlock(registryKey, blockProvider);
        IGRegistrationHolder.registerItem(registryKey, () -> new IGGenericBlockItem((IGGenericBlock)getBlock.apply(registryKey)){

            @Override
            @NotNull
            public Component m_7626_(ItemStack pStack) {
                return Component.m_237115_((String)this.m_5671_(pStack));
            }
        });
    }

    public static <T extends BlockEntity> Supplier<BlockEntityType<T>> makeType(BlockEntityType.BlockEntitySupplier<T> create, Supplier<? extends Block> valid) {
        return IGRegistrationHolder.makeTypeMultipleBlocks(create, (Collection<? extends Supplier<? extends Block>>)ImmutableSet.of(valid));
    }

    public static <T extends BlockEntity> Supplier<BlockEntityType<T>> makeTypeMultipleBlocks(BlockEntityType.BlockEntitySupplier<T> create, Collection<? extends Supplier<? extends Block>> valid) {
        return () -> new BlockEntityType(create, (Set)ImmutableSet.copyOf((Collection)valid.stream().map(Supplier::get).collect(Collectors.toList())), null);
    }

    /*
     * WARNING - void declaration
     */
    public static void initialize() {
        IGLib.IG_LOGGER.info("- Static Items and Blocks");
        IGRegistrationHolder.registerItem("prospector_kit", () -> new IGMineralTestingItem(ItemCategoryFlags.MISC, StoneEnum.MCStone, 128));
        IGRegistrationHolder.registerItem("prospector_kit_steel", () -> new IGMineralTestingItem(ItemCategoryFlags.MISC, MetalEnum.StainlessSteel, 4096));
        IGRegistrationHolder.registerItem(ItemCategoryFlags.HAMMER.getRegistryKey(MetalEnum.Bronze), () -> new IGMBFormationItem(ItemCategoryFlags.HAMMER, MetalEnum.Bronze, 256));
        IGRegistrationHolder.registerItem(ItemCategoryFlags.HAMMER.getRegistryKey(MetalEnum.StainlessSteel), () -> new IGMBFormationItem(ItemCategoryFlags.HAMMER, MetalEnum.StainlessSteel, 2048));
        IGRegistrationHolder.registerItem(ItemCategoryFlags.HAMMER.getRegistryKey(StoneEnum.MCStone), () -> new IGMBFormationItem(ItemCategoryFlags.HAMMER, StoneEnum.MCStone, 32));
        IGRegistrationHolder.registerItem("raw_fire_clay", () -> new IGGenericItem(ItemCategoryFlags.MISC, StoneEnum.MCStone, new Item.Properties().m_41486_()).setCustomLangString("raw_fire_clay"));
        IGRegistrationHolder.registerItem("refractory_brick", () -> new IGGenericItem(ItemCategoryFlags.MISC, MiscEnum.Refractory, new Item.Properties().m_41486_()).setCustomLangString("refractory_brick"));
        LinkedHashSet<MetalEnum> slurry_material_set = new LinkedHashSet<MetalEnum>(List.of(MetalEnum.values()));
        slurry_material_set.addAll(List.of(MineralEnum.values()));
        IGLib.IG_LOGGER.info("- Material Based Items, Blocks and Fluids");
        for (MaterialInterface materialInterface : IGLib.getGeologyMaterials()) {
            block23: for (IFlagType<?> flags : materialInterface.getFlags()) {
                boolean hasExistingImplementation = ((GeologyMaterial)materialInterface.instance()).checkExistingImplementation(flags) & !DatagenModLoader.isRunningDataGen();
                if (flags instanceof BlockCategoryFlags) {
                    BlockCategoryFlags blockCategory = (BlockCategoryFlags)flags;
                    switch (blockCategory) {
                        case DEFAULT_BLOCK: 
                        case STORAGE_BLOCK: 
                        case SHEETMETAL_BLOCK: 
                        case DUST_BLOCK: 
                        case GEODE_BLOCK: 
                        case ENGINEERING_BLOCK: 
                        case ADVANCED_ENGINEERING_BLOCK: {
                            if (hasExistingImplementation) continue block23;
                            String string = blockCategory.getRegistryKey(materialInterface);
                            Supplier<Block> blockProvider = () -> new IGGenericBlock(blockCategory, material);
                            IGRegistrationHolder.registerBlock(string, blockProvider);
                            IGRegistrationHolder.registerItem(string, () -> new IGGenericBlockItem((IGGenericBlock)getBlock.apply(string)));
                            break;
                        }
                        case EVAPORATE_CRYSTAL: {
                            String string = BlockCategoryFlags.EVAPORATE_CRYSTAL.getRegistryKey(materialInterface);
                            Supplier<Block> blockProvider = () -> new IGCrystalBlock(BlockCategoryFlags.EVAPORATE_CRYSTAL, material);
                            IGRegistrationHolder.registerBlock(string, blockProvider);
                            IGRegistrationHolder.registerItem(string, () -> new IGGenericBlockItem((IGBlockType)getBlock.apply(string)));
                            break;
                        }
                        case EVAPORATE: {
                            if (hasExistingImplementation) continue block23;
                            String string = blockCategory.getRegistryKey(materialInterface);
                            Supplier<Block> blockProvider = () -> new IGEvaporateMineralBlock(blockCategory, material, () -> (IGCrystalBlock)material.getBlock(BlockCategoryFlags.EVAPORATE_CRYSTAL));
                            IGRegistrationHolder.registerBlock(string, blockProvider);
                            IGRegistrationHolder.registerItem(string, () -> new IGGenericBlockItem((IGGenericBlock)getBlock.apply(string)));
                            break;
                        }
                        case ENERGY_PIPE: {
                            String string = blockCategory.getRegistryKey(materialInterface);
                            IGRegistrationHolder.registerBlock(string, () -> new IGEnergyPipe(blockCategory, material));
                            IGRegistrationHolder.registerItem(string, () -> new IGGenericBlockItem((IGBlockType)getBlock.apply(string)));
                            break;
                        }
                        case HYDROVENT: {
                            RegistryObject TYPE;
                            String string = blockCategory.getRegistryKey(materialInterface);
                            RegistryObject registryObject = TYPE = TE_REGISTER.register(materialInterface.getName() + "_vent_entity_type", IGRegistrationHolder.makeType(IGHydroVentEntity::new, () -> getBlock.apply(string)));
                            TE_REGISTRY_MAP.put(string, registryObject);
                            IGRegistrationHolder.registerBlock(string, () -> new IGHydroVent(blockCategory, material, (RegistryObject<BlockEntityType<IGHydroVentEntity>>)TYPE));
                            IGRegistrationHolder.registerItem(string, () -> new IGGenericBlockItem((IGBlockType)getBlock.apply(string)));
                            break;
                        }
                        case CRATE: {
                            RegistryObject TYPE;
                            String string = blockCategory.getRegistryKey(materialInterface);
                            RegistryObject registryObject = TYPE = TE_REGISTER.register(materialInterface.getName() + "_crate_entity_type", IGRegistrationHolder.makeType(IGCrateEntity::new, () -> getBlock.apply(string)));
                            TE_REGISTRY_MAP.put(string, registryObject);
                            IGRegistrationHolder.registerBlock(string, () -> new IGCrateEntityType(blockCategory, material, (RegistryObject<BlockEntityType<IGCrateEntity>>)TYPE));
                            IGRegistrationHolder.registerItem(string, () -> new IGBlockContainerItem((IGBlockType)getBlock.apply(string)));
                            break;
                        }
                        case ORE_BLOCK: {
                            void var9_38;
                            StoneEnum[] stoneEnumArray = StoneEnum.values();
                            int TYPE = stoneEnumArray.length;
                            boolean bl = false;
                            while (var9_38 < TYPE) {
                                StoneEnum stoneEnum = stoneEnumArray[var9_38];
                                if (stoneEnum.hasFlag(MaterialFlags.IS_ORE_BEARING) && ((GeologyMaterial)materialInterface.instance()).acceptableStoneType(stoneEnum.instance()) && !(Arrays.stream(ModFlags.values()).anyMatch(m -> !m.isStrictlyLoaded() && base.hasFlag((IFlagType<?>)m)) & !DatagenModLoader.isRunningDataGen()) && !IGRegistrationHolder.checkModMaterialsForOverlap(stoneEnum, materialInterface.instance(), flags)) {
                                    for (OreRichness richness : OreRichness.values()) {
                                        String registryKey = blockCategory.getRegistryKey(materialInterface, stoneEnum, richness);
                                        Supplier<Block> blockProvider = () -> material.canTarnish() ? new IGWeatheringOreBlock(blockCategory, base, material, richness) : new IGOreBlock(blockCategory, base, material, richness);
                                        IGRegistrationHolder.registerBlock(registryKey, blockProvider);
                                        IGRegistrationHolder.registerItem(registryKey, () -> new IGGenericBlockItem((IGBlockType)getBlock.apply(registryKey)));
                                    }
                                }
                                ++var9_38;
                            }
                            break;
                        }
                        case SLAB: 
                        case SHEETMETAL_SLAB: {
                            if (hasExistingImplementation) continue block23;
                            String string = blockCategory.getRegistryKey(materialInterface);
                            Supplier<Block> blockProvider = () -> new IGSlabBlock(blockCategory, material);
                            IGRegistrationHolder.registerBlock(string, blockProvider);
                            IGRegistrationHolder.registerItem(string, () -> new IGGenericBlockItem((IGBlockType)getBlock.apply(string)));
                            break;
                        }
                        case SCAFFOLDING: {
                            void var9_40;
                            if (hasExistingImplementation) continue block23;
                            MetalScaffoldingType[] metalScaffoldingTypeArray = MetalScaffoldingType.values();
                            int blockProvider = metalScaffoldingTypeArray.length;
                            boolean bl = false;
                            while (var9_40 < blockProvider) {
                                MetalScaffoldingType metalScaffoldingType = metalScaffoldingTypeArray[var9_40];
                                String registryKey = blockCategory.getRegistryKey(materialInterface) + "_" + metalScaffoldingType.name().toLowerCase();
                                Supplier<Block> blockProvider2 = () -> new IGScaffoldingBlock(metalScaffoldingType, materialInterface);
                                IGRegistrationHolder.registerBlock(registryKey, blockProvider2);
                                IGRegistrationHolder.registerItem(registryKey, () -> new IGGenericBlockItem((IGBlockType)getBlock.apply(registryKey)));
                                ++var9_40;
                            }
                            break;
                        }
                        case FENCE: {
                            if (hasExistingImplementation) continue block23;
                            String string = blockCategory.getRegistryKey(materialInterface);
                            Supplier<Block> blockProvider = () -> new IGFenceBlock(blockCategory, material);
                            IGRegistrationHolder.registerBlock(string, blockProvider);
                            IGRegistrationHolder.registerItem(string, () -> new IGGenericBlockItem((IGBlockType)getBlock.apply(string)));
                            break;
                        }
                        case STAIRS: 
                        case SHEETMETAL_STAIRS: {
                            if (hasExistingImplementation) continue block23;
                            String string = blockCategory.getRegistryKey(materialInterface);
                            Supplier<BlockState> stateSupplier = () -> ((Block)Blocks.f_50075_).m_49966_();
                            Supplier<Block> supplier = () -> new IGStairBlock(stateSupplier, material, blockCategory);
                            IGRegistrationHolder.registerBlock(string, supplier);
                            IGRegistrationHolder.registerItem(string, () -> new IGGenericBlockItem((IGBlockType)getBlock.apply(string)));
                            break;
                        }
                        case FLUID: {
                            if (hasExistingImplementation) continue block23;
                            String string = blockCategory.getRegistryKey(materialInterface);
                            ItemCategoryFlags bucket_type = materialInterface instanceof MetalEnum ? ItemCategoryFlags.BUCKET : ItemCategoryFlags.CLEAN_FLASK;
                            IGRegistrationHolder.registerFluid(string, () -> new IGFluid.Source(material, null, blockCategory, bucket_type));
                            IGRegistrationHolder.registerFluid(string + "_flowing", () -> new IGFluid.Flowing(material, null, blockCategory, bucket_type));
                            IGRegistrationHolder.registerFluidType(string, () -> getFluid.apply(string).getFluidType());
                            IGRegistrationHolder.registerItem(bucket_type.getRegistryKey(materialInterface, blockCategory), () -> new IGGenericBucketItem(() -> getFluid.apply(string), blockCategory, bucket_type, materialInterface));
                            IGRegistrationHolder.registerBlock(string + "_block", () -> new IGFluidBlock(() -> (FlowingFluid)getFluid.apply(string), materialInterface, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_)));
                            break;
                        }
                        case SLURRY: {
                            Object t = materialInterface.instance();
                            if (!(t instanceof MaterialChemical)) break;
                            MaterialChemical materialChemical = (MaterialChemical)t;
                            for (MaterialInterface materialInterface2 : slurry_material_set) {
                                if (!materialChemical.hasSlurryWith(materialInterface2)) continue;
                                String string = blockCategory.getRegistryKey(materialInterface, materialInterface2);
                                IGRegistrationHolder.registerFluidType(string, () -> getFluid.apply(registryKey).getFluidType());
                                IGRegistrationHolder.registerFluid(string, () -> new IGFluid.Source(material, slurry_material, blockCategory, ItemCategoryFlags.CLEAN_FLASK));
                                IGRegistrationHolder.registerFluid(string + "_flowing", () -> new IGFluid.Flowing(material, slurry_material, blockCategory, ItemCategoryFlags.CLEAN_FLASK));
                                IGRegistrationHolder.registerBlock(string + "_block", () -> new IGFluidBlock(() -> (FlowingFluid)getFluid.apply(registryKey), material, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_)));
                                IGRegistrationHolder.registerItem(ItemCategoryFlags.CLEAN_FLASK.getRegistryKey(materialInterface, materialInterface2), () -> new IGGenericBucketItem(() -> getFluid.apply(registryKey), blockCategory, ItemCategoryFlags.CLEAN_FLASK, materialInterface, slurry_material));
                            }
                            break;
                        }
                        case CLOUDY_SLURRY: {
                            Object t = materialInterface.instance();
                            if (!(t instanceof MaterialChemical)) break;
                            MaterialChemical materialChemical = (MaterialChemical)t;
                            for (MaterialInterface materialInterface3 : slurry_material_set) {
                                if (!materialChemical.hasSlurryWith(materialInterface3) || materialInterface3 instanceof MetalEnum) continue;
                                String string = blockCategory.getRegistryKey(materialInterface, materialInterface3);
                                IGRegistrationHolder.registerFluidType(string, () -> getFluid.apply(registryKey).getFluidType());
                                IGRegistrationHolder.registerFluid(string, () -> new IGFluid.Source(material, slurry_material, blockCategory, ItemCategoryFlags.CLOUDY_FLASK));
                                IGRegistrationHolder.registerFluid(string + "_flowing", () -> new IGFluid.Flowing(material, slurry_material, blockCategory, ItemCategoryFlags.CLOUDY_FLASK));
                                IGRegistrationHolder.registerBlock(string + "_block", () -> new IGFluidBlock(() -> (FlowingFluid)getFluid.apply(registryKey), material, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_)));
                                IGRegistrationHolder.registerItem(ItemCategoryFlags.CLOUDY_FLASK.getRegistryKey(materialInterface, materialInterface3), () -> new IGGenericBucketItem(() -> getFluid.apply(registryKey), blockCategory, ItemCategoryFlags.CLOUDY_FLASK, materialInterface, slurry_material));
                            }
                            break;
                        }
                    }
                }
                if (!(flags instanceof ItemCategoryFlags)) continue;
                ItemCategoryFlags itemCategoryFlags = (ItemCategoryFlags)flags;
                switch (itemCategoryFlags) {
                    case POOR_ORE: 
                    case NORMAL_ORE: 
                    case RICH_ORE: {
                        if (hasExistingImplementation) continue block23;
                        IGRegistrationHolder.registerItem(itemCategoryFlags.getRegistryKey(materialInterface), () -> new IGGenericOreItem(itemCategoryFlags, material));
                        continue block23;
                    }
                    case PELLET: 
                    case OXIDE_PELLET: {
                        if (hasExistingImplementation) continue block23;
                        IGRegistrationHolder.registerItem(itemCategoryFlags.getRegistryKey(materialInterface), () -> new IGItemPellet(itemCategoryFlags, material));
                        continue block23;
                    }
                    case DRILL_HEAD: {
                        IGRegistrationHolder.registerItem(itemCategoryFlags.getRegistryKey(materialInterface), () -> new IGGenericDrillHead(itemCategoryFlags, material));
                        continue block23;
                    }
                    case TOOL_HOE: {
                        IGRegistrationHolder.registerItem(itemCategoryFlags.getRegistryKey(materialInterface), () -> new IGCustomTool(material.getToolTier(), material.getToolDamage(), material.getToolSpeed(), itemCategoryFlags, material));
                        continue block23;
                    }
                }
                if (hasExistingImplementation) continue;
                IGRegistrationHolder.registerItem(itemCategoryFlags.getRegistryKey(materialInterface), () -> new IGGenericItem(itemCategoryFlags, material));
            }
        }
        ENERGY_PIPE = TE_REGISTER.register("energy_pipe_type", IGRegistrationHolder.makeType(IGEnergyPipeEntity::new, () -> MiscEnum.Cable.getBlock(BlockCategoryFlags.ENERGY_PIPE)));
        IGLib.IG_LOGGER.info("Finished");
    }

    public static MultiblockRegistration<?> getMB(String key) {
        return MB_REGISTRY_MAP.get(key);
    }

    public static void initializeMultiblocks() {
        IGLib.IG_LOGGER.info("- Multiblocks");
        IGRegistrationHolder.registerMB("gravity_separator", IGGravitySeparatorMultiblock.INSTANCE, IGMultiblockProvider.GRAVITY_SEPARATOR, IGGravitySeparatorSkins.class);
        IGRegistrationHolder.registerMB("crystallizer", IGCrystalizerMultiblock.INSTANCE, IGMultiblockProvider.CRYSTALLIZER, IGCrystallizerSkins.class);
        IGRegistrationHolder.registerMB("bloomery", IGBloomeryMultiblock.INSTANCE, IGMultiblockProvider.BLOOMERY, IGBloomerySkins.class);
        IGRegistrationHolder.registerMB("chemical_reactor", IGChemicalReactorMultiblock.INSTANCE, IGMultiblockProvider.CHEMICAL_REACTOR, IGChemicalReactorSkins.class);
        IGRegistrationHolder.registerMB("rotary_kiln", IGRotaryKilnMultiblock.INSTANCE, IGMultiblockProvider.ROTARYKILN, IGRotaryKilnSkins.class);
        IGRegistrationHolder.registerMB("reverberation_furnace", IGReverberationFurnaceMultiblock.INSTANCE, IGMultiblockProvider.REVERBERATION_FURNACE, IGRevFurnaceSkins.class);
        IGRegistrationHolder.registerMB("geothermal_exchanger", IGGeothermalExchangerMultiblock.INSTANCE, IGMultiblockProvider.GEOTHERMAL_EXCHANGER, IGGeothermalSkins.class);
        IGRegistrationHolder.registerMB("pelletizer", IGPelletizerMultiblock.INSTANCE, IGMultiblockProvider.PELLETIZER, IGPelletizerSkins.class);
        IGRegistrationHolder.registerMB("steam_turbine", IGSteamTurbineMultiblock.INSTANCE, IGMultiblockProvider.STEAM_TURBINE, IGSteamTurbineSkins.class);
        IGRegistrationHolder.registerMB("small_chemical_reactor", IGSmallChemicalReactorMultiblock.INSTANCE, IGMultiblockProvider.SMALL_CHEMICAL_REACTOR, IGSmallChemicalReactorSkins.class);
        IGRegistrationHolder.registerMB("alternator", IGAlternatorMultiblock.INSTANCE, IGMultiblockProvider.ALTERNATOR, IGAlternatorSkins.class);
        IGRegistrationHolder.registerMB("coredrill", IGCoreDrillMultiblock.INSTANCE, IGMultiblockProvider.COREDRILL);
        IGRegistrationHolder.registerMB("centrifuge", IGCentrifugeMultiblock.INSTANCE, IGMultiblockProvider.CENTRIFUGE);
        IGRegistrationHolder.registerMB("ballmill", IGBallmillMultiblock.INSTANCE, IGMultiblockProvider.BALLMILL);
        IGRegistrationHolder.registerMB("foundry", IGFoundryMultiblock.INSTANCE, IGMultiblockProvider.FOUNDRY);
    }

    private static <T extends Enum<T> & StringRepresentable> void registerMB(String registry_name, TemplateMultiblock block, MultiblockRegistration<?> registration, Class<T> skins) {
        for (Enum skin : (Enum[])skins.getEnumConstants()) {
            IGRegistrationHolder.registerItem(registry_name + "_multiblock_skin_" + ((StringRepresentable)skin).m_7912_(), () -> new IGMultiblockSkinItem<Enum>(ItemCategoryFlags.SKIN_COMPONENT, MetalEnum.Cobalt, skin, registry_name + "_multiblock_skin_" + ((StringRepresentable)skin).m_7912_()));
        }
        IGRegistrationHolder.registerMB(registry_name, block, registration);
    }

    private static void registerMB(String registry_name, TemplateMultiblock block, MultiblockRegistration<?> registration) {
        IGRegistrationHolder.registerMultiblockTemplate(registry_name, block);
        MB_REGISTRY_MAP.put(registry_name, registration);
    }

    public static Supplier<List<? extends Item>> supplyDeferredItems() {
        return () -> ITEM_REGISTER.getEntries().stream().map(RegistryObject::get).toList();
    }

    public static Supplier<List<? extends Block>> supplyDeferredBlocks() {
        return () -> BLOCK_REGISTER.getEntries().stream().map(RegistryObject::get).toList();
    }

    public static Supplier<List<? extends Fluid>> supplyDeferredFluids() {
        return () -> FLUID_REGISTER.getEntries().stream().map(RegistryObject::get).toList();
    }

    public static void registerMultiblockTemplate(String registry_name, TemplateMultiblock template) {
        MB_TEMPLATE_MAP.put(registry_name, IGRegistrationHolder.registerMultiblock(template));
    }

    public static void registerItem(String registry_name, Supplier<Item> itemSupplier) {
        ITEM_REGISTRY_MAP.put(registry_name, (RegistryObject<Item>)ITEM_REGISTER.register(registry_name, itemSupplier));
    }

    public static void registerBlock(String registry_name, Supplier<Block> blockSupplier) {
        BLOCK_REGISTRY_MAP.put(registry_name, (RegistryObject<Block>)BLOCK_REGISTER.register(registry_name, blockSupplier));
    }

    public static void registerFluid(String registry_name, Supplier<Fluid> fluidSupplier) {
        FLUID_REGISTRY_MAP.put(registry_name, (RegistryObject<Fluid>)FLUID_REGISTER.register(registry_name, fluidSupplier));
    }

    public static void registerFluidType(String registry_name, Supplier<FluidType> fluidTypeSupplier) {
        FLUID_TYPE_REGISTRY_MAP.put(registry_name, (RegistryObject<FluidType>)FLUIDTYPE_REGISTER.register(registry_name, fluidTypeSupplier));
    }

    public static void addRegistersToEventBus(IEventBus eventBus) {
        IGLib.IG_LOGGER.info("======== Registration of Immersive Geology Items, Blocks and Fluids ========");
        IGLib.IG_LOGGER.info("- Block Registration");
        BLOCK_REGISTER.register(eventBus);
        IGLib.IG_LOGGER.info("- Item Registration");
        ITEM_REGISTER.register(eventBus);
        IGLib.IG_LOGGER.info("- Fluid Registration");
        FLUID_REGISTER.register(eventBus);
        IGLib.IG_LOGGER.info("- Fluid Type Registration");
        FLUIDTYPE_REGISTER.register(eventBus);
        IGLib.IG_LOGGER.info("- Tile Entity Registration");
        TE_REGISTER.register(eventBus);
        IGLib.IG_LOGGER.info("- Custom Creative Tab Registration");
        TAB_REGISTER.register(eventBus);
        IGLib.IG_LOGGER.info("- Custom Global Loot Modifier");
        LOOT_SERIALIZER_REGISTER.register(eventBus);
        IGLib.IG_LOGGER.info("- Custom Particle Type Registration");
        IGParticles.register(eventBus);
        IGLib.IG_LOGGER.info("- Custom Menu Type Registration");
        IGMenuTypes.REGISTER.register(eventBus);
        MOD_BUS_CALLBACKS.forEach(e -> e.accept(eventBus));
    }

    public static List<Item> getIGItems() {
        return ITEM_REGISTER.getEntries().stream().map(RegistryObject::get).collect(Collectors.toList());
    }

    public static <S extends IMultiblockState> MultiblockRegistration<S> registerMetalMultiblock(String name, IMultiblockLogic<S> logic, Supplier<TemplateMultiblock> structure) {
        return IGRegistrationHolder.registerMetalMultiblock(name, logic, structure, null);
    }

    public static <S extends IMultiblockState> MultiblockRegistration<S> registerMetalMultiblock(String name, IMultiblockLogic<S> logic, Supplier<TemplateMultiblock> structure, @Nullable Consumer<IGMultiblockBuilder<S>> extras) {
        BlockBehaviour.Properties prop = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60918_(SoundType.f_56743_).m_60913_(3.0f, 15.0f).m_60999_().m_60971_((state, blockReader, pos) -> false).m_60955_().m_60988_().m_278166_(PushReaction.BLOCK);
        return IGRegistrationHolder.registerMultiblock(name, logic, structure, extras, prop);
    }

    public static <S extends IMultiblockState> MultiblockRegistration<S> registerMultiblock(String name, IMultiblockLogic<S> logic, Supplier<TemplateMultiblock> structure, @Nullable Consumer<IGMultiblockBuilder<S>> extras, BlockBehaviour.Properties prop) {
        IGMultiblockBuilder builder = (IGMultiblockBuilder)((IGMultiblockBuilder)((IGMultiblockBuilder)new IGMultiblockBuilder<S>(logic, name).structure(structure)).defaultBEs(TE_REGISTER)).defaultBlock(BLOCK_REGISTER, ITEM_REGISTER, prop);
        if (extras != null) {
            extras.accept(builder);
        }
        return builder.build();
    }

    public static LinkedHashMap<String, RegistryObject<Item>> getItemRegistryMap() {
        return ITEM_REGISTRY_MAP;
    }

    public static LinkedHashMap<String, RegistryObject<Fluid>> getFluidRegistryMap() {
        return FLUID_REGISTRY_MAP;
    }

    public static HashMap<String, RegistryObject<Block>> getBlockRegistryMap() {
        return BLOCK_REGISTRY_MAP;
    }

    public static void buildMaterialRecipes() {
        IGLib.IG_LOGGER.info("- Building Material Recipes");
        IGLib.getGeologyMaterials().forEach(MaterialInterface::buildRecipe);
        MaterialHelper.logRecipeStages();
        IGLib.IG_LOGGER.info("- Complete");
    }

    public static void initializeLootModifications() {
        IG_LOOT_MODIFICATION = LOOT_SERIALIZER_REGISTER.register("ig_loot_modification", () -> IGLootModifier.CODEC);
    }

    public static ResourceLocation getRegistryNameOf(Block block) {
        return BuiltInRegistries.f_256975_.m_7981_((Object)block);
    }

    protected static class MultiblockBuilder<S extends IMultiblockState>
    extends MultiblockRegistrationBuilder<S, MultiblockBuilder<S>> {
        public MultiblockBuilder(IMultiblockLogic<S> logic, String name) {
            super(logic, ResourceUtils.ig(name));
        }

        public MultiblockBuilder<S> redstone(IMultiblockComponent.StateWrapper<S, RedstoneControl.RSState> getState, BlockPos ... positions) {
            this.redstoneAware();
            return (MultiblockBuilder)this.selfWrappingComponent((IMultiblockComponent)new RedstoneControl(getState, positions));
        }

        public MultiblockBuilder<S> comparator(ComparatorManager<S> comparator) {
            this.withComparator();
            return (MultiblockBuilder)super.selfWrappingComponent(comparator);
        }

        protected MultiblockBuilder<S> self() {
            return this;
        }
    }
}

