/*
 * Decompiled with CFR 0.152.
 */
package com.nyronium.stardust.content.enchantment.armor.helmet;

import com.nyronium.stardust.content.infrastructure.EnchantmentConfiguration;
import com.nyronium.stardust.content.infrastructure.ObtainingConfiguration;
import com.nyronium.stardust.content.infrastructure.StardustEnchantment;
import com.nyronium.stardust.core.StardustUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/nyronium/stardust/content/enchantment/armor/helmet/ConsumptionEnchantment;", "Lcom/nyronium/stardust/content/infrastructure/StardustEnchantment;", "<init>", "()V", "onLivingStartUseItem", "", "event", "Lnet/minecraftforge/event/entity/living/LivingEntityUseItemEvent$Start;", "stardust"})
@SourceDebugExtension(value={"SMAP\nConsumptionEnchantment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsumptionEnchantment.kt\ncom/nyronium/stardust/content/enchantment/armor/helmet/ConsumptionEnchantment\n+ 2 Forge.kt\nthedarkcolour/kotlinforforge/forge/ForgeKt\n*L\n1#1,35:1\n27#2:36\n*S KotlinDebug\n*F\n+ 1 ConsumptionEnchantment.kt\ncom/nyronium/stardust/content/enchantment/armor/helmet/ConsumptionEnchantment\n*L\n22#1:36\n*E\n"})
public final class ConsumptionEnchantment
extends StardustEnchantment {
    public ConsumptionEnchantment() {
        EquipmentSlot[] equipmentSlotArray = new EquipmentSlot[]{EquipmentSlot.HEAD};
        super(new EnchantmentConfiguration().maxLevel(3).obtaining(new ObtainingConfiguration(Enchantment.Rarity.RARE).default()).category(EnchantmentCategory.ARMOR_HEAD).applicableSlots(equipmentSlotArray));
        boolean $i$f$getFORGE_BUS = false;
        IEventBus iEventBus = MinecraftForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus, (String)"EVENT_BUS");
        iEventBus.addListener(this::onLivingStartUseItem);
    }

    public final void onLivingStartUseItem(@NotNull LivingEntityUseItemEvent.Start event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        Intrinsics.checkNotNull((Object)livingEntity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
        Player player = (Player)livingEntity;
        ItemStack itemStack = player.m_6844_(EquipmentSlot.HEAD);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemBySlot(...)");
        if (!StardustUtils.INSTANCE.hasEnchantment(itemStack, this)) {
            return;
        }
        ItemStack itemStack2 = player.m_6844_(EquipmentSlot.HEAD);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getItemBySlot(...)");
        int consumptionLevel = StardustUtils.INSTANCE.getLevel(itemStack2, this);
        if (event.getItem().m_41780_() != UseAnim.EAT && event.getItem().m_41780_() != UseAnim.DRINK) {
            return;
        }
        event.setDuration(event.getDuration() / (1 + consumptionLevel / this.m_6586_()));
    }
}

