/*
 * Decompiled with CFR 0.152.
 */
package com.nyronium.stardust.content.enchantment.weapon.axe;

import com.nyronium.stardust.content.infrastructure.EnchantmentConfiguration;
import com.nyronium.stardust.content.infrastructure.ObtainingConfiguration;
import com.nyronium.stardust.content.infrastructure.StardustEnchantment;
import com.nyronium.stardust.core.StardustCategories;
import com.nyronium.stardust.core.StardustUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/nyronium/stardust/content/enchantment/weapon/axe/KineticEnchantment;", "Lcom/nyronium/stardust/content/infrastructure/StardustEnchantment;", "<init>", "()V", "onLivingHurt", "", "event", "Lnet/minecraftforge/event/entity/living/LivingHurtEvent;", "stardust"})
@SourceDebugExtension(value={"SMAP\nKineticEnchantment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KineticEnchantment.kt\ncom/nyronium/stardust/content/enchantment/weapon/axe/KineticEnchantment\n+ 2 Forge.kt\nthedarkcolour/kotlinforforge/forge/ForgeKt\n*L\n1#1,39:1\n27#2:40\n*S KotlinDebug\n*F\n+ 1 KineticEnchantment.kt\ncom/nyronium/stardust/content/enchantment/weapon/axe/KineticEnchantment\n*L\n21#1:40\n*E\n"})
public final class KineticEnchantment
extends StardustEnchantment {
    public KineticEnchantment() {
        EquipmentSlot[] equipmentSlotArray = new EquipmentSlot[]{EquipmentSlot.MAINHAND};
        super(new EnchantmentConfiguration().maxLevel(5).obtaining(ObtainingConfiguration.loot$default(new ObtainingConfiguration(Enchantment.Rarity.UNCOMMON).default(), "chests/end_city_treasure", 0.25f, null, null, 12, null)).category(StardustCategories.INSTANCE.getAXE()).applicableSlots(equipmentSlotArray));
        boolean $i$f$getFORGE_BUS = false;
        IEventBus iEventBus = MinecraftForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus, (String)"EVENT_BUS");
        iEventBus.addListener(this::onLivingHurt);
    }

    public final void onLivingHurt(@NotNull LivingHurtEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (event.getSource().m_7639_() == null) {
            return;
        }
        if (!(event.getSource().m_7639_() instanceof Player)) {
            return;
        }
        Entity entity = event.getSource().m_7639_();
        Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
        Player attacker = (Player)entity;
        ItemStack itemStack = attacker.m_6844_(EquipmentSlot.MAINHAND);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemBySlot(...)");
        if (!StardustUtils.INSTANCE.hasEnchantment(itemStack, this)) {
            return;
        }
        int kineticLevel = attacker.m_6844_(EquipmentSlot.MAINHAND).getEnchantmentLevel((Enchantment)this);
        int kineticEnergy = MathKt.roundToInt((float)attacker.f_19789_);
        if (kineticEnergy <= 5) {
            return;
        }
        event.setAmount(event.getAmount() * (1.0f + (float)kineticEnergy / 15.0f * (float)(kineticLevel / this.m_6586_())));
        attacker.m_183634_();
    }
}

