/*
 * Decompiled with CFR 0.152.
 */
package com.nyronium.stardust.content.infrastructure;

import com.nyronium.stardust.content.infrastructure.EnchantmentConfiguration;
import com.nyronium.stardust.content.loot.EnchantedBookLootModifier;
import com.nyronium.stardust.core.StardustUtils;
import com.nyronium.stardust.datagen.StardustGlobalLootModifiersProvider;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0001H\u0014JN\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00172\u0014\b\u0002\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\t0\u00192\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u001c0\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lcom/nyronium/stardust/content/infrastructure/StardustEnchantment;", "Lnet/minecraft/world/item/enchantment/Enchantment;", "config", "Lcom/nyronium/stardust/content/infrastructure/EnchantmentConfiguration;", "<init>", "(Lcom/nyronium/stardust/content/infrastructure/EnchantmentConfiguration;)V", "getConfig", "()Lcom/nyronium/stardust/content/infrastructure/EnchantmentConfiguration;", "isDiscoverable", "", "isTradeable", "isTreasureOnly", "getMaxLevel", "", "checkCompatibility", "pOther", "registerAttributeModifier", "", "Lnet/minecraft/world/entity/EquipmentSlot;", "Ljava/util/UUID;", "attribute", "Lnet/minecraft/world/entity/ai/attributes/Attribute;", "operation", "Lnet/minecraft/world/entity/ai/attributes/AttributeModifier$Operation;", "condition", "Lkotlin/Function1;", "Lnet/minecraft/world/entity/player/Player;", "value", "", "stardust"})
@SourceDebugExtension(value={"SMAP\nStardustEnchantment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StardustEnchantment.kt\ncom/nyronium/stardust/content/infrastructure/StardustEnchantment\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 Forge.kt\nthedarkcolour/kotlinforforge/forge/ForgeKt\n*L\n1#1,95:1\n216#2,2:96\n27#3:98\n*S KotlinDebug\n*F\n+ 1 StardustEnchantment.kt\ncom/nyronium/stardust/content/infrastructure/StardustEnchantment\n*L\n24#1:96,2\n65#1:98\n*E\n"})
public class StardustEnchantment
extends Enchantment {
    @NotNull
    private final EnchantmentConfiguration config;

    public StardustEnchantment(@NotNull EnchantmentConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config.getObtainingConfiguration().getRarity(), config.getCategory(), config.getApplicableSlots());
        this.config = config;
        if (!this.config.getObtainingConfiguration().getLootModifiers().isEmpty()) {
            Map<String, Function1<Enchantment, EnchantedBookLootModifier>> $this$forEach$iv = this.config.getObtainingConfiguration().getLootModifiers();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, Function1<Enchantment, EnchantedBookLootModifier>>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Function1<Enchantment, EnchantedBookLootModifier>> element$iv;
                Map.Entry<String, Function1<Enchantment, EnchantedBookLootModifier>> entry = element$iv = iterator.next();
                boolean bl = false;
                String lootTable = entry.getKey();
                Function1<Enchantment, EnchantedBookLootModifier> modifierFunction = entry.getValue();
                EnchantedBookLootModifier lootModifier = (EnchantedBookLootModifier)((Object)modifierFunction.invoke((Object)this));
                String string = Reflection.getOrCreateKotlinClass(((Object)((Object)this)).getClass()).getSimpleName();
                Intrinsics.checkNotNull((Object)string);
                String[] stringArray = StringsKt.removeSuffix((String)string, (CharSequence)"Enchantment");
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string2 = stringArray.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                stringArray = new String[]{"/"};
                List list = StringsKt.split$default((CharSequence)lootTable, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                stringArray = new String[]{"/"};
                String modifierSimpleName = string2 + "_from_" + list.get(StringsKt.split$default((CharSequence)lootTable, (String[])stringArray, (boolean)false, (int)0, (int)6, null).size() - 1);
                StardustGlobalLootModifiersProvider.Companion.getModifiersToRegister().put(modifierSimpleName, lootModifier);
            }
        }
    }

    @NotNull
    public final EnchantmentConfiguration getConfig() {
        return this.config;
    }

    public boolean m_6592_() {
        return this.config.getObtainingConfiguration().isDiscoverable();
    }

    public boolean m_6594_() {
        return this.config.getObtainingConfiguration().isTradable();
    }

    public boolean m_6591_() {
        return !this.config.getObtainingConfiguration().isEnchantableViaEnchantingTable();
    }

    public int m_6586_() {
        return this.config.getMaxLevel();
    }

    protected boolean m_5975_(@NotNull Enchantment pOther) {
        Intrinsics.checkNotNullParameter((Object)pOther, (String)"pOther");
        return super.m_5975_(pOther) && !this.config.getIncompatibleEnchantments().contains(pOther);
    }

    @NotNull
    public final Map<EquipmentSlot, UUID> registerAttributeModifier(@NotNull Attribute attribute, @NotNull AttributeModifier.Operation operation, @NotNull Function1<? super Player, Boolean> condition, @NotNull Function1<? super Integer, Double> value) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Map modifierUUIDs = new LinkedHashMap();
        for (EquipmentSlot slot : this.config.getApplicableSlots()) {
            UUID uuid = UUID.randomUUID();
            modifierUUIDs.put(slot, uuid);
        }
        boolean $i$f$getFORGE_BUS = false;
        IEventBus iEventBus = MinecraftForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus, (String)"EVENT_BUS");
        iEventBus.addListener(arg_0 -> StardustEnchantment.registerAttributeModifier$lambda$2(this, attribute, modifierUUIDs, condition, value, operation, arg_0));
        return modifierUUIDs;
    }

    public static /* synthetic */ Map registerAttributeModifier$default(StardustEnchantment stardustEnchantment, Attribute attribute, AttributeModifier.Operation operation, Function1 function1, Function1 function12, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: registerAttributeModifier");
        }
        if ((n & 2) != 0) {
            operation = AttributeModifier.Operation.ADDITION;
        }
        if ((n & 4) != 0) {
            function1 = StardustEnchantment::registerAttributeModifier$lambda$1;
        }
        return stardustEnchantment.registerAttributeModifier(attribute, operation, (Function1<? super Player, Boolean>)function1, (Function1<? super Integer, Double>)function12);
    }

    private static final boolean registerAttributeModifier$lambda$1(Player it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final void registerAttributeModifier$lambda$2(StardustEnchantment this$0, Attribute $attribute, Map $modifierUUIDs, Function1 $condition, Function1 $value, AttributeModifier.Operation $operation, TickEvent.PlayerTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$attribute, (String)"$attribute");
        Intrinsics.checkNotNullParameter((Object)$modifierUUIDs, (String)"$modifierUUIDs");
        Intrinsics.checkNotNullParameter((Object)$condition, (String)"$condition");
        Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
        Intrinsics.checkNotNullParameter((Object)$operation, (String)"$operation");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.player;
        StardustEnchantment enchantment = this$0;
        AttributeInstance attributeInstance = player.m_21051_($attribute);
        if (attributeInstance == null) {
            return;
        }
        AttributeInstance attribute = attributeInstance;
        for (Map.Entry entry : $modifierUUIDs.entrySet()) {
            boolean isModifierAmountChanged;
            UUID uuid;
            EquipmentSlot slot;
            block9: {
                block8: {
                    slot = (EquipmentSlot)entry.getKey();
                    uuid = (UUID)entry.getValue();
                    ItemStack itemStack = player.m_6844_(slot);
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemBySlot(...)");
                    if (!StardustUtils.INSTANCE.hasEnchantment(itemStack, enchantment)) break block8;
                    Intrinsics.checkNotNull((Object)player);
                    if (((Boolean)$condition.invoke((Object)player)).booleanValue()) break block9;
                }
                if (attribute.m_22111_(uuid) == null) {
                    return;
                }
                attribute.m_22120_(uuid);
                return;
            }
            ItemStack itemStack = player.m_6844_(slot);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemBySlot(...)");
            int enchantmentLevel = StardustUtils.INSTANCE.getLevel(itemStack, enchantment);
            boolean hasModifier = attribute.m_22111_(uuid) != null;
            AttributeModifier attributeModifier = attribute.m_22111_(uuid);
            boolean bl = isModifierAmountChanged = !Intrinsics.areEqual((Double)(attributeModifier != null ? Double.valueOf(attributeModifier.m_22218_()) : null), (double)((Number)$value.invoke((Object)enchantmentLevel)).doubleValue());
            if (hasModifier && isModifierAmountChanged) {
                attribute.m_22120_(uuid);
            }
            if (hasModifier) {
                return;
            }
            AttributeModifier modifier = new AttributeModifier(uuid, "Enchantment modifier", ((Number)$value.invoke((Object)enchantmentLevel)).doubleValue(), $operation);
            attribute.m_22118_(modifier);
        }
    }
}

