/*
 * Decompiled with CFR 0.152.
 */
package com.nyronium.stardust.event;

import com.nyronium.stardust.Stardust;
import com.nyronium.stardust.misc.StardustUtils;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.EnderManAngerEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="stardust", bus=Mod.EventBusSubscriber.Bus.FORGE)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0007H\u0007R,\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Lcom/nyronium/stardust/event/EventHandler;", "", "<init>", "()V", "tickTasks", "", "Lkotlin/Function1;", "Lnet/minecraftforge/event/TickEvent$PlayerTickEvent;", "", "getTickTasks", "()Ljava/util/List;", "setTickTasks", "(Ljava/util/List;)V", "onLivingHeal", "event", "Lnet/minecraftforge/event/entity/living/LivingHealEvent;", "onLivingHurt", "Lnet/minecraftforge/event/entity/living/LivingHurtEvent;", "onPickupExperience", "Lnet/minecraftforge/event/entity/player/PlayerXpEvent$PickupXp;", "onCriticalHit", "Lnet/minecraftforge/event/entity/player/CriticalHitEvent;", "onLivingChangeTarget", "Lnet/minecraftforge/event/entity/living/LivingChangeTargetEvent;", "onEnderManAnger", "Lnet/minecraftforge/event/entity/living/EnderManAngerEvent;", "onBlockBreak", "Lnet/minecraftforge/event/level/BlockEvent$BreakEvent;", "onPlayerTick", "stardust"})
@SourceDebugExtension(value={"SMAP\nEventHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventHandler.kt\ncom/nyronium/stardust/event/EventHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n1863#2,2:116\n*S KotlinDebug\n*F\n+ 1 EventHandler.kt\ncom/nyronium/stardust/event/EventHandler\n*L\n113#1:116,2\n*E\n"})
public final class EventHandler {
    @NotNull
    public static final EventHandler INSTANCE = new EventHandler();
    @NotNull
    private static List<Function1<TickEvent.PlayerTickEvent, Unit>> tickTasks = new ArrayList();

    private EventHandler() {
    }

    @NotNull
    public final List<Function1<TickEvent.PlayerTickEvent, Unit>> getTickTasks() {
        return tickTasks;
    }

    public final void setTickTasks(@NotNull List<Function1<TickEvent.PlayerTickEvent, Unit>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        tickTasks = list;
    }

    @SubscribeEvent
    public final void onLivingHeal(@NotNull LivingHealEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        Intrinsics.checkNotNull((Object)livingEntity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
        Player player = (Player)livingEntity;
        Object object = Stardust.INSTANCE.getDETERMINATION().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Enchantment enchantment = (Enchantment)object;
        ItemStack itemStack = player.m_6844_(EquipmentSlot.LEGS);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemBySlot(...)");
        if (!StardustUtils.INSTANCE.hasEnchantment(enchantment, itemStack)) {
            return;
        }
        Object object2 = Stardust.INSTANCE.getDETERMINATION().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        Enchantment enchantment2 = (Enchantment)object2;
        ItemStack itemStack2 = player.m_6844_(EquipmentSlot.LEGS);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getItemBySlot(...)");
        int determinationLevel = StardustUtils.INSTANCE.getLevel(enchantment2, itemStack2);
        if (!player.m_6047_()) {
            return;
        }
        event.setAmount(event.getAmount() * (float)(1 + determinationLevel / ((Enchantment)Stardust.INSTANCE.getDETERMINATION().get()).m_6586_()));
    }

    @SubscribeEvent
    public final void onLivingHurt(@NotNull LivingHurtEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        Intrinsics.checkNotNull((Object)livingEntity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
        Player player = (Player)livingEntity;
        Object object = Stardust.INSTANCE.getNULLIFICATION().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Enchantment enchantment = (Enchantment)object;
        ItemStack itemStack = player.m_6844_(EquipmentSlot.CHEST);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemBySlot(...)");
        if (!StardustUtils.INSTANCE.hasEnchantment(enchantment, itemStack)) {
            return;
        }
        Object object2 = Stardust.INSTANCE.getNULLIFICATION().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        Enchantment enchantment2 = (Enchantment)object2;
        ItemStack itemStack2 = player.m_6844_(EquipmentSlot.CHEST);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getItemBySlot(...)");
        int nullificationLevel = StardustUtils.INSTANCE.getLevel(enchantment2, itemStack2);
        int random = RangesKt.random((IntRange)new IntRange(0, 100), (Random)((Random)Random.Default));
        if (random <= nullificationLevel) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public final void onPickupExperience(@NotNull PlayerXpEvent.PickupXp event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        Player player = event.getEntity();
        Object object = Stardust.INSTANCE.getREMEDY().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Enchantment enchantment = (Enchantment)object;
        ItemStack itemStack = player.m_6844_(EquipmentSlot.CHEST);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemBySlot(...)");
        if (!StardustUtils.INSTANCE.hasEnchantment(enchantment, itemStack)) {
            return;
        }
        if (player.m_36324_().m_38702_() < 20) {
            player.m_36324_().m_38707_(1, (float)event.getOrb().f_20770_ / 10.0f);
        } else if (player.m_21223_() < player.m_21233_()) {
            player.m_5634_((float)event.getOrb().f_20770_ / 10.0f);
        } else {
            return;
        }
        event.getOrb().f_20770_ = 0;
    }

    @SubscribeEvent
    public final void onCriticalHit(@NotNull CriticalHitEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getEntity();
        if (player.m_9236_().f_46443_) {
            return;
        }
        if (!event.isVanillaCritical()) {
            return;
        }
        Object object = Stardust.INSTANCE.getSTRIKING().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Enchantment enchantment = (Enchantment)object;
        ItemStack itemStack = player.m_6844_(EquipmentSlot.MAINHAND);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemBySlot(...)");
        if (StardustUtils.INSTANCE.hasEnchantment(enchantment, itemStack)) {
            Object object2 = Stardust.INSTANCE.getSTRIKING().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            Enchantment enchantment2 = (Enchantment)object2;
            ItemStack itemStack2 = player.m_6844_(EquipmentSlot.MAINHAND);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getItemBySlot(...)");
            int strikingLevel = StardustUtils.INSTANCE.getLevel(enchantment2, itemStack2);
            event.setDamageModifier(event.getDamageModifier() * (float)(1 + strikingLevel / ((Enchantment)Stardust.INSTANCE.getSTRIKING().get()).m_6586_()));
            event.setResult(Event.Result.ALLOW);
            return;
        }
        event.setResult(Event.Result.DEFAULT);
    }

    @SubscribeEvent
    public final void onLivingChangeTarget(@NotNull LivingChangeTargetEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (!(event.getNewTarget() instanceof Player)) {
            return;
        }
        if (!(event.getEntity() instanceof Piglin) || !(event.getEntity() instanceof PiglinBrute)) {
            return;
        }
        Object object = Stardust.INSTANCE.getPEERING().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Enchantment enchantment = (Enchantment)object;
        ItemStack itemStack = event.getNewTarget().m_6844_(EquipmentSlot.HEAD);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemBySlot(...)");
        if (!StardustUtils.INSTANCE.hasEnchantment(enchantment, itemStack)) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public final void onEnderManAnger(@NotNull EnderManAngerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        Object object = Stardust.INSTANCE.getPEERING().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Enchantment enchantment = (Enchantment)object;
        ItemStack itemStack = event.getPlayer().m_6844_(EquipmentSlot.HEAD);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemBySlot(...)");
        event.setCanceled(StardustUtils.INSTANCE.hasEnchantment(enchantment, itemStack));
    }

    @SubscribeEvent
    public final void onBlockBreak(@NotNull BlockEvent.BreakEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        Object object = Stardust.INSTANCE.getWISDOM().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Enchantment enchantment = (Enchantment)object;
        ItemStack itemStack = player.m_6844_(EquipmentSlot.MAINHAND);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemBySlot(...)");
        if (!StardustUtils.INSTANCE.hasEnchantment(enchantment, itemStack)) {
            return;
        }
        Object object2 = Stardust.INSTANCE.getWISDOM().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        Enchantment enchantment2 = (Enchantment)object2;
        ItemStack itemStack2 = player.m_6844_(EquipmentSlot.MAINHAND);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getItemBySlot(...)");
        int wisdomLevel = StardustUtils.INSTANCE.getLevel(enchantment2, itemStack2);
        event.setExpToDrop(event.getExpToDrop() * (1 + wisdomLevel / ((Enchantment)Stardust.INSTANCE.getWISDOM().get()).m_6586_()));
    }

    @SubscribeEvent
    public final void onPlayerTick(@NotNull TickEvent.PlayerTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.side.isClient()) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Iterable $this$forEach$iv = tickTasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 task = (Function1)element$iv;
            boolean bl = false;
            task.invoke((Object)event);
        }
    }
}

