/*
 * Decompiled with CFR 0.152.
 */
package com.nyronium.stardust.core;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0013\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0086\u0004J\u0015\u0010\u0018\u001a\u00020\u0019*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0086\u0004J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0015J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0015R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\t\u00a8\u0006\u001b"}, d2={"Lcom/nyronium/stardust/core/StardustUtils;", "", "<init>", "()V", "TOOLS", "Lnet/minecraft/world/item/enchantment/EnchantmentCategory;", "getTOOLS", "()Lnet/minecraft/world/item/enchantment/EnchantmentCategory;", "setTOOLS", "(Lnet/minecraft/world/item/enchantment/EnchantmentCategory;)V", "AXE", "getAXE", "setAXE", "EMPTY", "getEMPTY", "setEMPTY", "ALL", "getALL", "setALL", "hasEnchantment", "", "Lnet/minecraft/world/item/ItemStack;", "enchantment", "Lnet/minecraft/world/item/enchantment/Enchantment;", "getLevel", "", "stack", "stardust"})
public final class StardustUtils {
    @NotNull
    public static final StardustUtils INSTANCE = new StardustUtils();
    @NotNull
    private static EnchantmentCategory TOOLS;
    @NotNull
    private static EnchantmentCategory AXE;
    @NotNull
    private static EnchantmentCategory EMPTY;
    @NotNull
    private static EnchantmentCategory ALL;

    private StardustUtils() {
    }

    @NotNull
    public final EnchantmentCategory getTOOLS() {
        return TOOLS;
    }

    public final void setTOOLS(@NotNull EnchantmentCategory enchantmentCategory) {
        Intrinsics.checkNotNullParameter((Object)enchantmentCategory, (String)"<set-?>");
        TOOLS = enchantmentCategory;
    }

    @NotNull
    public final EnchantmentCategory getAXE() {
        return AXE;
    }

    public final void setAXE(@NotNull EnchantmentCategory enchantmentCategory) {
        Intrinsics.checkNotNullParameter((Object)enchantmentCategory, (String)"<set-?>");
        AXE = enchantmentCategory;
    }

    @NotNull
    public final EnchantmentCategory getEMPTY() {
        return EMPTY;
    }

    public final void setEMPTY(@NotNull EnchantmentCategory enchantmentCategory) {
        Intrinsics.checkNotNullParameter((Object)enchantmentCategory, (String)"<set-?>");
        EMPTY = enchantmentCategory;
    }

    @NotNull
    public final EnchantmentCategory getALL() {
        return ALL;
    }

    public final void setALL(@NotNull EnchantmentCategory enchantmentCategory) {
        Intrinsics.checkNotNullParameter((Object)enchantmentCategory, (String)"<set-?>");
        ALL = enchantmentCategory;
    }

    public final boolean hasEnchantment(@NotNull ItemStack $this$hasEnchantment, @NotNull Enchantment enchantment) {
        Intrinsics.checkNotNullParameter((Object)$this$hasEnchantment, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)enchantment, (String)"enchantment");
        return this.hasEnchantment(enchantment, $this$hasEnchantment);
    }

    public final int getLevel(@NotNull ItemStack $this$getLevel, @NotNull Enchantment enchantment) {
        Intrinsics.checkNotNullParameter((Object)$this$getLevel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)enchantment, (String)"enchantment");
        return this.getLevel(enchantment, $this$getLevel);
    }

    public final boolean hasEnchantment(@NotNull Enchantment enchantment, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)enchantment, (String)"enchantment");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return this.getLevel(enchantment, stack) > 0;
    }

    public final int getLevel(@NotNull Enchantment enchantment, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)enchantment, (String)"enchantment");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return stack.getEnchantmentLevel(enchantment);
    }

    private static final boolean TOOLS$lambda$0(Item it) {
        return it instanceof SwordItem || it instanceof PickaxeItem || it instanceof AxeItem || it instanceof ShovelItem || it instanceof HoeItem;
    }

    private static final boolean AXE$lambda$1(Item it) {
        return it instanceof AxeItem;
    }

    private static final boolean EMPTY$lambda$2(Item it) {
        return false;
    }

    private static final boolean ALL$lambda$3(Item it) {
        return it instanceof SwordItem || it instanceof PickaxeItem || it instanceof AxeItem || it instanceof ShovelItem || it instanceof HoeItem || it instanceof ArmorItem;
    }

    static {
        EnchantmentCategory enchantmentCategory = EnchantmentCategory.create((String)"stardust:tools", StardustUtils::TOOLS$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)enchantmentCategory, (String)"create(...)");
        TOOLS = enchantmentCategory;
        EnchantmentCategory enchantmentCategory2 = EnchantmentCategory.create((String)"stardust:axe", StardustUtils::AXE$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)enchantmentCategory2, (String)"create(...)");
        AXE = enchantmentCategory2;
        EnchantmentCategory enchantmentCategory3 = EnchantmentCategory.create((String)"stardust:empty", StardustUtils::EMPTY$lambda$2);
        Intrinsics.checkNotNullExpressionValue((Object)enchantmentCategory3, (String)"create(...)");
        EMPTY = enchantmentCategory3;
        EnchantmentCategory enchantmentCategory4 = EnchantmentCategory.create((String)"stardust:all", StardustUtils::ALL$lambda$3);
        Intrinsics.checkNotNullExpressionValue((Object)enchantmentCategory4, (String)"create(...)");
        ALL = enchantmentCategory4;
    }
}

