/*
 * Decompiled with CFR 0.152.
 */
package com.nyronium.stardust.content.enchantment.armor;

import com.nyronium.stardust.core.StardustUtils;
import com.nyronium.stardust.core.infrastructure.EnchantmentConfiguration;
import com.nyronium.stardust.core.infrastructure.ObtainingConfiguration;
import com.nyronium.stardust.core.infrastructure.StardustEnchantment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/nyronium/stardust/content/enchantment/armor/DeterminationEnchantment;", "Lcom/nyronium/stardust/core/infrastructure/StardustEnchantment;", "<init>", "()V", "onLivingHeal", "", "event", "Lnet/minecraftforge/event/entity/living/LivingHealEvent;", "stardust"})
@SourceDebugExtension(value={"SMAP\nDeterminationEnchantment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeterminationEnchantment.kt\ncom/nyronium/stardust/content/enchantment/armor/DeterminationEnchantment\n+ 2 Forge.kt\nthedarkcolour/kotlinforforge/forge/ForgeKt\n*L\n1#1,37:1\n27#2:38\n*S KotlinDebug\n*F\n+ 1 DeterminationEnchantment.kt\ncom/nyronium/stardust/content/enchantment/armor/DeterminationEnchantment\n*L\n22#1:38\n*E\n"})
public final class DeterminationEnchantment
extends StardustEnchantment {
    public DeterminationEnchantment() {
        EquipmentSlot[] equipmentSlotArray = new EquipmentSlot[]{EquipmentSlot.LEGS};
        EnchantmentConfiguration enchantmentConfiguration = new EnchantmentConfiguration().maxLevel(4).obtaining(ObtainingConfiguration.loot$default(new ObtainingConfiguration(Enchantment.Rarity.RARE).enchantingTable().discoverable(), "chests/end_city_treasure", 0.05f, null, null, 12, null)).category(EnchantmentCategory.ARMOR_LEGS).applicableSlots(equipmentSlotArray);
        equipmentSlotArray = new Enchantment[]{Enchantments.f_220304_};
        super(enchantmentConfiguration.incompatible((Enchantment[])equipmentSlotArray));
        boolean $i$f$getFORGE_BUS = false;
        IEventBus iEventBus = MinecraftForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus, (String)"EVENT_BUS");
        iEventBus.addListener(this::onLivingHeal);
    }

    public final void onLivingHeal(@NotNull LivingHealEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        Intrinsics.checkNotNull((Object)livingEntity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
        Player player = (Player)livingEntity;
        Enchantment enchantment = this;
        ItemStack itemStack = player.m_6844_(EquipmentSlot.LEGS);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemBySlot(...)");
        if (!StardustUtils.INSTANCE.hasEnchantment(enchantment, itemStack)) {
            return;
        }
        Enchantment enchantment2 = this;
        ItemStack itemStack2 = player.m_6844_(EquipmentSlot.LEGS);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getItemBySlot(...)");
        int determinationLevel = StardustUtils.INSTANCE.getLevel(enchantment2, itemStack2);
        if (!player.m_6047_()) {
            return;
        }
        event.setAmount(event.getAmount() * (float)(1 + determinationLevel / this.m_6586_()));
    }
}

