/*
 * Decompiled with CFR 0.152.
 */
package com.nyronium.stardust.content.experience;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.EnchantmentMenu;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/nyronium/stardust/content/experience/ExperienceManager;", "", "<init>", "()V", "selectedLocal", "Ljava/lang/ThreadLocal;", "", "getSelectedLocal", "()Ljava/lang/ThreadLocal;", "getRequiredExperienceToNextLevel", "level", "levelToTotalExperience", "handleEnchantXp", "", "player", "Lnet/minecraft/world/entity/player/Player;", "cost", "stardust"})
public final class ExperienceManager {
    @NotNull
    public static final ExperienceManager INSTANCE = new ExperienceManager();
    @NotNull
    private static final ThreadLocal<Integer> selectedLocal;

    private ExperienceManager() {
    }

    @NotNull
    public final ThreadLocal<Integer> getSelectedLocal() {
        return selectedLocal;
    }

    private final int getRequiredExperienceToNextLevel(int level) {
        return level >= 30 ? 112 + (level - 30) * 9 : (level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2);
    }

    public final int levelToTotalExperience(int level) {
        int sum = 0;
        for (int i = 0; i < level; ++i) {
            sum += this.getRequiredExperienceToNextLevel(i);
        }
        return sum;
    }

    public final void handleEnchantXp(@NotNull Player player, int cost) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        AbstractContainerMenu menu = player.f_36096_;
        if (menu instanceof EnchantmentMenu) {
            int[] nArray = ((EnchantmentMenu)menu).f_39446_;
            Integer n = selectedLocal.get();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"get(...)");
            int levelsRequired = nArray[((Number)n).intValue()];
            player.m_6756_(this.levelToTotalExperience(levelsRequired) - this.levelToTotalExperience(levelsRequired + cost));
        }
    }

    private static final Integer selectedLocal$lambda$0() {
        return 0;
    }

    static {
        ThreadLocal<Integer> threadLocal = ThreadLocal.withInitial(ExperienceManager::selectedLocal$lambda$0);
        Intrinsics.checkNotNullExpressionValue(threadLocal, (String)"withInitial(...)");
        selectedLocal = threadLocal;
    }
}

