/*
 * Decompiled with CFR 0.152.
 */
package com.nyronium.stardust.core.infrastructure;

import com.nyronium.stardust.content.loot.EnchantedBookLootModifier;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraftforge.common.loot.LootTableIdCondition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001b\u001a\u00020\u0000J3\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010!\u00a2\u0006\u0002\u0010#J\u0006\u0010$\u001a\u00020\u0000J\u0006\u0010%\u001a\u00020\u0000J\u0006\u0010&\u001a\u00020\u0000J\u0006\u0010'\u001a\u00020\u0000J\u0006\u0010(\u001a\u00020\u0000J\u0006\u0010)\u001a\u00020\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R2\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0014\"\u0004\b\u0018\u0010\u0016R\u001a\u0010\u0019\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0014\"\u0004\b\u001a\u0010\u0016\u00a8\u0006*"}, d2={"Lcom/nyronium/stardust/core/infrastructure/ObtainingConfiguration;", "", "rarity", "Lnet/minecraft/world/item/enchantment/Enchantment$Rarity;", "<init>", "(Lnet/minecraft/world/item/enchantment/Enchantment$Rarity;)V", "getRarity", "()Lnet/minecraft/world/item/enchantment/Enchantment$Rarity;", "lootModifiers", "", "", "Lkotlin/Function1;", "Lnet/minecraft/world/item/enchantment/Enchantment;", "Lcom/nyronium/stardust/content/loot/EnchantedBookLootModifier;", "getLootModifiers", "()Ljava/util/Map;", "setLootModifiers", "(Ljava/util/Map;)V", "isTradable", "", "()Z", "setTradable", "(Z)V", "isDiscoverable", "setDiscoverable", "isEnchantableViaEnchantingTable", "setEnchantableViaEnchantingTable", "default", "loot", "lootTable", "chance", "", "minLevel", "", "maxLevel", "(Ljava/lang/String;FLjava/lang/Integer;Ljava/lang/Integer;)Lcom/nyronium/stardust/core/infrastructure/ObtainingConfiguration;", "tradable", "discoverable", "enchantingTable", "notTradable", "notDiscoverable", "noEnchantingTable", "stardust"})
public final class ObtainingConfiguration {
    @NotNull
    private final Enchantment.Rarity rarity;
    @NotNull
    private Map<String, Function1<Enchantment, EnchantedBookLootModifier>> lootModifiers;
    private boolean isTradable;
    private boolean isDiscoverable;
    private boolean isEnchantableViaEnchantingTable;

    public ObtainingConfiguration(@NotNull Enchantment.Rarity rarity) {
        Intrinsics.checkNotNullParameter((Object)rarity, (String)"rarity");
        this.rarity = rarity;
        this.lootModifiers = new LinkedHashMap();
        this.isEnchantableViaEnchantingTable = true;
    }

    @NotNull
    public final Enchantment.Rarity getRarity() {
        return this.rarity;
    }

    @NotNull
    public final Map<String, Function1<Enchantment, EnchantedBookLootModifier>> getLootModifiers() {
        return this.lootModifiers;
    }

    public final void setLootModifiers(@NotNull Map<String, Function1<Enchantment, EnchantedBookLootModifier>> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.lootModifiers = map;
    }

    public final boolean isTradable() {
        return this.isTradable;
    }

    public final void setTradable(boolean bl) {
        this.isTradable = bl;
    }

    public final boolean isDiscoverable() {
        return this.isDiscoverable;
    }

    public final void setDiscoverable(boolean bl) {
        this.isDiscoverable = bl;
    }

    public final boolean isEnchantableViaEnchantingTable() {
        return this.isEnchantableViaEnchantingTable;
    }

    public final void setEnchantableViaEnchantingTable(boolean bl) {
        this.isEnchantableViaEnchantingTable = bl;
    }

    @NotNull
    public final ObtainingConfiguration default() {
        this.isTradable = true;
        this.isDiscoverable = true;
        this.isEnchantableViaEnchantingTable = true;
        return this;
    }

    @NotNull
    public final ObtainingConfiguration loot(@NotNull String lootTable, float chance, @Nullable Integer minLevel, @Nullable Integer maxLevel) {
        Intrinsics.checkNotNullParameter((Object)lootTable, (String)"lootTable");
        this.lootModifiers.put(lootTable, (Function1<Enchantment, EnchantedBookLootModifier>)((Function1)arg_0 -> ObtainingConfiguration.loot$lambda$0(lootTable, chance, minLevel, maxLevel, arg_0)));
        return this;
    }

    public static /* synthetic */ ObtainingConfiguration loot$default(ObtainingConfiguration obtainingConfiguration, String string, float f, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = null;
        }
        if ((n3 & 8) != 0) {
            n2 = null;
        }
        return obtainingConfiguration.loot(string, f, n, n2);
    }

    @NotNull
    public final ObtainingConfiguration tradable() {
        this.isTradable = true;
        return this;
    }

    @NotNull
    public final ObtainingConfiguration discoverable() {
        this.isDiscoverable = true;
        return this;
    }

    @NotNull
    public final ObtainingConfiguration enchantingTable() {
        this.isEnchantableViaEnchantingTable = true;
        return this;
    }

    @NotNull
    public final ObtainingConfiguration notTradable() {
        this.isTradable = false;
        return this;
    }

    @NotNull
    public final ObtainingConfiguration notDiscoverable() {
        this.isDiscoverable = false;
        return this;
    }

    @NotNull
    public final ObtainingConfiguration noEnchantingTable() {
        this.isEnchantableViaEnchantingTable = false;
        return this;
    }

    private static final EnchantedBookLootModifier loot$lambda$0(String $lootTable, float $chance, Integer $minLevel, Integer $maxLevel, Enchantment it) {
        Intrinsics.checkNotNullParameter((Object)$lootTable, (String)"$lootTable");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LootItemCondition[] lootItemConditionArray = new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)new ResourceLocation($lootTable)).m_6409_(), LootItemRandomChanceCondition.m_81927_((float)$chance).m_6409_()};
        Item item = Items.f_42690_;
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"ENCHANTED_BOOK");
        Integer n = $minLevel;
        Integer n2 = $maxLevel;
        return new EnchantedBookLootModifier(lootItemConditionArray, item, it, n != null ? n.intValue() : it.m_44702_(), n2 != null ? n2.intValue() : it.m_6586_());
    }
}

