/*
 * Decompiled with CFR 0.152.
 */
package com.nyronium.stardust.event;

import com.nyronium.stardust.Stardust;
import com.nyronium.stardust.StardustUtils;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="stardust", bus=Mod.EventBusSubscriber.Bus.FORGE)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0006\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0007J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fJJ\u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019\u00a8\u0006\u001c"}, d2={"Lcom/nyronium/stardust/event/EventHandler;", "", "<init>", "()V", "onBlockBreak", "", "event", "Lnet/minecraftforge/event/level/BlockEvent$BreakEvent;", "onPlayerTick", "Lnet/minecraftforge/event/TickEvent$PlayerTickEvent;", "handleDetermination", "player", "Lnet/minecraft/world/entity/player/Player;", "registerAttributeModifier", "enchantment", "Lnet/minecraft/world/item/enchantment/Enchantment;", "slot", "Lnet/minecraft/world/entity/EquipmentSlot;", "attribute", "Lnet/minecraft/world/entity/ai/attributes/Attribute;", "uuid", "Ljava/util/UUID;", "operation", "Lnet/minecraft/world/entity/ai/attributes/AttributeModifier$Operation;", "valueOfLevel", "Lkotlin/Function1;", "", "", "stardust"})
public final class EventHandler {
    @NotNull
    public static final EventHandler INSTANCE = new EventHandler();

    private EventHandler() {
    }

    @SubscribeEvent
    public final void onBlockBreak(@NotNull BlockEvent.BreakEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        Object object = Stardust.INSTANCE.getWISDOM().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Enchantment enchantment = (Enchantment)object;
        ItemStack itemStack = player.m_6844_(EquipmentSlot.MAINHAND);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemBySlot(...)");
        if (!StardustUtils.INSTANCE.hasEnchantment(enchantment, itemStack)) {
            return;
        }
        Object object2 = Stardust.INSTANCE.getWISDOM().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        Enchantment enchantment2 = (Enchantment)object2;
        ItemStack itemStack2 = player.m_6844_(EquipmentSlot.MAINHAND);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getItemBySlot(...)");
        int wisdomLevel = StardustUtils.INSTANCE.getLevel(enchantment2, itemStack2);
        event.setExpToDrop(event.getExpToDrop() * (1 + wisdomLevel));
    }

    @SubscribeEvent
    public final void onPlayerTick(@NotNull TickEvent.PlayerTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.side.isClient()) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        Intrinsics.checkNotNull((Object)player);
        this.handleDetermination(player);
        Object object = Stardust.INSTANCE.getREACHING().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Enchantment enchantment = (Enchantment)object;
        Object object2 = ForgeMod.ENTITY_REACH.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        Attribute attribute = (Attribute)object2;
        UUID uUID = UUID.fromString("0acfdbee-af25-42bb-bfa0-5d9800ad2451");
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
        this.registerAttributeModifier(player, enchantment, EquipmentSlot.MAINHAND, attribute, uUID, AttributeModifier.Operation.ADDITION, (Function1<? super Integer, Double>)((Function1)EventHandler::onPlayerTick$lambda$0));
        Object object3 = Stardust.INSTANCE.getREACHING().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        Enchantment enchantment2 = (Enchantment)object3;
        Object object4 = ForgeMod.BLOCK_REACH.get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
        Attribute attribute2 = (Attribute)object4;
        UUID uUID2 = UUID.fromString("b31a85d1-653b-4557-9876-a2f158a0e1aa");
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"fromString(...)");
        this.registerAttributeModifier(player, enchantment2, EquipmentSlot.MAINHAND, attribute2, uUID2, AttributeModifier.Operation.ADDITION, (Function1<? super Integer, Double>)((Function1)EventHandler::onPlayerTick$lambda$1));
        Object object5 = Stardust.INSTANCE.getFRENZY().get();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"get(...)");
        Enchantment enchantment3 = (Enchantment)object5;
        Attribute attribute3 = Attributes.f_22283_;
        Intrinsics.checkNotNullExpressionValue((Object)attribute3, (String)"ATTACK_SPEED");
        UUID uUID3 = UUID.fromString("c4f8833d-33a5-446b-b95d-9e21a240dfd6");
        Intrinsics.checkNotNullExpressionValue((Object)uUID3, (String)"fromString(...)");
        this.registerAttributeModifier(player, enchantment3, EquipmentSlot.MAINHAND, attribute3, uUID3, AttributeModifier.Operation.ADDITION, (Function1<? super Integer, Double>)((Function1)EventHandler::onPlayerTick$lambda$2));
        Object object6 = Stardust.INSTANCE.getPACING().get();
        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"get(...)");
        Enchantment enchantment4 = (Enchantment)object6;
        Attribute attribute4 = Attributes.f_22279_;
        Intrinsics.checkNotNullExpressionValue((Object)attribute4, (String)"MOVEMENT_SPEED");
        UUID uUID4 = UUID.fromString("d1a3f204-7ad8-4f5c-a4f2-67d2e8d75958");
        Intrinsics.checkNotNullExpressionValue((Object)uUID4, (String)"fromString(...)");
        this.registerAttributeModifier(player, enchantment4, EquipmentSlot.FEET, attribute4, uUID4, AttributeModifier.Operation.ADDITION, (Function1<? super Integer, Double>)((Function1)EventHandler::onPlayerTick$lambda$3));
        Object object7 = Stardust.INSTANCE.getSTABILITY().get();
        Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"get(...)");
        Enchantment enchantment5 = (Enchantment)object7;
        Attribute attribute5 = Attributes.f_22278_;
        Intrinsics.checkNotNullExpressionValue((Object)attribute5, (String)"KNOCKBACK_RESISTANCE");
        UUID uUID5 = UUID.fromString("83774500-fc34-45b2-937a-44773e61ebaf");
        Intrinsics.checkNotNullExpressionValue((Object)uUID5, (String)"fromString(...)");
        this.registerAttributeModifier(player, enchantment5, EquipmentSlot.FEET, attribute5, uUID5, AttributeModifier.Operation.ADDITION, (Function1<? super Integer, Double>)((Function1)EventHandler::onPlayerTick$lambda$4));
    }

    public final void handleDetermination(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (player.m_6047_()) {
            Object object = Stardust.INSTANCE.getDETERMINATION().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            Enchantment enchantment = (Enchantment)object;
            ItemStack itemStack = player.m_6844_(EquipmentSlot.LEGS);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemBySlot(...)");
            if (StardustUtils.INSTANCE.hasEnchantment(enchantment, itemStack)) {
                Object object2 = Stardust.INSTANCE.getDETERMINATION().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                Enchantment enchantment2 = (Enchantment)object2;
                ItemStack itemStack2 = player.m_6844_(EquipmentSlot.LEGS);
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getItemBySlot(...)");
                int determinationLevel = StardustUtils.INSTANCE.getLevel(enchantment2, itemStack2);
                if (player.f_19797_ % 20 == 0) {
                    player.m_5634_(0.5f * (float)determinationLevel);
                }
            }
        }
    }

    public final void registerAttributeModifier(@NotNull Player player, @NotNull Enchantment enchantment, @NotNull EquipmentSlot slot, @NotNull Attribute attribute, @NotNull UUID uuid, @NotNull AttributeModifier.Operation operation, @NotNull Function1<? super Integer, Double> valueOfLevel) {
        boolean isModifierAmountChanged;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)enchantment, (String)"enchantment");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Intrinsics.checkNotNullParameter(valueOfLevel, (String)"valueOfLevel");
        AttributeInstance attributeInstance = player.m_21051_(attribute);
        if (attributeInstance == null) {
            return;
        }
        AttributeInstance attribute2 = attributeInstance;
        ItemStack itemStack = player.m_6844_(slot);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemBySlot(...)");
        if (!StardustUtils.INSTANCE.hasEnchantment(enchantment, itemStack)) {
            if (attribute2.m_22111_(uuid) == null) {
                return;
            }
            attribute2.m_22120_(uuid);
            return;
        }
        ItemStack itemStack2 = player.m_6844_(slot);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getItemBySlot(...)");
        int enchantmentLevel = StardustUtils.INSTANCE.getLevel(enchantment, itemStack2);
        boolean hasModifier = attribute2.m_22111_(uuid) != null;
        AttributeModifier attributeModifier = attribute2.m_22111_(uuid);
        boolean bl = isModifierAmountChanged = !Intrinsics.areEqual((Double)(attributeModifier != null ? Double.valueOf(attributeModifier.m_22218_()) : null), (double)((Number)valueOfLevel.invoke((Object)enchantmentLevel)).doubleValue());
        if (hasModifier && isModifierAmountChanged) {
            attribute2.m_22120_(uuid);
        }
        if (hasModifier) {
            return;
        }
        attribute2.m_22118_(new AttributeModifier(uuid, "Enchantment modifier", ((Number)valueOfLevel.invoke((Object)enchantmentLevel)).doubleValue(), operation));
    }

    private static final double onPlayerTick$lambda$0(int level) {
        return 1.0 * (double)level;
    }

    private static final double onPlayerTick$lambda$1(int level) {
        return 1.0 * (double)level;
    }

    private static final double onPlayerTick$lambda$2(int level) {
        return 0.4 * (double)level;
    }

    private static final double onPlayerTick$lambda$3(int level) {
        return 0.015 * (double)level;
    }

    private static final double onPlayerTick$lambda$4(int level) {
        return 1.0 * (double)(level / ((Enchantment)Stardust.INSTANCE.getSTABILITY().get()).m_6586_());
    }
}

