/*
 * Decompiled with CFR 0.152.
 */
package com.nyronium.stardust.content.enchantment;

import com.nyronium.stardust.content.enchantment.infrastructure.EnchantmentConfiguration;
import com.nyronium.stardust.content.enchantment.infrastructure.ObtainingConfiguration;
import com.nyronium.stardust.content.enchantment.infrastructure.StardustEnchantment;
import com.nyronium.stardust.core.StardustExtensions;
import com.nyronium.stardust.core.StardustUtils;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/nyronium/stardust/content/enchantment/SoulboundEnchantment;", "Lcom/nyronium/stardust/content/enchantment/infrastructure/StardustEnchantment;", "<init>", "()V", "onPlayerClone", "", "event", "Lnet/minecraftforge/event/entity/player/PlayerEvent$Clone;", "stardust"})
@SourceDebugExtension(value={"SMAP\nSoulboundEnchantment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SoulboundEnchantment.kt\ncom/nyronium/stardust/content/enchantment/SoulboundEnchantment\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 Forge.kt\nthedarkcolour/kotlinforforge/forge/ForgeKt\n*L\n1#1,34:1\n37#2,2:35\n27#3:37\n*S KotlinDebug\n*F\n+ 1 SoulboundEnchantment.kt\ncom/nyronium/stardust/content/enchantment/SoulboundEnchantment\n*L\n15#1:35,2\n18#1:37\n*E\n"})
public final class SoulboundEnchantment
extends StardustEnchantment {
    public SoulboundEnchantment() {
        Collection $this$toTypedArray$iv = (Collection)EntriesMappings.entries$0;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        super(new EnchantmentConfiguration().obtaining(new ObtainingConfiguration(Enchantment.Rarity.VERY_RARE)).category(StardustExtensions.INSTANCE.getALL()).applicableSlotsAll(thisCollection$iv.toArray(new EquipmentSlot[0])));
        boolean $i$f$getFORGE_BUS = false;
        IEventBus iEventBus = MinecraftForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus, (String)"EVENT_BUS");
        iEventBus.addListener(this::onPlayerClone);
    }

    public final void onPlayerClone(@NotNull PlayerEvent.Clone event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!event.isWasDeath()) {
            return;
        }
        Player oldPlayer = event.getOriginal();
        Player newPlayer = event.getEntity();
        int n = oldPlayer.m_150109_().m_6643_();
        for (int slot = 0; slot < n; ++slot) {
            ItemStack stack = oldPlayer.m_150109_().m_8020_(slot);
            if (stack.m_41619_()) continue;
            Enchantment enchantment = this;
            Intrinsics.checkNotNull((Object)stack);
            if (!StardustUtils.INSTANCE.hasEnchantment(enchantment, stack)) continue;
            newPlayer.m_150109_().m_6836_(slot, stack.m_41777_());
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<EquipmentSlot> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])EquipmentSlot.values()));
        }
    }
}

