/*
 * Decompiled with CFR 0.152.
 */
package com.nyronium.stardust.content.enchantment.infrastructure;

import com.nyronium.stardust.content.enchantment.infrastructure.EnchantmentConfiguration;
import com.nyronium.stardust.core.StardustUtils;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0001H\u0014J,\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00180\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/nyronium/stardust/content/enchantment/infrastructure/StardustEnchantment;", "Lnet/minecraft/world/item/enchantment/Enchantment;", "config", "Lcom/nyronium/stardust/content/enchantment/infrastructure/EnchantmentConfiguration;", "<init>", "(Lcom/nyronium/stardust/content/enchantment/infrastructure/EnchantmentConfiguration;)V", "getConfig", "()Lcom/nyronium/stardust/content/enchantment/infrastructure/EnchantmentConfiguration;", "isDiscoverable", "", "isTradeable", "isTreasureOnly", "getMaxLevel", "", "checkCompatibility", "pOther", "registerAttributeModifier", "Ljava/util/UUID;", "attribute", "Lnet/minecraft/world/entity/ai/attributes/Attribute;", "operation", "Lnet/minecraft/world/entity/ai/attributes/AttributeModifier$Operation;", "valueOfLevel", "Lkotlin/Function1;", "", "stardust"})
@SourceDebugExtension(value={"SMAP\nStardustEnchantment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StardustEnchantment.kt\ncom/nyronium/stardust/content/enchantment/infrastructure/StardustEnchantment\n+ 2 Forge.kt\nthedarkcolour/kotlinforforge/forge/ForgeKt\n*L\n1#1,75:1\n27#2:76\n*S KotlinDebug\n*F\n+ 1 StardustEnchantment.kt\ncom/nyronium/stardust/content/enchantment/infrastructure/StardustEnchantment\n*L\n44#1:76\n*E\n"})
public class StardustEnchantment
extends Enchantment {
    @NotNull
    private final EnchantmentConfiguration config;

    public StardustEnchantment(@NotNull EnchantmentConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config.getObtainingConfiguration().getRarity(), config.getCategory(), config.getApplicableSlots());
        this.config = config;
    }

    @NotNull
    public final EnchantmentConfiguration getConfig() {
        return this.config;
    }

    public boolean m_6592_() {
        return this.config.getObtainingConfiguration().isDiscoverable();
    }

    public boolean m_6594_() {
        return this.config.getObtainingConfiguration().isTradable();
    }

    public boolean m_6591_() {
        return !this.config.getObtainingConfiguration().isEnchantableViaEnchantingTable();
    }

    public int m_6586_() {
        return this.config.getMaxLevel();
    }

    protected boolean m_5975_(@NotNull Enchantment pOther) {
        Intrinsics.checkNotNullParameter((Object)pOther, (String)"pOther");
        return super.m_5975_(pOther) && !this.config.getIncompatibleEnchantments().contains(pOther);
    }

    @NotNull
    public final UUID registerAttributeModifier(@NotNull Attribute attribute, @NotNull AttributeModifier.Operation operation, @NotNull Function1<? super Integer, Double> valueOfLevel) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Intrinsics.checkNotNullParameter(valueOfLevel, (String)"valueOfLevel");
        UUID uuid = UUID.randomUUID();
        boolean $i$f$getFORGE_BUS = false;
        IEventBus iEventBus = MinecraftForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus, (String)"EVENT_BUS");
        iEventBus.addListener(arg_0 -> StardustEnchantment.registerAttributeModifier$lambda$0(this, attribute, uuid, valueOfLevel, operation, arg_0));
        Intrinsics.checkNotNull((Object)uuid);
        return uuid;
    }

    public static /* synthetic */ UUID registerAttributeModifier$default(StardustEnchantment stardustEnchantment, Attribute attribute, AttributeModifier.Operation operation, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: registerAttributeModifier");
        }
        if ((n & 2) != 0) {
            operation = AttributeModifier.Operation.ADDITION;
        }
        return stardustEnchantment.registerAttributeModifier(attribute, operation, (Function1<? super Integer, Double>)function1);
    }

    private static final void registerAttributeModifier$lambda$0(StardustEnchantment this$0, Attribute $attribute, UUID $uuid, Function1 $valueOfLevel, AttributeModifier.Operation $operation, TickEvent.PlayerTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$attribute, (String)"$attribute");
        Intrinsics.checkNotNullParameter((Object)$valueOfLevel, (String)"$valueOfLevel");
        Intrinsics.checkNotNullParameter((Object)$operation, (String)"$operation");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.player;
        StardustEnchantment enchantment = this$0;
        AttributeInstance attributeInstance = player.m_21051_($attribute);
        if (attributeInstance == null) {
            return;
        }
        AttributeInstance attribute = attributeInstance;
        for (EquipmentSlot slot : this$0.config.getApplicableSlots()) {
            boolean isModifierAmountChanged;
            Enchantment enchantment2 = enchantment;
            ItemStack itemStack = player.m_6844_(slot);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemBySlot(...)");
            if (!StardustUtils.INSTANCE.hasEnchantment(enchantment2, itemStack)) {
                if (attribute.m_22111_($uuid) == null) {
                    return;
                }
                attribute.m_22120_($uuid);
                return;
            }
            Enchantment enchantment3 = enchantment;
            ItemStack itemStack2 = player.m_6844_(slot);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getItemBySlot(...)");
            int enchantmentLevel = StardustUtils.INSTANCE.getLevel(enchantment3, itemStack2);
            boolean hasModifier = attribute.m_22111_($uuid) != null;
            AttributeModifier attributeModifier = attribute.m_22111_($uuid);
            boolean bl = isModifierAmountChanged = !Intrinsics.areEqual((Double)(attributeModifier != null ? Double.valueOf(attributeModifier.m_22218_()) : null), (double)((Number)$valueOfLevel.invoke((Object)enchantmentLevel)).doubleValue());
            if (hasModifier && isModifierAmountChanged) {
                attribute.m_22120_($uuid);
            }
            if (hasModifier) {
                return;
            }
            AttributeModifier modifier = new AttributeModifier($uuid, "Enchantment modifier", ((Number)$valueOfLevel.invoke((Object)enchantmentLevel)).doubleValue(), $operation);
            attribute.m_22118_(modifier);
        }
    }
}

