/*
 * Decompiled with CFR 0.152.
 */
package com.nyronium.stardust.content.enchantment.weapon;

import com.nyronium.stardust.content.enchantment.infrastructure.EnchantmentConfiguration;
import com.nyronium.stardust.content.enchantment.infrastructure.ObtainingConfiguration;
import com.nyronium.stardust.content.enchantment.infrastructure.StardustEnchantment;
import com.nyronium.stardust.core.StardustUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/nyronium/stardust/content/enchantment/weapon/StrikingEnchantment;", "Lcom/nyronium/stardust/content/enchantment/infrastructure/StardustEnchantment;", "<init>", "()V", "onCriticalHit", "", "event", "Lnet/minecraftforge/event/entity/player/CriticalHitEvent;", "stardust"})
@SourceDebugExtension(value={"SMAP\nStrikingEnchantment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StrikingEnchantment.kt\ncom/nyronium/stardust/content/enchantment/weapon/StrikingEnchantment\n+ 2 Forge.kt\nthedarkcolour/kotlinforforge/forge/ForgeKt\n*L\n1#1,36:1\n27#2:37\n*S KotlinDebug\n*F\n+ 1 StrikingEnchantment.kt\ncom/nyronium/stardust/content/enchantment/weapon/StrikingEnchantment\n*L\n21#1:37\n*E\n"})
public final class StrikingEnchantment
extends StardustEnchantment {
    public StrikingEnchantment() {
        EquipmentSlot[] equipmentSlotArray = new EquipmentSlot[]{EquipmentSlot.MAINHAND};
        super(new EnchantmentConfiguration().maxLevel(5).obtaining(new ObtainingConfiguration(Enchantment.Rarity.RARE).default()).category(EnchantmentCategory.WEAPON).applicableSlots(equipmentSlotArray));
        boolean $i$f$getFORGE_BUS = false;
        IEventBus iEventBus = MinecraftForge.EVENT_BUS;
        Intrinsics.checkNotNullExpressionValue((Object)iEventBus, (String)"EVENT_BUS");
        iEventBus.addListener(this::onCriticalHit);
    }

    public final void onCriticalHit(@NotNull CriticalHitEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getEntity();
        if (player.m_9236_().f_46443_) {
            return;
        }
        if (!event.isVanillaCritical()) {
            return;
        }
        Enchantment enchantment = this;
        ItemStack itemStack = player.m_6844_(EquipmentSlot.MAINHAND);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemBySlot(...)");
        if (StardustUtils.INSTANCE.hasEnchantment(enchantment, itemStack)) {
            Enchantment enchantment2 = this;
            ItemStack itemStack2 = player.m_6844_(EquipmentSlot.MAINHAND);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"getItemBySlot(...)");
            int strikingLevel = StardustUtils.INSTANCE.getLevel(enchantment2, itemStack2);
            event.setDamageModifier(1.0f + (float)(strikingLevel / this.m_6586_()));
            event.setResult(Event.Result.ALLOW);
            return;
        }
        event.setResult(Event.Result.DEFAULT);
    }
}

