/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block;

import dev.hexnowloading.dungeonnowloading.block.entity.ScuttleStatueBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class ScuttleStatueBlock
extends BaseEntityBlock
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    private boolean playerDestroyed;
    private boolean hasBeenSummoned;

    public ScuttleStatueBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{HALF});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        BlockPos blockPos = blockPlaceContext.m_8083_();
        Level level = blockPlaceContext.m_43725_();
        Direction direction = blockPlaceContext.m_8125_().m_122424_();
        return blockPos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(blockPos.m_7494_()).m_60629_(blockPlaceContext) ? (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER) : null;
    }

    public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        BlockPos blockPos1 = blockPos.m_7495_();
        return this.mayPlaceOn(levelReader.m_8055_(blockPos1), (BlockGetter)levelReader, blockPos1);
    }

    private boolean mayPlaceOn(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return !blockState.m_60812_(blockGetter, blockPos).m_83263_(Direction.UP).m_83281_() || blockState.m_60783_(blockGetter, blockPos, Direction.UP);
    }

    public void m_6861_(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos blockPos1, boolean b) {
        if (level.f_46443_) {
            return;
        }
        if (!level.m_276867_(blockPos)) {
            return;
        }
        ScuttleStatueBlockEntity blockEntity = (ScuttleStatueBlockEntity)level.m_7702_(blockPos);
        if (blockEntity != null) {
            BlockPos summonPos = blockPos;
            if (blockState.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
                summonPos = blockPos.m_7495_();
            }
            blockEntity.alert(summonPos, blockEntity);
        }
        if (blockState.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            level.m_46961_(blockPos.m_7495_(), false);
        }
        if (blockState.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            level.m_46961_(blockPos.m_7494_(), true);
        }
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        BlockPos upperBlockPos = blockPos.m_7494_();
        Direction direction = (Direction)blockState.m_61143_((Property)FACING);
        level.m_7731_(upperBlockPos, (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
        level.m_46586_(upperBlockPos, (Block)this, upperBlockPos);
    }

    public void m_5707_(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        if (!level.f_46443_) {
            boolean bl = this.playerDestroyed = !player.m_150110_().f_35937_;
            if (this.playerDestroyed) {
                ItemStack heldItem = player.m_21205_();
                this.playerDestroyed = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)heldItem) < 1;
            }
        }
        super.m_5707_(level, blockPos, blockState, player);
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (!level.f_46443_ && blockState.m_60734_() != newState.m_60734_()) {
            ScuttleStatueBlockEntity blockEntity;
            if (blockState.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
                level.m_46961_(blockPos.m_7495_(), false);
            }
            if (blockState.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
                level.m_46961_(blockPos.m_7494_(), true);
            }
            if (this.playerDestroyed && blockState.m_61143_(HALF) == DoubleBlockHalf.LOWER && blockState.m_60734_() instanceof ScuttleStatueBlock && (blockEntity = (ScuttleStatueBlockEntity)level.m_7702_(blockPos)) != null) {
                BlockPos summonPos = blockPos;
                blockEntity.alert(summonPos, blockEntity);
            }
        }
        super.m_6810_(blockState, level, blockPos, newState, isMoving);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new ScuttleStatueBlockEntity(blockPos, blockState);
    }

    public RenderShape m_7514_(BlockState $blockState0) {
        return RenderShape.MODEL;
    }
}

