/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import dev.hexnowloading.dungeonnowloading.game_event_listener.PreserverBlockDestructionSystem;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlockEntityTypes;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEventListener;
import org.slf4j.Logger;

public class PreserverBlockEntity
extends BlockEntity
implements GameEventListener.Holder<PreserverBlockDestructionSystem.Listener>,
PreserverBlockDestructionSystem {
    private static final Logger LOGGER = LogUtils.getLogger();
    private PreserverBlockDestructionSystem.User user;
    private PreserverBlockDestructionSystem.Listener gameEventListener;
    private final Set<BlockPos> playerPlacedBlocks = new HashSet<BlockPos>();

    public PreserverBlockEntity(BlockPos pos, BlockState state) {
        this(DNLBlockEntityTypes.PRESERVER_BLOCK.get(), pos, state);
    }

    public PreserverBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.user = new PreserverBlockDestructionSystem.User(this.m_58899_(), new BlockPos(10, 10, 10), new BlockPos(-10, -10, -10), Direction.NORTH);
        this.gameEventListener = new PreserverBlockDestructionSystem.Listener(this);
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        PreserverBlockDestructionSystem.User.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.user).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(tag -> compoundTag.m_128365_("listener", tag));
        compoundTag.m_128365_("PlayerPlacedBlocks", (Tag)PreserverBlockEntity.saveBlockPosSet(this.playerPlacedBlocks));
    }

    public void m_142466_(CompoundTag compoundTag) {
        if (compoundTag.m_128425_("listener", 10)) {
            PreserverBlockDestructionSystem.User.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)compoundTag.m_128469_("listener")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(listener -> {
                this.user = new PreserverBlockDestructionSystem.User(this.m_58899_(), listener.getCornerA(), listener.getCornerB(), listener.getFacing());
            });
        }
        if (compoundTag.m_128441_("PlayerPlacedBlocks")) {
            this.playerPlacedBlocks.clear();
            this.playerPlacedBlocks.addAll(PreserverBlockEntity.loadBlockPosSet(compoundTag.m_128437_("PlayerPlacedBlocks", 10)));
        }
    }

    @Override
    public PreserverBlockDestructionSystem.User getUser() {
        return this.user;
    }

    public PreserverBlockDestructionSystem.Listener getListener() {
        return this.gameEventListener;
    }

    public void addPlayerPlacedBlock(BlockPos pos) {
        this.playerPlacedBlocks.add(pos);
    }

    public void removePlayerPlacedBlock(BlockPos pos) {
        this.playerPlacedBlocks.remove(pos);
    }

    public boolean isPlayerPlaced(BlockPos pos) {
        return this.playerPlacedBlocks.contains(pos);
    }

    private static ListTag saveBlockPosSet(Set<BlockPos> positions) {
        ListTag listTag = new ListTag();
        for (BlockPos pos : positions) {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("x", pos.m_123341_());
            tag.m_128405_("y", pos.m_123342_());
            tag.m_128405_("z", pos.m_123343_());
            listTag.add((Object)tag);
        }
        return listTag;
    }

    private static Set<BlockPos> loadBlockPosSet(ListTag listTag) {
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag tag = listTag.m_128728_(i);
            positions.add(new BlockPos(tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z")));
        }
        return positions;
    }
}

