/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.hexnowloading.dungeonnowloading.entity.projectile.VertexOrbProjectileEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class VertexOrbProjectileModel<T extends VertexOrbProjectileEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("dungeonnowloading", "vertex_orb_projectile"), "main");
    private final ModelPart vertex_orb;
    private final ModelPart orb;
    private final ModelPart wave;
    private final ModelPart root;
    private float waveAlpha;
    private float landedAgeInTicks;
    private VertexOrbProjectileEntity entity;

    public VertexOrbProjectileModel(ModelPart root) {
        this.root = root;
        this.vertex_orb = root.m_171324_("vertex_orb");
        this.orb = this.vertex_orb.m_171324_("orb");
        this.wave = this.vertex_orb.m_171324_("wave");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition vertex_orb = partdefinition.m_171599_("vertex_orb", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition orb = vertex_orb.m_171599_("orb", CubeListBuilder.m_171558_().m_171514_(0, 80).m_171488_(-6.0f, -6.0f, -6.0f, 12.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition wave = vertex_orb.m_171599_("wave", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-40.0f, 0.4f, -40.0f, 80.0f, 0.0f, 80.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)512, (int)512);
    }

    public void setupAnim(VertexOrbProjectileEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        float EXPANSION_DURATION = 40.0f;
        float partialTicks = ageInTicks - (float)entity.f_19797_;
        float currentAge = 40.0f - (float)entity.getExpansionTick() + partialTicks;
        float progress = Math.min(currentAge / 40.0f, 1.0f);
        float scale = Mth.m_14036_((float)((float)(1.0 - Math.pow(1.0f - progress, 5.0))), (float)0.0f, (float)1.0f);
        if (entity.getLife() > 0) {
            this.orb.f_104207_ = entity.getDyingTick() <= 0;
            this.wave.f_104207_ = true;
            this.waveAlpha = 0.8f + 0.2f * (float)Math.sin(ageInTicks * 0.2f);
            if (progress < 1.0f) {
                this.wave.f_233553_ = scale;
                this.wave.f_233555_ = scale;
            } else {
                this.wave.f_233553_ = 1.0f;
                this.wave.f_233555_ = 1.0f;
            }
        } else {
            this.orb.f_104207_ = true;
            this.wave.f_104207_ = false;
            this.orb.m_171327_(0.17453292f * ageInTicks, 0.17453292f * ageInTicks, 0.17453292f * ageInTicks);
        }
    }

    public void renderToBufferWithEntity(VertexOrbProjectileEntity entity, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.orb.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.wave.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, entity.getDyingTick() > 0 || entity.getLife() > 0 && entity.getLife() < 20 ? alpha : this.waveAlpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

