/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.client.model.copper_creep;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.hexnowloading.dungeonnowloading.entity.client.animation.copper_creep.CopperCreepAnimation;
import dev.hexnowloading.dungeonnowloading.entity.passive.CopperCreepEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;

public class CopperCreepModel<T extends CopperCreepEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("dungeonnowloading", "copper_creep"), "main");
    private final ModelPart coppercreep;
    private final ModelPart body;
    private final ModelPart rod;
    private final ModelPart bodycube;
    private final ModelPart legs;
    private final ModelPart left_leg;
    private final ModelPart right_leg;
    private final ModelPart root;

    public CopperCreepModel(ModelPart root) {
        this.coppercreep = root.m_171324_("coppercreep");
        this.body = this.coppercreep.m_171324_("body");
        this.rod = this.body.m_171324_("rod");
        this.bodycube = this.body.m_171324_("bodycube");
        this.legs = this.coppercreep.m_171324_("legs");
        this.left_leg = this.legs.m_171324_("left_leg");
        this.right_leg = this.legs.m_171324_("right_leg");
        this.root = root;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition coppercreep = partdefinition.m_171599_("coppercreep", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)0.0f));
        PartDefinition body = coppercreep.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)0.5f));
        PartDefinition rod = body.m_171599_("rod", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -2.0f, -0.5f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 18).m_171488_(-2.0f, -6.0f, -1.5f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-4.5f, (float)-0.5f));
        PartDefinition bodycube = body.m_171599_("bodycube", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.5f, -13.0f, -4.0f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.15f)), PartPose.m_171419_((float)0.0f, (float)8.5f, (float)-0.5f));
        PartDefinition legs = coppercreep.m_171599_("legs", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition left_leg = legs.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(16, 18).m_171488_(-2.0f, -3.0f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.5f, (float)-4.0f, (float)0.5f));
        PartDefinition right_leg = legs.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171488_(-2.0f, -3.0f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.5f, (float)-4.0f, (float)0.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(CopperCreepEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root.m_171331_().forEach(ModelPart::m_233569_);
        this.m_233381_(entity.idleAnimationState, CopperCreepAnimation.IDLE, ageInTicks);
        this.m_233381_(entity.summonAnimationState, CopperCreepAnimation.SUMMON, ageInTicks);
        this.m_233381_(entity.detonationAnimationState, CopperCreepAnimation.DETONATION, ageInTicks);
        this.m_233381_(entity.sitAnimationState, CopperCreepAnimation.SIT, ageInTicks);
        this.m_233381_(entity.standAnimationState, CopperCreepAnimation.STAND, ageInTicks);
        this.m_233381_(entity.wrongOwnerAnimationState, CopperCreepAnimation.WRONG_OWNER, ageInTicks);
        this.m_233381_(entity.sittingAnimationState, CopperCreepAnimation.SITTING, ageInTicks);
        this.m_233381_(entity.sittingDetonationAnimationState, CopperCreepAnimation.DETONATION_SITTING, ageInTicks);
        if (entity.getState() == CopperCreepEntity.State.IDLE || entity.getState() == CopperCreepEntity.State.WALKING_TOWARDS_PLAYER || entity.getState() == CopperCreepEntity.State.WANDERING) {
            this.m_267799_(CopperCreepAnimation.WALKING, limbSwing, limbSwingAmount, 4.0f, 4.5f);
        } else if (entity.getState() == CopperCreepEntity.State.FOLLOWING || entity.getState() == CopperCreepEntity.State.RUNNING_TOWARDS_PLAYER) {
            this.m_267799_(CopperCreepAnimation.RUNNING, limbSwing, limbSwingAmount, 2.0f, 2.25f);
        }
        this.animateHeadLookTarget(netHeadYaw, headPitch);
    }

    private void animateHeadLookTarget(float netHeadYaw, float headPitch) {
        this.coppercreep.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.coppercreep.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

