/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.hexnowloading.dungeonnowloading.entity.client.model.copper_creep.CopperCreepButlerModel;
import dev.hexnowloading.dungeonnowloading.entity.client.model.copper_creep.CopperCreepModel;
import dev.hexnowloading.dungeonnowloading.entity.client.renderer.CopperCreepPowerLayer;
import dev.hexnowloading.dungeonnowloading.entity.passive.CopperCreepEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;

public class CopperCreepRenderer
extends MobRenderer<CopperCreepEntity, HierarchicalModel<CopperCreepEntity>> {
    private final CopperCreepButlerModel<CopperCreepEntity> butlerModel;
    private static final ResourceLocation TEXTURE = new ResourceLocation("dungeonnowloading", "textures/entity/copper_creep/copper_creep.png");
    private static final ResourceLocation TEXTURE_BUTLER = new ResourceLocation("dungeonnowloading", "textures/entity/copper_creep/copper_creep_butler.png");

    public CopperCreepRenderer(EntityRendererProvider.Context context) {
        super(context, new CopperCreepModel(context.m_174023_(CopperCreepModel.LAYER_LOCATION)), 0.5f);
        this.m_115326_(new CopperCreepPowerLayer(this, (CopperCreepModel)this.m_7200_()));
        this.butlerModel = new CopperCreepButlerModel(context.m_174023_(CopperCreepButlerModel.LAYER_LOCATION));
    }

    protected void scale(CopperCreepEntity entity, PoseStack poseStack, float partialTick) {
        float swelling = entity.getSwelling(partialTick);
        float scaleFactor = 1.0f + Mth.m_14031_((float)(swelling * 100.0f)) * swelling * 0.01f;
        swelling = Mth.m_14036_((float)swelling, (float)0.0f, (float)1.0f);
        swelling *= swelling;
        swelling *= swelling;
        float finalScale = (1.0f + swelling * 0.4f) * scaleFactor;
        float inverseScale = (1.0f + swelling * 0.1f) / scaleFactor;
        poseStack.m_85841_(finalScale, inverseScale, finalScale);
    }

    public void render(CopperCreepEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (entity.getSkin() == CopperCreepEntity.Skin.BUTLER) {
            this.f_115290_ = this.butlerModel;
        }
        if (entity.isAlreadySummoned()) {
            super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        }
    }

    protected float getWhiteOverlayProgress(CopperCreepEntity entity, float partialTicks) {
        float swelling = entity.getSwelling(partialTicks);
        return (int)(swelling * 10.0f) % 2 == 0 ? 0.0f : Mth.m_14036_((float)swelling, (float)0.5f, (float)1.0f);
    }

    public ResourceLocation getTextureLocation(CopperCreepEntity entity) {
        return entity.getSkin() == CopperCreepEntity.Skin.BUTLER ? TEXTURE_BUTLER : TEXTURE;
    }
}

