/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.monster;

import dev.hexnowloading.dungeonnowloading.entity.ai.BallistaGolemArrowAttackGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.BallistaGolemMeleeAttackGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.BallistaGolemReloadGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.SlumberingEntityPlayerTargetGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.control.move.BallistaGolemMoveControl;
import dev.hexnowloading.dungeonnowloading.entity.ai.control.pathfinding.BallistaGolemPathNavigation;
import dev.hexnowloading.dungeonnowloading.entity.util.EntityStates;
import dev.hexnowloading.dungeonnowloading.entity.util.SlumberingEntity;
import dev.hexnowloading.dungeonnowloading.network.packets.S2CStartTickingSoundPacket;
import dev.hexnowloading.dungeonnowloading.network.packets.S2CStopTickingSoundPacket;
import dev.hexnowloading.dungeonnowloading.platform.Services;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;

public class BallistaGolemEntity
extends Monster
implements Enemy,
SlumberingEntity {
    private static final EntityDataAccessor<BallistaGolemState> STATE = SynchedEntityData.m_135353_(BallistaGolemEntity.class, EntityStates.BALLISTA_GOLEM_STATE);
    private static final EntityDataAccessor<Integer> ARROW_COUNT = SynchedEntityData.m_135353_(BallistaGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final int BALLISTA_GOLEM_MELEE_RANGE = 7;
    private int aiTick = 0;
    public final AnimationState wakeUpAnimationState = new AnimationState();
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState reloadAnimationState = new AnimationState();
    public final AnimationState shootAnimationState = new AnimationState();
    private static final byte TRIGGER_WAKING_UP_ANIMATION_BYTE = 70;
    private static final byte TRIGGER_IDLE_ANIMATION_BYTE = 71;
    private static final byte TRIGGER_RELOAD_ANIMATION_BYTE = 72;
    private static final byte TRIGGER_SHOOT_ANIMATION_BYTE = 73;

    public BallistaGolemEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.setState(BallistaGolemState.SLUMBERING);
        this.setBallistaArrowCount(6);
        this.m_274367_(1.0f);
        this.m_21441_(BlockPathTypes.LEAVES, 0.0f);
        this.f_21342_ = new BallistaGolemMoveControl(this);
        this.f_21344_ = new BallistaGolemPathNavigation((Mob)this, this.m_9236_());
        this.f_21364_ = 50;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22281_, 19.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22284_, 15.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new BallistaGolemReloadGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new BallistaGolemArrowAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new BallistaGolemMeleeAttackGoal((PathfinderMob)this, 1.0, true, 1.1f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new SlumberingEntityPlayerTargetGoal((Mob)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STATE, (Object)BallistaGolemState.SLUMBERING);
        this.f_19804_.m_135372_(ARROW_COUNT, (Object)6);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("Slumbering", this.isSlumbering());
        compoundTag.m_128405_("ArrowCount", ((Integer)this.f_19804_.m_135370_(ARROW_COUNT)).intValue());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        boolean isSlumbering = compoundTag.m_128471_("Slumbering");
        this.f_19804_.m_135381_(STATE, (Object)(isSlumbering ? BallistaGolemState.SLUMBERING : BallistaGolemState.IDLE));
        this.f_19804_.m_135381_(ARROW_COUNT, (Object)compoundTag.m_128451_("ArrowCount"));
    }

    public void m_8119_() {
        super.m_8119_();
    }

    protected void m_8024_() {
        if (this.isSlumbering()) {
            this.setState(BallistaGolemState.AWAKENING);
            this.triggerWakingUpAnimation();
            this.aiTick = 153;
        }
        if (this.isState(BallistaGolemState.AWAKENING)) {
            if (this.aiTick == 147) {
                this.playBallsitaGolemSound(DNLSounds.BALLISTA_GOLEM_WAKING.get());
            }
            if (this.aiTick > 0) {
                --this.aiTick;
            } else {
                this.setState(BallistaGolemState.IDLE);
                this.triggerIdleAnimation();
            }
        }
        if (this.f_19862_ && this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
            boolean brokeLeaves = false;
            AABB box = this.m_20191_().m_82400_(0.2);
            for (BlockPos pos : BlockPos.m_121976_((int)Mth.m_14107_((double)box.f_82288_), (int)Mth.m_14107_((double)box.f_82289_), (int)Mth.m_14107_((double)box.f_82290_), (int)Mth.m_14107_((double)box.f_82291_), (int)Mth.m_14107_((double)box.f_82292_), (int)Mth.m_14107_((double)box.f_82293_))) {
                boolean destroyed;
                BlockState state = this.m_9236_().m_8055_(pos);
                if (!(state.m_60734_() instanceof LeavesBlock) || !(destroyed = this.m_9236_().m_46953_(pos, true, (Entity)this))) continue;
                brokeLeaves = true;
            }
            if (!brokeLeaves && this.m_20096_()) {
                this.m_6135_();
            }
        }
        super.m_8024_();
    }

    public double m_142593_(LivingEntity livingEntity) {
        return this.m_20205_() * this.m_20205_();
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 2.0f;
    }

    public boolean m_5829_() {
        return this.isSlumbering();
    }

    public void m_7822_(byte b) {
        switch (b) {
            case 70: {
                this.wakeUpAnimationState.m_216977_(this.f_19797_);
                break;
            }
            case 71: {
                this.idleAnimationState.m_216977_(this.f_19797_);
                break;
            }
            case 73: {
                this.idleAnimationState.m_216973_();
                this.shootAnimationState.m_216977_(this.f_19797_);
                break;
            }
            case 72: {
                this.idleAnimationState.m_216973_();
                this.reloadAnimationState.m_216977_(this.f_19797_);
                break;
            }
            default: {
                super.m_7822_(b);
            }
        }
    }

    public void playBallsitaGolemSound(SoundEvent soundEvent) {
        float radius = 32.0f;
        AABB detectionBox = this.m_20191_().m_82400_((double)radius);
        List nearbyPlayers = this.m_9236_().m_45976_(ServerPlayer.class, detectionBox);
        for (ServerPlayer player : nearbyPlayers) {
            Services.NETWORK.sendToPlayer(new S2CStartTickingSoundPacket(this.m_19879_(), soundEvent.m_11660_(), SoundSource.HOSTILE), player);
        }
    }

    public void stopBallsitaGolemSounds() {
        float radius = 32.0f;
        AABB detectionBox = this.m_20191_().m_82400_((double)radius);
        List nearbyPlayers = this.m_9236_().m_45976_(ServerPlayer.class, detectionBox);
        ArrayList<ResourceLocation> soundsToStop = new ArrayList<ResourceLocation>(List.of());
        soundsToStop.add(DNLSounds.BALLISTA_GOLEM_WAKING.get().m_11660_());
        soundsToStop.add(DNLSounds.BALLISTA_GOLEM_RELOAD.get().m_11660_());
        for (ServerPlayer player : nearbyPlayers) {
            for (ResourceLocation sound : soundsToStop) {
                Services.NETWORK.sendToPlayer(new S2CStopTickingSoundPacket(this.m_19879_(), sound, 20, true), player);
            }
        }
    }

    protected float m_6059_() {
        return this.f_19788_ + 0.85f;
    }

    protected void m_7355_(BlockPos $$0, BlockState $$1) {
        this.m_5496_(DNLSounds.BALLISTA_GOLEM_STEP.get(), 1.5f, 1.0f);
    }

    protected SoundEvent m_5592_() {
        return DNLSounds.BALLISTA_GOLEM_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource $$0) {
        return DNLSounds.BALLISTA_GOLEM_HURT.get();
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (damageSource.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        return super.m_6469_(damageSource, amount);
    }

    public void m_6667_(DamageSource damageSource) {
        super.m_6667_(damageSource);
        if (!this.m_9236_().f_46443_) {
            this.stopBallsitaGolemSounds();
        }
    }

    @Override
    public boolean isSlumbering() {
        return this.isState(BallistaGolemState.SLUMBERING);
    }

    @Override
    public boolean isStationary() {
        return this.isSlumbering() || this.isState(BallistaGolemState.AWAKENING) || this.isState(BallistaGolemState.SHOOT) || this.isState(BallistaGolemState.RELOAD);
    }

    public void setBallistaArrowCount(int arrowCount) {
        this.f_19804_.m_135381_(ARROW_COUNT, (Object)arrowCount);
    }

    public int getBallistaArrowCount() {
        return (Integer)this.f_19804_.m_135370_(ARROW_COUNT);
    }

    public double getFollowDistance() {
        return this.m_21133_(Attributes.f_22277_);
    }

    public void setState(BallistaGolemState ballistaGolemState) {
        this.f_19804_.m_135381_(STATE, (Object)ballistaGolemState);
    }

    public BallistaGolemState getState() {
        return (BallistaGolemState)((Object)this.f_19804_.m_135370_(STATE));
    }

    public boolean isState(BallistaGolemState ballistaGolemState) {
        return this.getState().equals((Object)ballistaGolemState);
    }

    public void triggerWakingUpAnimation() {
        this.m_9236_().m_7605_((Entity)this, (byte)70);
    }

    public void triggerIdleAnimation() {
        this.m_9236_().m_7605_((Entity)this, (byte)71);
    }

    public void triggerShootAnimation() {
        this.m_9236_().m_7605_((Entity)this, (byte)73);
    }

    public void triggerReloadAnimation() {
        this.m_9236_().m_7605_((Entity)this, (byte)72);
    }

    public static enum BallistaGolemState {
        SLUMBERING,
        AWAKENING,
        IDLE,
        SHOOT,
        RELOAD;

    }
}

