/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.projectile;

import dev.hexnowloading.dungeonnowloading.registry.DNLEntityTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class BallistaArrowEntity
extends AbstractArrow {
    private final int DAMAGE = 19;
    private final float KNOCKBACK = 3.0f;
    private final float EXPLOSION_STRENGTH = 4.0f;

    public BallistaArrowEntity(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    public BallistaArrowEntity(LivingEntity owner, Level level) {
        super(DNLEntityTypes.BALLISTA_ARROW.get(), owner, level);
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        DamageSource damageSource;
        int damage;
        if (this.m_9236_().f_46443_) {
            return;
        }
        Entity target = entityHitResult.m_82443_();
        Entity owner = this.m_19749_();
        if (owner instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)owner;
            v0 = (int)livingEntity.m_21133_(Attributes.f_22281_);
        } else {
            v0 = damage = 19;
        }
        if (owner == null) {
            damageSource = this.m_269291_().m_269418_((AbstractArrow)this, (Entity)this);
        } else {
            damageSource = this.m_269291_().m_269418_((AbstractArrow)this, owner);
            if (owner instanceof LivingEntity) {
                ((LivingEntity)owner).m_6703_((LivingEntity)target);
            }
        }
        boolean isEnderman = target.m_6095_() == EntityType.f_20566_;
        int fireTick = target.m_20094_();
        if (this.m_6060_() && !isEnderman) {
            target.m_20254_(15);
        }
        if (target.m_6469_(damageSource, (float)damage)) {
            if (isEnderman) {
                return;
            }
            if (target instanceof LivingEntity) {
                Player player;
                LivingEntity livingEntity = (LivingEntity)target;
                double knockback = Math.max(0.0, 1.0 - livingEntity.m_21133_(Attributes.f_22278_));
                Vec3 vec3 = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_(1.7999999999999998 * knockback);
                if (vec3.m_82556_() > 0.0) {
                    livingEntity.m_5997_(vec3.f_82479_, 0.1, vec3.f_82481_);
                }
                if (livingEntity instanceof Player && (player = (Player)livingEntity).m_21254_()) {
                    player.m_36384_(true);
                }
                if (!this.m_9236_().f_46443_ && owner instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingEntity, (Entity)owner);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)owner), (Entity)livingEntity);
                }
            }
            this.m_5496_(SoundEvents.f_11685_, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        } else {
            target.m_7311_(fireTick);
        }
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        this.explode();
    }

    public boolean m_6087_() {
        return false;
    }

    private void explode() {
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 4.0f, Level.ExplosionInteraction.NONE);
        }
    }

    protected ItemStack m_7941_() {
        return null;
    }

    public void m_37251_(Entity entity, float pitch, float yaw, float roll, float velocity, float inaccuracy) {
        super.m_37251_(entity, pitch, yaw, roll, velocity, inaccuracy);
    }
}

