/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.util;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public abstract class ModelledProjectileEntity
extends Entity
implements TraceableEntity {
    @Nullable
    protected UUID ownerUUID;
    @Nullable
    protected Entity cachedOwner;
    protected boolean leftOwner;
    protected boolean hasBeenShot;

    public ModelledProjectileEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public void m_8119_() {
        if (!this.hasBeenShot) {
            this.m_146852_(GameEvent.f_157778_, this.m_19749_());
            this.hasBeenShot = true;
        }
        if (!this.leftOwner) {
            this.leftOwner = this.checkLeftOwner();
        }
        Entity owner = this.m_19749_();
        if (this.m_9236_().f_46443_ || (owner == null || !owner.m_213877_()) && this.m_9236_().m_46805_(this.m_20183_())) {
            super.m_8119_();
            HitResult hitResult = ProjectileUtil.m_278158_((Entity)this, this::canHitEntity);
            if (hitResult.m_6662_() != HitResult.Type.MISS) {
                this.onHit(hitResult);
            }
            this.tickProjectile();
        } else {
            this.m_146870_();
        }
    }

    @Nullable
    public Entity m_19749_() {
        if (this.cachedOwner != null && !this.cachedOwner.m_213877_()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && this.m_9236_() instanceof ServerLevel) {
            this.cachedOwner = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    public void setOwner(@Nullable Entity entity) {
        if (entity != null) {
            this.ownerUUID = entity.m_20148_();
            this.cachedOwner = entity;
        }
    }

    protected boolean checkLeftOwner() {
        Entity entity = this.m_19749_();
        if (entity != null) {
            for (Entity entity1 : this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), owner -> !owner.m_5833_() && owner.m_6087_())) {
                if (entity1.m_20201_() != entity.m_20201_()) continue;
                return false;
            }
        }
        return true;
    }

    protected void onHit(HitResult hitResult) {
        HitResult.Type hitresult$type = hitResult.m_6662_();
        if (hitresult$type == HitResult.Type.ENTITY) {
            this.onHitEntity((EntityHitResult)hitResult);
            this.m_9236_().m_214171_(GameEvent.f_157777_, hitResult.m_82450_(), GameEvent.Context.m_223719_((Entity)this, (BlockState)null));
        } else if (hitresult$type == HitResult.Type.BLOCK) {
            BlockHitResult blockhitresult = (BlockHitResult)hitResult;
            this.onHitBlock(blockhitresult);
            BlockPos blockpos = blockhitresult.m_82425_();
            this.m_9236_().m_220407_(GameEvent.f_157777_, blockpos, GameEvent.Context.m_223719_((Entity)this, (BlockState)this.m_9236_().m_8055_(blockpos)));
        }
    }

    protected boolean canHitEntity(Entity entity) {
        if (!entity.m_271807_()) {
            return false;
        }
        Entity ownerEntity = this.m_19749_();
        return (ownerEntity == null || this.leftOwner || !ownerEntity.m_20365_(entity)) && !entity.f_19794_;
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
    }

    protected void tickProjectile() {
    }

    public void m_6001_(double x, double y, double z) {
        this.m_20334_(x, y, z);
    }

    public boolean m_6783_(double distance) {
        double d0 = this.m_20191_().m_82309_() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public void m_141965_(ClientboundAddEntityPacket recreateFromPacket) {
        super.m_141965_(recreateFromPacket);
    }

    protected void m_7378_(CompoundTag compoundTag) {
        if (this.ownerUUID != null) {
            compoundTag.m_128362_("Owner", this.ownerUUID);
        }
        if (this.leftOwner) {
            compoundTag.m_128379_("LeftOwner", true);
        }
        compoundTag.m_128379_("HasBeenShot", this.hasBeenShot);
    }

    protected void m_7380_(CompoundTag compoundTag) {
        if (compoundTag.m_128403_("Owner")) {
            this.ownerUUID = compoundTag.m_128342_("Owner");
            this.cachedOwner = null;
        }
        this.leftOwner = compoundTag.m_128471_("LeftOwner");
        this.hasBeenShot = compoundTag.m_128471_("HasBeenShot");
    }
}

