/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.util;

import dev.hexnowloading.dungeonnowloading.util.WeightedRandomBag;
import java.util.ArrayList;
import java.util.List;

public class WeightBaseMoveSet<T> {
    List<Move> moveSet = new ArrayList<Move>();

    public void addMove(T object, int weight, int cooldown) {
        Move move = new Move();
        move.object = object;
        move.weight = weight;
        move.cooldown = cooldown;
        move.currentCooldown = 0;
        this.moveSet.add(move);
    }

    public void addMove(T object, int weight, int cooldown, int initialCooldown) {
        Move move = new Move();
        move.object = object;
        move.weight = weight;
        move.cooldown = cooldown;
        move.currentCooldown = initialCooldown;
        this.moveSet.add(move);
    }

    public void removeMove(T removeObject) {
        this.moveSet.removeIf(move -> move.object.equals(removeObject));
    }

    public T selectMove() {
        WeightedRandomBag weightedPool = new WeightedRandomBag();
        this.moveSet.forEach(move -> {
            if (move.currentCooldown <= 0) {
                weightedPool.addEntry(move, move.weight);
            } else {
                --move.currentCooldown;
            }
        });
        Move chosenMove = (Move)weightedPool.getRandom();
        if (chosenMove != null) {
            chosenMove.currentCooldown = chosenMove.cooldown;
            return chosenMove.object;
        }
        return null;
    }

    public T selectMoveWithoutCooldownReduction() {
        WeightedRandomBag weightedPool = new WeightedRandomBag();
        this.moveSet.forEach(move -> {
            if (move.currentCooldown <= 0) {
                weightedPool.addEntry(move, move.weight);
            }
        });
        Move chosenMove = (Move)weightedPool.getRandom();
        if (chosenMove != null) {
            chosenMove.currentCooldown = chosenMove.cooldown;
            return chosenMove.object;
        }
        return null;
    }

    public void reduceAllCooldown() {
        this.reduceAllCooldownBy(1);
    }

    public void reduceAllCooldownBy(int cooldown) {
        this.moveSet.forEach(move -> move.currentCooldown -= cooldown);
    }

    public void increaseAllCooldown() {
        this.increaseAllCooldownBy(1);
    }

    public void increaseAllCooldownBy(int cooldown) {
        this.moveSet.forEach(move -> move.currentCooldown += cooldown);
    }

    public void reduceCooldown(T object) {
        this.moveSet.forEach(move -> {
            if (move.object.equals(object)) {
                --move.currentCooldown;
            }
        });
    }

    public void setOnCooldown(T object) {
        this.moveSet.forEach(move -> {
            if (move.object.equals(object)) {
                move.currentCooldown = move.cooldown;
            }
        });
    }

    public void addWeight(T object, int additionalWeight) {
        this.moveSet.forEach(move -> {
            if (move.object.equals(object)) {
                move.weight += additionalWeight;
            }
        });
    }

    public void setWeight(T object, int newWeight) {
        this.moveSet.forEach(move -> {
            if (move.object.equals(object)) {
                move.weight = newWeight;
            }
        });
    }

    public int getTotalWeight() {
        int totalWeight = 0;
        for (Move move : this.moveSet) {
            totalWeight += move.weight;
        }
        return totalWeight;
    }

    public boolean isEmpty() {
        return this.moveSet.isEmpty();
    }

    public void clear() {
        this.moveSet.clear();
    }

    public void displayAllStats() {
        System.out.println("Moves: ---------------------------------------------------------");
        this.moveSet.forEach(move -> System.out.println(move.object + " : " + move.weight + " : " + move.cooldown + " : " + move.currentCooldown));
    }

    protected class Move {
        T object;
        int weight;
        int cooldown;
        int currentCooldown;

        protected Move() {
        }
    }
}

