/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.item;

import dev.hexnowloading.dungeonnowloading.config.GeneralConfig;
import dev.hexnowloading.dungeonnowloading.entity.passive.CopperCreepEntity;
import dev.hexnowloading.dungeonnowloading.registry.DNLEntityTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import dev.hexnowloading.dungeonnowloading.supporter.DNLSupporters;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CopperDetonatorItem
extends Item {
    private static final double TRIGGER_RADIUS = 32.0;
    private static final int SUMMON_COOLDOWN = 5;
    private static final int IGNITE_COOLDOWN_PER_CREEP = 100;
    public static final int MODE_SWITCH_TIMING = 10;
    private static final String TAG_COSMETIC_MODE = "CosmeticMode";
    private static final String MODE_DEFAULT = "default";
    private static final String MODE_BUTLER = "butler";
    private static final String MODE_MIX = "mix";

    public CopperDetonatorItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        BlockState blockState = level.m_8055_(blockPos);
        ItemStack stack = context.m_43722_();
        Player player = context.m_43723_();
        if (blockState.m_60713_(Blocks.f_50262_)) {
            if (!level.f_46443_ && player != null && DNLSupporters.hasSkin(player.m_20148_(), "copper_creep_butler")) {
                this.cycleCosmeticMode(stack);
                String modeName = CopperDetonatorItem.getCosmeticMode(stack);
                String capitalizedMode = modeName.substring(0, 1).toUpperCase() + modeName.substring(1);
                player.m_5661_((Component)Component.m_237113_((String)("Current Mode: " + capitalizedMode)).m_130940_(ChatFormatting.YELLOW), true);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    private void cycleCosmeticMode(ItemStack stack) {
        String current = CopperDetonatorItem.getCosmeticMode(stack);
        String next = current.equals(MODE_DEFAULT) ? MODE_BUTLER : (current.equals(MODE_BUTLER) ? MODE_MIX : MODE_DEFAULT);
        stack.m_41784_().m_128359_(TAG_COSMETIC_MODE, next);
    }

    public static String getCosmeticMode(ItemStack stack) {
        return stack.m_41784_().m_128461_(TAG_COSMETIC_MODE).isEmpty() ? MODE_DEFAULT : stack.m_41784_().m_128461_(TAG_COSMETIC_MODE);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        player.m_6672_(hand);
        return InteractionResultHolder.m_19100_((Object)itemStack);
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack itemStack, int remainingUseTick) {
        int usedTime = itemStack.m_41779_() - remainingUseTick;
        if (usedTime == 10) {
            livingEntity.m_216990_(DNLSounds.COPPER_DETONATOR_READY.get());
        } else if (usedTime > 10 && (usedTime - 10) % 20 == 0) {
            livingEntity.m_216990_(DNLSounds.COPPER_DETONATOR_BEEP.get());
        }
        super.m_5929_(level, livingEntity, itemStack, remainingUseTick);
    }

    public UseAnim m_6164_(ItemStack $$0) {
        return super.m_6164_($$0);
    }

    public void m_5551_(ItemStack itemStack, Level level, LivingEntity livingEntity, int remainingTicks) {
        int usedTime = itemStack.m_41779_() - remainingTicks;
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        InteractionHand hand = player.m_7655_();
        List<CopperCreepEntity> creepsInRange = this.findNearbyCreeps(player, 32.0);
        if (usedTime <= 10) {
            if (creepsInRange.size() < 3 && this.consumeCopperBlockIfAvailable(player)) {
                this.launchCreep(level, player);
                player.m_36335_().m_41524_((Item)this, 5);
                itemStack.m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(player1.m_7655_()));
                player.m_6674_(hand);
            }
        } else if (!creepsInRange.isEmpty()) {
            this.igniteCreeps(creepsInRange);
            player.m_36335_().m_41524_((Item)this, creepsInRange.size() * 100);
            player.m_6674_(hand);
        }
        super.m_5551_(itemStack, level, livingEntity, remainingTicks);
    }

    public int m_8105_(ItemStack itemStack) {
        return 72000;
    }

    private void launchCreep(Level level, Player player) {
        CopperCreepEntity creep = (CopperCreepEntity)DNLEntityTypes.COPPER_CREEP.get().m_20615_(level);
        if (creep == null) {
            return;
        }
        double offset = 1.0;
        double launchX = player.m_20185_() - Math.sin(Math.toRadians(player.m_146908_())) * offset;
        double launchY = player.m_20186_() + (double)player.m_20192_() * 0.6;
        double launchZ = player.m_20189_() + Math.cos(Math.toRadians(player.m_146908_())) * offset;
        creep.m_7678_(launchX, launchY, launchZ, player.m_146908_(), player.m_146909_());
        double velocity = 1.0;
        double motionX = -Math.sin(Math.toRadians(player.m_146908_())) * Math.cos(Math.toRadians(player.m_146909_())) * velocity;
        double motionY = -Math.sin(Math.toRadians(player.m_146909_())) * velocity;
        double motionZ = Math.cos(Math.toRadians(player.m_146908_())) * Math.cos(Math.toRadians(player.m_146909_())) * velocity;
        creep.m_20334_(motionX, motionY, motionZ);
        creep.setSummonerUUID(player.m_20148_());
        if (DNLSupporters.hasSkin(player.m_20148_(), "copper_creep_butler")) {
            if (CopperDetonatorItem.getCosmeticMode(player.m_21120_(InteractionHand.MAIN_HAND)).equals(MODE_MIX)) {
                if (Math.random() < 0.5) {
                    creep.setCosmeticMode(MODE_BUTLER);
                } else {
                    creep.setCosmeticMode(MODE_DEFAULT);
                }
            } else {
                creep.setCosmeticMode(CopperDetonatorItem.getCosmeticMode(player.m_21120_(InteractionHand.MAIN_HAND)));
            }
        }
        creep.setSkinValidation(true);
        level.m_7967_((Entity)creep);
    }

    private List<CopperCreepEntity> findNearbyCreeps(Player player, double radius) {
        return player.m_9236_().m_45976_(CopperCreepEntity.class, player.m_20191_().m_82400_(radius)).stream().filter(creep -> !creep.isDefused() && !creep.m_21224_() && creep.getSummonerUUID().filter(uuid -> uuid.equals(player.m_20148_())).isPresent() && player.m_20280_((Entity)creep) <= radius * radius).toList();
    }

    private boolean consumeCopperBlockIfAvailable(Player player) {
        if (player.m_7500_()) {
            return true;
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41720_() != Items.f_151000_ || stack.m_41613_() <= 0) continue;
            stack.m_41774_(1);
            return true;
        }
        return false;
    }

    private void igniteCreeps(List<CopperCreepEntity> creeps) {
        creeps.forEach(CopperCreepEntity::ignite);
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, components, tooltipFlag);
        if (((Boolean)GeneralConfig.TOGGLE_HELPFUL_ITEM_TOOLTIP.get()).booleanValue()) {
            components.add((Component)Component.m_237115_((String)"item.dungeonnowloading.copper_detonator.tooltip.ability_name").m_130940_(ChatFormatting.GRAY));
            components.add((Component)Component.m_237115_((String)"item.dungeonnowloading.copper_detonator.tooltip.ability_description").m_130940_(ChatFormatting.DARK_GRAY));
            components.add(CommonComponents.f_237098_);
            components.add((Component)Component.m_237115_((String)"item.dungeonnowloading.copper_detonator.tooltip.right_click").m_130940_(ChatFormatting.GRAY));
            components.add((Component)Component.m_237115_((String)"item.dungeonnowloading.copper_detonator.tooltip.right_click.description").m_130940_(ChatFormatting.DARK_GREEN));
            components.add(CommonComponents.f_237098_);
            components.add((Component)Component.m_237115_((String)"item.dungeonnowloading.copper_detonator.tooltip.hold_right_mouse_button").m_130940_(ChatFormatting.GRAY));
            components.add((Component)Component.m_237115_((String)"item.dungeonnowloading.copper_detonator.tooltip.hold_right_mouse_button.description").m_130940_(ChatFormatting.DARK_GREEN));
        }
    }
}

