/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.menu;

import dev.hexnowloading.dungeonnowloading.block.entity.MendingTableBlockEntity;
import dev.hexnowloading.dungeonnowloading.item.ScrapItem;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlocks;
import dev.hexnowloading.dungeonnowloading.registry.DNLItems;
import dev.hexnowloading.dungeonnowloading.registry.DNLMenuTypes;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class MendingTableMenu
extends AbstractContainerMenu {
    public static final int PICKAXE_SLOT = 0;
    public static final int DURITE_SLOT_1 = 1;
    public static final int DURITE_SLOT_2 = 2;
    public static final int OUTPUT_SLOT = 3;
    private final Container container;
    private final ContainerLevelAccess access;
    private int clientBasePercent = 0;
    private int clientBonusPercent = 0;

    public MendingTableMenu(int id, Inventory playerInv) {
        this(id, playerInv, (Container)new SimpleContainer(4));
    }

    public MendingTableMenu(int id, Inventory playerInv, final Container container) {
        super(DNLMenuTypes.MENDING_TABLE.get(), id);
        int col;
        MendingTableBlockEntity be;
        this.container = container;
        this.access = container instanceof MendingTableBlockEntity && (be = (MendingTableBlockEntity)container).m_58904_() != null ? ContainerLevelAccess.m_39289_((Level)be.m_58904_(), (BlockPos)be.m_58899_()) : ContainerLevelAccess.f_39287_;
        container.m_5856_(playerInv.f_35978_);
        this.m_38897_(new Slot(container, 0, 30, 45){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return stack.m_41763_() || stack.m_150930_(DNLItems.ITEM_SCRAPS.get());
            }

            public void m_6654_() {
                super.m_6654_();
                MendingTableMenu.this.m_38946_();
            }
        });
        this.m_38897_(new Slot(container, 1, 56, 33){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return true;
            }

            public void m_6654_() {
                super.m_6654_();
                MendingTableMenu.this.m_38946_();
            }
        });
        this.m_38897_(new Slot(container, 2, 56, 57){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return true;
            }

            public void m_6654_() {
                super.m_6654_();
                MendingTableMenu.this.m_38946_();
            }
        });
        this.m_38897_(new Slot(container, 3, 124, 45){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack stack) {
                super.m_142406_(player, stack);
                MendingTableMenu.this.consumeInputs();
                MendingTableMenu.this.access.m_39292_((level, pos) -> level.m_5594_(null, pos, DNLSounds.MENDING_TABLE_MEND.get(), SoundSource.BLOCKS, 1.0f, 1.0f));
            }
        });
        int invX = 8;
        int invY = 105;
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInv, col + row * 9 + 9, invX + col * 18, invY + row * 18));
            }
        }
        int hotbarY = invY + 58;
        for (col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInv, col, invX + col * 18, hotbarY));
        }
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                int n;
                if (container instanceof MendingTableBlockEntity) {
                    MendingTableBlockEntity be = (MendingTableBlockEntity)container;
                    n = be.getPotentialBasePercent();
                } else {
                    n = 0;
                }
                return n;
            }

            public void m_6422_(int value) {
                MendingTableMenu.this.clientBasePercent = value;
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                int n;
                if (container instanceof MendingTableBlockEntity) {
                    MendingTableBlockEntity be = (MendingTableBlockEntity)container;
                    n = be.getPotentialBonusPercent();
                } else {
                    n = 0;
                }
                return n;
            }

            public void m_6422_(int value) {
                MendingTableMenu.this.clientBonusPercent = value;
            }
        });
    }

    public int getBasePercent() {
        Container container = this.container;
        if (container instanceof MendingTableBlockEntity) {
            MendingTableBlockEntity be = (MendingTableBlockEntity)container;
            return be.getPotentialBasePercent();
        }
        return this.clientBasePercent;
    }

    public int getBonusPercent() {
        Container container = this.container;
        if (container instanceof MendingTableBlockEntity) {
            MendingTableBlockEntity be = (MendingTableBlockEntity)container;
            return be.getPotentialBonusPercent();
        }
        return this.clientBonusPercent;
    }

    public boolean m_6875_(@NotNull Player player) {
        return this.access == ContainerLevelAccess.f_39287_ || MendingTableMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)DNLBlocks.MENDING_TABLE.get());
    }

    private boolean isAllowedMaterial(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        ItemStack inputItem = this.m_38853_(0).m_7993_();
        boolean isScrap = inputItem.m_150930_(DNLItems.ITEM_SCRAPS.get());
        if (isScrap) {
            ItemStack original = ScrapItem.getOriginal(inputItem);
            if (!original.m_41619_()) {
                if (stack.m_150930_(DNLItems.DURITE.get()) || stack.m_150930_(DNLItems.MENDSTONE.get())) {
                    return true;
                }
                return original.m_41720_().m_6832_(original, stack);
            }
            return stack.m_150930_(DNLItems.DURITE.get()) || stack.m_150930_(DNLItems.MENDSTONE.get());
        }
        if (stack.m_150930_(DNLItems.DURITE.get()) || stack.m_150930_(DNLItems.MENDSTONE.get())) {
            return true;
        }
        if (!inputItem.m_41619_()) {
            return inputItem.m_41720_().m_6832_(inputItem, stack);
        }
        return false;
    }

    private void consumeInputs() {
        Container container = this.container;
        if (container instanceof MendingTableBlockEntity) {
            MendingTableBlockEntity be = (MendingTableBlockEntity)container;
            be.applyRepair();
        } else {
            this.container.m_6836_(0, ItemStack.f_41583_);
            this.container.m_6836_(1, ItemStack.f_41583_);
            this.container.m_6836_(2, ItemStack.f_41583_);
            this.container.m_6836_(3, ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        ItemStack result = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            int containerSlots = 4;
            if (index == 3) {
                result = stack.m_41777_();
                if (!this.m_38903_(stack, containerSlots, this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_142406_(player, stack);
                return result;
            }
            result = stack.m_41777_();
            if (index < containerSlots) {
                if (!this.m_38903_(stack, containerSlots, this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
            } else if (stack.m_41763_() || stack.m_150930_(DNLItems.ITEM_SCRAPS.get())) {
                if (!this.m_38903_(stack, 0, 1, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (this.isAllowedMaterial(stack)) {
                if (!this.m_38903_(stack, 1, 3, false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                return ItemStack.f_41583_;
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return result;
    }

    public void m_6877_(@NotNull Player player) {
        super.m_6877_(player);
        this.container.m_5785_(player);
    }
}

