/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.sound;

import dev.hexnowloading.dungeonnowloading.sound.DNLClientSoundHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.resources.ResourceLocation;

public class BackgroundMusicHandler {
    private static final List<FadingChannel> fadingChannels = new ArrayList<FadingChannel>();

    public static boolean isBackgroundMusicBlocked() {
        ResourceLocation id = new ResourceLocation("dungeonnowloading", "music_clash_of_duality_base");
        return DNLClientSoundHandler.isTickingSoundActive(id);
    }

    public static void fadeOutCurrentMusic(int fadeTicks) {
        ChannelAccess.ChannelHandle handle;
        Minecraft mc = Minecraft.m_91087_();
        SoundInstance music = mc.m_91397_().f_120179_;
        if (music != null && (handle = (ChannelAccess.ChannelHandle)mc.m_91106_().f_120349_.f_120226_.get(music)) != null) {
            BackgroundMusicHandler.startFading(handle, fadeTicks);
        }
    }

    private static void startFading(ChannelAccess.ChannelHandle handle, int fadeTicks) {
        fadingChannels.add(new FadingChannel(handle, fadeTicks));
    }

    public static void tick() {
        Iterator<FadingChannel> iterator = fadingChannels.iterator();
        while (iterator.hasNext()) {
            FadingChannel fading = iterator.next();
            if (fading.tick()) continue;
            iterator.remove();
        }
    }

    private static class FadingChannel {
        private final ChannelAccess.ChannelHandle handle;
        private final int totalTicks;
        private int currentTick = 0;

        FadingChannel(ChannelAccess.ChannelHandle handle, int totalTicks) {
            this.handle = handle;
            this.totalTicks = totalTicks;
        }

        boolean tick() {
            if (this.currentTick >= this.totalTicks) {
                this.handle.m_120154_(channel -> {
                    channel.m_83666_(0.0f);
                    channel.m_83679_();
                });
                return false;
            }
            float volume = 1.0f - (float)this.currentTick / (float)this.totalTicks;
            this.handle.m_120154_(channel -> channel.m_83666_(volume));
            ++this.currentTick;
            return true;
        }
    }
}

