/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.world.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.hexnowloading.dungeonnowloading.registry.DNLProcessors;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;

public class WeightedListProcessor
extends StructureProcessor {
    public static final Codec<WeightedListProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_256975_.m_194605_().fieldOf("input_block").forGetter(config -> config.input_block), (App)Codec.mapPair((MapCodec)BlockState.f_61039_.fieldOf("blockstate"), (MapCodec)Codec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf("weight")).codec().listOf().fieldOf("weighted_list_of_replacement_blocks").forGetter(processor -> processor.weightedReplacementBlocks)).apply((Applicative)instance, instance.stable(WeightedListProcessor::new)));
    private final List<Pair<BlockState, Integer>> weightedReplacementBlocks;
    private final Block input_block;

    public WeightedListProcessor(Block input_block, List<Pair<BlockState, Integer>> weightedReplacementBlocks) {
        this.input_block = input_block;
        this.weightedReplacementBlocks = weightedReplacementBlocks;
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings settings) {
        if (blockInfoGlobal.f_74676_().m_60734_() == this.input_block) {
            BlockState replacementBlock;
            double totalWeight = 0.0;
            RandomSource randomSource = settings.m_230326_(blockInfoGlobal.f_74675_());
            if (this.weightedReplacementBlocks.size() == 1) {
                replacementBlock = (BlockState)this.weightedReplacementBlocks.get(0).getFirst();
            } else {
                int index;
                for (Pair<BlockState, Integer> pair : this.weightedReplacementBlocks) {
                    totalWeight += (double)((Integer)pair.getSecond()).intValue();
                }
                double randomWeightPicked = (double)randomSource.m_188501_() * totalWeight;
                for (index = 0; index < this.weightedReplacementBlocks.size() - 1 && !((randomWeightPicked -= (double)((Integer)this.weightedReplacementBlocks.get(index).getSecond()).intValue()) <= 0.0); ++index) {
                }
                replacementBlock = (BlockState)this.weightedReplacementBlocks.get(index).getFirst();
            }
            blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.f_74675_(), replacementBlock, blockInfoGlobal.f_74677_());
        }
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> m_6953_() {
        return DNLProcessors.WEIGHTED_LIST_PROCESSOR.get();
    }
}

