/*
 * Decompiled with CFR 0.152.
 */
package lgbt.greenhouse.silicate.api.context.parameter;

import com.mojang.serialization.Codec;
import java.util.Objects;
import lgbt.greenhouse.silicate.api.context.GameContext;
import lgbt.greenhouse.silicate.api.context.parameter.GlobalParameterKey;
import lgbt.greenhouse.silicate.api.context.parameter.LocalParameterKey;
import lgbt.greenhouse.silicate.api.context.parameter.ParameterTemplate;
import lgbt.greenhouse.silicate.api.type.ValueType;
import lgbt.greenhouse.silicate.impl.SilicateConstants;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public sealed interface ParameterKey<T>
permits GlobalParameterKey, LocalParameterKey, Direct, Reference {
    public static final Codec<ParameterKey<?>> TEMPLATE_CODEC = ParameterTemplate.CODEC.xmap(template -> new Reference(template.id()), key -> new ParameterTemplate(key.getId()));
    public static final Codec<Reference<?>> CODEC = class_2960.field_25139.xmap(id -> {
        if (id.method_12836().equals("minecraft")) {
            return new Reference(SilicateConstants.id(id.method_12832()));
        }
        return new Reference((class_2960)id);
    }, Reference::getId);

    public static <V> Direct<V> direct(V value) {
        return new Direct<V>(value);
    }

    public class_2960 getId();

    @Nullable
    public ValueType<T> getTypeStatic();

    default public ValueType<T> getType(GameContext gameContext) {
        return Objects.requireNonNull(this.getTypeStatic(), "Static types in non-reference Parameter Keys shall never be null");
    }

    public static final class Direct<T>
    implements ParameterKey<T> {
        private final T value;

        private Direct(T value) {
            this.value = value;
        }

        @Override
        public class_2960 getId() {
            return SilicateConstants.id("direct");
        }

        @Override
        @Nullable
        public ValueType<T> getTypeStatic() {
            return null;
        }

        @Override
        public ValueType<T> getType(GameContext gameContext) {
            return new ValueType(this.getValue().getClass(), null);
        }

        public T getValue() {
            return this.value;
        }
    }

    public static final class Reference<T>
    implements ParameterKey<T> {
        private static final String NULL_STATIC_PARAMETER_KEY_TYPES = "Static types in non-reference Parameter Keys shall never be null";
        private final class_2960 id;

        public Reference(class_2960 id) {
            this.id = id;
        }

        @Override
        public class_2960 getId() {
            return this.id;
        }

        @Override
        @Nullable
        public ValueType<T> getTypeStatic() {
            return null;
        }

        @Override
        public ValueType<T> getType(GameContext gameContext) {
            return Objects.requireNonNull(Objects.requireNonNull(gameContext.getParameterMap().resolve(this)).getTypeStatic(), NULL_STATIC_PARAMETER_KEY_TYPES);
        }
    }
}

