/*
 * Decompiled with CFR 0.152.
 */
package lgbt.greenhouse.silicate.api.context.parameter;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lgbt.greenhouse.silicate.api.context.parameter.GlobalParameterKey;
import lgbt.greenhouse.silicate.api.context.parameter.Parameter;
import lgbt.greenhouse.silicate.api.context.parameter.ParameterKey;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public final class ParameterMap {
    private final Map<class_2960, ParameterKey<?>> id2Keys = new HashMap();
    private final Map<ParameterKey<?>, Parameter<?>> parameters;

    private ParameterMap(Map<ParameterKey<?>, Parameter<?>> parameters) {
        this.parameters = parameters;
        for (ParameterKey<?> key : this.parameters.keySet()) {
            this.id2Keys.put(key.getId(), key);
        }
    }

    public static ParameterMap of(Map<ParameterKey<?>, Parameter<?>> parameters) {
        return new ParameterMap(parameters);
    }

    public <T> Parameter<T> getOrThrow(ParameterKey<T> key) {
        if (key instanceof ParameterKey.Reference) {
            ParameterKey.Reference referenceKey = (ParameterKey.Reference)key;
            return this.getOrThrow(referenceKey);
        }
        if (key instanceof ParameterKey.Direct) {
            ParameterKey.Direct direct = (ParameterKey.Direct)key;
            return new Parameter(direct.getValue());
        }
        return Objects.requireNonNull(this.parameters.get(key), "Parameter " + String.valueOf(key.getId()) + " does not exist");
    }

    public <T> Parameter<T> getOrThrow(ParameterKey.Reference<T> key) {
        return Objects.requireNonNull(this.parameters.get(this.id2Keys.get(key.getId())), "Parameter " + String.valueOf(key.getId()) + " does not exist");
    }

    @Nullable
    public <T> ParameterKey<T> resolve(ParameterKey.Reference<T> referenceKey) {
        return this.id2Keys.get(referenceKey.getId());
    }

    public <T> boolean has(ParameterKey<T> key) {
        return this.id2Keys.containsKey(key.getId());
    }

    @Nullable
    public <T> Parameter<T> set(ParameterKey<T> key, T param) {
        this.parameters.keySet().removeIf(key1 -> key.getId().equals((Object)key1.getId()));
        this.id2Keys.put(key.getId(), key);
        return this.parameters.put(key, new Parameter<T>(param));
    }

    public void addAll(ParameterMap parameterMap) {
        this.id2Keys.putAll(parameterMap.id2Keys);
        this.parameters.keySet().removeIf(key -> parameterMap.id2Keys.containsKey(key.getId()));
        this.parameters.putAll(parameterMap.parameters);
    }

    public ParameterMap copy() {
        return new ParameterMap(new HashMap(this.parameters));
    }

    public static final class Builder {
        private final Map<ParameterKey<?>, Parameter<?>> params;

        private Builder(Map<ParameterKey<?>, Parameter<?>> params) {
            this.params = params;
        }

        private Builder() {
            this(new HashMap());
        }

        public static Builder of() {
            return new Builder();
        }

        public <T> Builder withParameter(GlobalParameterKey<T> key, Parameter<T> param) {
            this.params.put(key, param);
            return this;
        }

        public <T> Builder withParameter(GlobalParameterKey<T> key, T param) {
            return this.withParameter(key, (T)new Parameter<T>(param));
        }

        public ParameterMap build() {
            return new ParameterMap(this.params);
        }
    }
}

