/*
 * Decompiled with CFR 0.152.
 */
package lgbt.greenhouse.silicate.api.predicate.meta;

import com.mojang.serialization.Codec;
import java.util.Objects;
import lgbt.greenhouse.silicate.api.context.GameContext;
import lgbt.greenhouse.silicate.api.context.parameter.ParameterKey;
import lgbt.greenhouse.silicate.api.type.ValueType;
import org.jetbrains.annotations.Nullable;

public final class Deferred<T> {
    public static final Codec<Deferred<?>> CODEC = ParameterKey.TEMPLATE_CODEC.xmap(Deferred::new, Deferred::parameterKey);
    private final ParameterKey<T> parameterKey;
    @Nullable
    private final ValueType<T> requiredValueType;

    public Deferred(ParameterKey<T> parameterKey, @Nullable ValueType<T> requiredValueType) {
        this.parameterKey = parameterKey;
        this.requiredValueType = requiredValueType;
    }

    public Deferred(ParameterKey<T> parameterKey) {
        this(parameterKey, null);
    }

    public Deferred(T value) {
        this(ParameterKey.direct(value), null);
    }

    public T get(GameContext context) {
        ParameterKey<T> parameterKey;
        ParameterKey<T> parameterKey2 = this.parameterKey;
        if (parameterKey2 instanceof ParameterKey.Reference) {
            ParameterKey.Reference referenceKey = (ParameterKey.Reference)parameterKey2;
            parameterKey = Objects.requireNonNull(context.getParameterMap().resolve(referenceKey), "Cannot resolve non-existent Parameter " + String.valueOf(this.parameterKey.getId()) + " in Deferred value");
        } else {
            parameterKey = this.parameterKey;
        }
        if (this.requiredValueType != null && !Objects.equals(parameterKey.getType(context), this.requiredValueType)) {
            throw new ClassCastException("Parameter " + String.valueOf(parameterKey) + " cannot be converted to ValueType " + String.valueOf(this.requiredValueType));
        }
        return context.getParameter(parameterKey);
    }

    @Nullable
    public T getDirect() {
        ParameterKey<T> parameterKey = this.parameterKey;
        if (parameterKey instanceof ParameterKey.Direct) {
            ParameterKey.Direct direct = (ParameterKey.Direct)parameterKey;
            return direct.getValue();
        }
        return null;
    }

    public ParameterKey<T> parameterKey() {
        return this.parameterKey;
    }

    public String toString() {
        return "Deferred[parameterKey=" + String.valueOf(this.parameterKey) + "]";
    }
}

