/*
 * Decompiled with CFR 0.152.
 */
package lgbt.greenhouse.silicate.api.predicate.meta;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import dev.lukebemish.codecextras.record.KeyedRecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lgbt.greenhouse.silicate.api.context.GameContext;
import lgbt.greenhouse.silicate.api.context.parameter.LocalParameterKey;
import lgbt.greenhouse.silicate.api.context.parameter.Parameter;
import lgbt.greenhouse.silicate.api.context.parameter.ParameterKey;
import lgbt.greenhouse.silicate.api.context.parameter.ParameterMap;
import lgbt.greenhouse.silicate.api.predicate.GamePredicate;
import lgbt.greenhouse.silicate.api.predicate.meta.Deferred;
import lgbt.greenhouse.silicate.api.predicate.meta.Definitions;
import lgbt.greenhouse.silicate.api.predicate.meta.DynamicMetaPredicate;
import lgbt.greenhouse.silicate.api.predicate.meta.DynamicValue;
import lgbt.greenhouse.silicate.api.type.SilicateValueTypes;
import lgbt.greenhouse.silicate.api.type.ValueType;
import lgbt.greenhouse.silicate.impl.SilicateConstants;
import lgbt.greenhouse.silicate.impl.cursed.Clazzy;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class PredicateCodecBuilder<T extends GamePredicate<T>> {
    private static final Logger LOGGER = SilicateConstants.getLogger(PredicateCodecBuilder.class);
    private static final ValueType<Deferred<?>> DEFERRED = new ValueType(Clazzy.cast(Deferred.class), Deferred.CODEC);
    private final Class<T> clazz;
    private final Map<String, FieldEntry<?, ?, ?>> fields = new HashMap();
    private final List<FieldEntry<?, ?, ?>> entries = new ArrayList();

    private PredicateCodecBuilder(Class<T> clazz) {
        this.clazz = clazz;
    }

    public static <T extends GamePredicate<T>> PredicateCodecBuilder<T> of(Class<T> clazz) {
        return new PredicateCodecBuilder<T>(clazz);
    }

    public static MethodHandle findConstructor(Class<?> clazz, Class<?> ... parameters) {
        return PredicateCodecBuilder.findConstructor(MethodHandles.publicLookup(), clazz, parameters);
    }

    public static MethodHandle findPrivateConstructor(MethodHandles.Lookup lookup, Class<?> clazz, Class<?> ... parameters) {
        return PredicateCodecBuilder.findConstructor(lookup, clazz, parameters);
    }

    private static MethodHandle findConstructor(MethodHandles.Lookup lookup, Class<?> clazz, Class<?> ... parameters) {
        try {
            return lookup.findConstructor(clazz, MethodType.methodType(Void.TYPE, parameters));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static MethodHandle findStaticMethod(Class<?> clazz, String name, Class<?> returnType, Class<?> ... parameters) {
        return PredicateCodecBuilder.findStaticMethod(MethodHandles.publicLookup(), clazz, name, returnType, parameters);
    }

    public static MethodHandle findPrivateStaticMethod(MethodHandles.Lookup lookup, Class<?> clazz, String name, Class<?> returnType, Class<?> ... parameters) {
        return PredicateCodecBuilder.findStaticMethod(lookup, clazz, name, returnType, parameters);
    }

    private static MethodHandle findStaticMethod(MethodHandles.Lookup lookup, Class<?> clazz, String name, Class<?> returnType, Class<?> ... parameters) {
        try {
            return lookup.findStatic(clazz, name, MethodType.methodType(returnType, parameters));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public <V> PredicateCodecBuilder<T> withParameter(String key, ValueType<V> type, Function<T, ParameterKey<V>> getter) {
        this.fields.put(key, new FieldEntry<T, V, ParameterKey<V>>(key, type, null, getter, false, Optional.empty(), true, null, false));
        this.addOrderedEntry(key);
        return this;
    }

    public PredicateCodecBuilder<T> withReference(String key, Function<T, ParameterKey.Reference<?>> getter) {
        this.fields.put(key, new FieldEntry(key, SilicateValueTypes.REFERENCE_KEY, SilicateValueTypes.REFERENCE_KEY.codec(), getter, false, Optional.empty(), false, null, true));
        this.addOrderedEntry(key);
        return this;
    }

    public PredicateCodecBuilder<T> withDynamicValue(String valueTypeKey, String key, Function<T, DynamicValue> getter) {
        this.fields.put(key, new FieldEntry<T, DynamicValue, DynamicValue>(key, SilicateValueTypes.ANY, null, getter, false, Optional.empty(), false, new DynamicEntry(valueTypeKey), true));
        this.addOrderedEntry(key);
        return this;
    }

    public <V> PredicateCodecBuilder<T> withValue(String key, ValueType<V> type, Function<T, Deferred<V>> getter) {
        return this.withValue(key, type, Objects.requireNonNull(type.codec(), "ValueType must have a codec"), getter);
    }

    public <V> PredicateCodecBuilder<T> withValue(String key, ValueType<V> type, Codec<V> codec, Function<T, Deferred<V>> getter) {
        this.fields.put(key, new FieldEntry<T, V, Deferred<V>>(key, type, codec, getter, false, Optional.empty(), false, null, false));
        this.addOrderedEntry(key);
        return this;
    }

    public <V> PredicateCodecBuilder<T> withOptionalValue(String key, ValueType<V> type, Function<T, Deferred<Optional<V>>> getter) {
        return this.withOptionalValue(key, type, Objects.requireNonNull(type.codec(), "ValueType must have a codec"), getter);
    }

    public <V> PredicateCodecBuilder<T> withDefaultOptionalValue(String key, ValueType<V> type, Function<T, Deferred<V>> getter, V defaultValue) {
        return this.withDefaultOptionalValue(key, type, Objects.requireNonNull(type.codec(), "ValueType must have a codec"), getter, defaultValue);
    }

    public <V> PredicateCodecBuilder<T> withOptionalValue(String key, ValueType<V> type, Codec<V> codec, Function<T, Deferred<Optional<V>>> getter) {
        this.fields.put(key, new FieldEntry<T, V, Deferred<Optional<V>>>(key, type, codec, getter, true, Optional.empty(), false, null, false));
        this.addOrderedEntry(key);
        return this;
    }

    public <V> PredicateCodecBuilder<T> withDefaultOptionalValue(String key, ValueType<V> type, Codec<V> codec, Function<T, Deferred<V>> getter, V defaultValue) {
        this.fields.put(key, new FieldEntry<T, V, Deferred<V>>(key, type, codec, getter, true, Optional.of(defaultValue), false, null, false));
        this.addOrderedEntry(key);
        return this;
    }

    private void addOrderedEntry(String key) {
        this.entries.add(this.fields.get(key));
    }

    public MapCodec<T> build() {
        Class[] parameters = (Class[])this.entries.stream().map(fieldEntry -> {
            if (fieldEntry.requiresTemplateValues) {
                return new ValueType<ParameterKey>(ParameterKey.class, null);
            }
            if (fieldEntry.passThroughType) {
                return fieldEntry.type;
            }
            return DEFERRED;
        }).map(ValueType::clazz).toArray(Class[]::new);
        return this.build(PredicateCodecBuilder.findConstructor(this.clazz, parameters));
    }

    public MapCodec<T> build(MethodHandle constructor) {
        return KeyedRecordCodecBuilder.mapCodec(builder -> {
            ArrayList<KeyedRecordCodecBuilder.Key> keys = new ArrayList<KeyedRecordCodecBuilder.Key>();
            Iterator<FieldEntry<?, ?, ?>> iterator = this.entries.iterator();
            while (iterator.hasNext()) {
                FieldEntry<?, ?, ?> entry;
                FieldEntry<?, ?, ?> field = entry = iterator.next();
                if (field.codec == null) {
                    if (field.requiresTemplateValues) {
                        keys.add(builder.add(ParameterKey.TEMPLATE_CODEC.fieldOf(field.key), field.getter));
                        continue;
                    }
                    if (field.dynamic != null) {
                        keys.add(builder.add(DynamicValue.createCodec(field.dynamic.key, field.key), field.getter.andThen(a -> (DynamicValue)a)));
                        continue;
                    }
                    LOGGER.warn("{}: Value is somehow neither dynamic nor templated and yet has no codec. What did you do?", (Object)this.clazz.getName());
                    continue;
                }
                MapCodec fieldCodec = !field.optional ? field.codec.fieldOf(field.key) : (field.defaultValue.isEmpty() ? field.codec.optionalFieldOf(field.key) : field.codec.optionalFieldOf(field.key, field.defaultValue.get()));
                if (!field.type.equals(SilicateValueTypes.REFERENCE_KEY)) {
                    fieldCodec = Codec.mapEither((MapCodec)fieldCodec, (MapCodec)Deferred.CODEC.fieldOf(field.key));
                }
                keys.add(builder.add(fieldCodec, field.getter));
            }
            keys.add(builder.add(Definitions.CODEC, t -> null));
            return container -> {
                Object[] fields1 = keys.stream().filter(key -> {
                    Object object = container.get(key);
                    return !(object instanceof Definitions);
                }).map(key -> {
                    Object obj = container.get(key);
                    if (obj instanceof ParameterKey) {
                        ParameterKey parameterKey = (ParameterKey)obj;
                        return parameterKey;
                    }
                    if (obj instanceof DynamicValue) {
                        DynamicValue dynamicValue = (DynamicValue)obj;
                        return dynamicValue;
                    }
                    Either either = (Either)obj;
                    if (either.right().isPresent()) {
                        return either.right().get();
                    }
                    return new Deferred<Object>(either.orThrow());
                }).toArray();
                Optional<Definitions> definitions = keys.stream().filter(key -> {
                    Object object = container.get(key);
                    return object instanceof Definitions;
                }).map(key -> (Definitions)container.get(key)).findAny();
                try {
                    return new DynamicMetaPredicate((GamePredicate)constructor.invokeWithArguments(fields1), ctx -> {
                        if (definitions.isEmpty()) {
                            return;
                        }
                        ctx.getParameterMap().addAll(ParameterMap.of(((Definitions)definitions.get()).map().entrySet().stream().map(entry -> new AbstractMap.SimpleEntry(new LocalParameterKey((class_2960)entry.getKey(), ((DynamicValue)entry.getValue()).type()), new Parameter<Object>(((DynamicValue)entry.getValue()).value().get((GameContext)ctx)))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
                    });
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            };
        });
    }

    private record FieldEntry<O, T, V>(String key, ValueType<T> type, @Nullable Codec<T> codec, Function<O, V> getter, boolean optional, Optional<T> defaultValue, boolean requiresTemplateValues, @Nullable DynamicEntry dynamic, boolean passThroughType) {
    }

    private record DynamicEntry(String key) {
    }
}

