/*
 * Decompiled with CFR 0.152.
 */
package lgbt.greenhouse.silicate.api.predicate.minecraft;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Objects;
import lgbt.greenhouse.silicate.api.context.GameContext;
import lgbt.greenhouse.silicate.api.context.parameter.ParameterKey;
import lgbt.greenhouse.silicate.api.predicate.GamePredicate;
import lgbt.greenhouse.silicate.api.predicate.SilicatePredicateTypes;
import lgbt.greenhouse.silicate.api.predicate.meta.Deferred;
import lgbt.greenhouse.silicate.api.predicate.meta.PredicateCodecBuilder;
import lgbt.greenhouse.silicate.api.type.SilicateValueTypes;
import lgbt.greenhouse.silicate.impl.duck.Duck_AbstractClientPlayer;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_3222;

public record PlayerIsGameTypePredicate(ParameterKey<class_1657> player, Deferred<List<class_1934>> gameTypes) implements GamePredicate<PlayerIsGameTypePredicate>
{
    @Override
    public boolean test(GameContext ctx) {
        class_1297 entity = (class_1297)ctx.getParameter(this.player);
        if (entity instanceof Duck_AbstractClientPlayer) {
            Duck_AbstractClientPlayer duck = (Duck_AbstractClientPlayer)entity;
            return this.gameTypes.get(ctx).stream().anyMatch(arg_0 -> Objects.requireNonNull(duck.silicate$getPlayerInfo(), "Player has no GameType").method_2958().equals(arg_0));
        }
        if (entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            return this.gameTypes.get(ctx).stream().anyMatch(arg_0 -> serverPlayer.field_13974.method_14257().equals(arg_0));
        }
        return false;
    }

    @Override
    public GamePredicate.Type<PlayerIsGameTypePredicate> getType() {
        return SilicatePredicateTypes.PLAYER_IS_GAME_TYPE;
    }

    public static final class Type
    extends GamePredicate.Type<PlayerIsGameTypePredicate> {
        @Override
        protected MapCodec<PlayerIsGameTypePredicate> createCodec() {
            return this.createBaseCodec().apply(PredicateCodecBuilder.of(PlayerIsGameTypePredicate.class)).withParameter("player", SilicateValueTypes.PLAYER, PlayerIsGameTypePredicate::player).withValue("game_type", SilicateValueTypes.LIST_GAME_TYPE, PlayerIsGameTypePredicate::gameTypes).build();
        }
    }
}

