/*
 * Decompiled with CFR 0.152.
 */
package me.drex.worldmanager.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import me.drex.message.api.LocalizedMessage;
import me.drex.worldmanager.WorldManager;
import me.drex.worldmanager.command.CreateCommand;
import me.drex.worldmanager.extractor.ArchiveExtractor;
import me.drex.worldmanager.extractor.FolderArchiveExtractor;
import me.drex.worldmanager.extractor.RarArchiveExtractor;
import me.drex.worldmanager.extractor.TarGzArchiveExtractor;
import me.drex.worldmanager.extractor.ZipArchiveExtractor;
import me.drex.worldmanager.gui.ImportWorld;
import me.drex.worldmanager.mixin.MinecraftServerAccessor;
import me.drex.worldmanager.save.Location;
import me.drex.worldmanager.save.WorldConfig;
import me.drex.worldmanager.save.WorldData;
import me.drex.worldmanager.save.WorldManagerSavedData;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2960;
import net.minecraft.class_32;
import net.minecraft.class_3551;
import net.minecraft.class_4284;
import net.minecraft.class_5321;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.FilenameUtils;
import xyz.nucleoid.fantasy.Fantasy;
import xyz.nucleoid.fantasy.RuntimeWorldHandle;

public class ImportCommand {
    public static final Set<String> DIMENSION_PREFIXES = Set.of("data", "region", "entities", "poi");
    private static final List<ArchiveExtractor> EXTRACTORS = List.of(new FolderArchiveExtractor(), new ZipArchiveExtractor(), new RarArchiveExtractor(), new TarGzArchiveExtractor());
    public static final SuggestionProvider<class_2168> PATHS = (context, builder) -> {
        try {
            return class_2172.method_9265(Files.list(FabricLoader.getInstance().getGameDir()).filter(path -> {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    return true;
                }
                return EXTRACTORS.stream().anyMatch(archiveExtractor -> archiveExtractor.supports((Path)path));
            }).map(path -> "\"" + String.valueOf(path) + "\"").toList(), (SuggestionsBuilder)builder);
        }
        catch (IOException e) {
            return Suggestions.empty();
        }
    };
    public static final DynamicCommandExceptionType MISSING_LEVEL_DAT = new DynamicCommandExceptionType(file -> LocalizedMessage.builder((String)"worldmanager.command.import.exception.level_dat").addPlaceholder("file", file.toString()).build());
    public static final DynamicCommandExceptionType RAR5 = new DynamicCommandExceptionType(file -> LocalizedMessage.builder((String)"worldmanager.command.import.exception.rar5").addPlaceholder("file", file.toString()).build());
    public static final Dynamic2CommandExceptionType UNKNOWN_EXTENSION = new Dynamic2CommandExceptionType((file, extension) -> LocalizedMessage.builder((String)"worldmanager.command.import.exception.unknown_extension").addPlaceholder("file", file.toString()).addPlaceholder("extension", extension.toString()).build());
    public static final DynamicCommandExceptionType IO_EXCEPTION = new DynamicCommandExceptionType(file -> LocalizedMessage.builder((String)"worldmanager.command.import.exception.ioexception").addPlaceholder("file", file.toString()).build());

    public static LiteralArgumentBuilder<class_2168> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"import").requires(Permissions.require((String)"worldmanager.command.worldmanager.import", (int)4))).then(class_2170.method_9244((String)"id", (ArgumentType)class_2232.method_9441()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"path", (ArgumentType)StringArgumentType.string()).suggests(PATHS).executes(context -> ImportCommand.importWorld((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"id"), StringArgumentType.getString((CommandContext)context, (String)"path"), false))).then(class_2170.method_9247((String)"--custom-config").executes(context -> ImportCommand.importWorld((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)"id"), StringArgumentType.getString((CommandContext)context, (String)"path"), true)))));
    }

    public static int importWorld(class_2168 source, class_2960 id, String localPath, boolean customConfig) throws CommandSyntaxException {
        WorldConfig config;
        MinecraftServer server = source.method_9211();
        CreateCommand.validLevelId(id, server);
        Fantasy fantasy = Fantasy.get((MinecraftServer)server);
        class_32.class_5143 storageSource = ((MinecraftServerAccessor)server).getStorageSource();
        Path targetPath = storageSource.method_27424(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)id));
        Path fullPath = FabricLoader.getInstance().getGameDir().resolve(localPath);
        try {
            Optional<ArchiveExtractor> extractor = EXTRACTORS.stream().filter(e -> e.supports(fullPath)).findFirst();
            if (extractor.isEmpty()) {
                throw UNKNOWN_EXTENSION.create((Object)fullPath, (Object)FilenameUtils.getExtension((String)fullPath.toString()));
            }
            config = extractor.get().extract(fullPath, targetPath, server);
        }
        catch (IOException e2) {
            throw IO_EXCEPTION.create((Object)fullPath);
        }
        if (customConfig) {
            new ImportWorld(source.method_9207(), id).open();
        } else {
            RuntimeWorldHandle handle = fantasy.getOrOpenPersistentWorld(id, config.toRuntimeWorldConfig());
            WorldManagerSavedData savedData = WorldManagerSavedData.getSavedData(server);
            savedData.addWorld(id, config, handle);
            source.method_9226(() -> LocalizedMessage.builder((String)"worldmanager.command.import").addPlaceholder("id", id.toString()).build(), false);
        }
        return 1;
    }

    public static Optional<WorldConfig> parseWorldConfig(InputStream is, MinecraftServer server) throws IOException {
        class_2487 tag = class_2507.method_10629((InputStream)is, (class_2505)class_2505.method_53898());
        class_2487 unfixedData = tag.method_10562("Data");
        class_2487 data = ImportCommand.fixLevelData(unfixedData).orElse(unfixedData);
        int spawnX = data.method_10550("SpawnX");
        int spawnY = data.method_10550("SpawnY");
        int spawnZ = data.method_10550("SpawnZ");
        float spawnAngle = data.method_10583("SpawnAngle");
        class_2487 worldGenSettings = data.method_10562("WorldGenSettings");
        long seed = worldGenSettings.method_10537("seed");
        class_2487 overworld = worldGenSettings.method_10562("dimensions").method_10562("minecraft:overworld");
        return ImportCommand.createWorldConfig(server, overworld, spawnX, spawnY, spawnZ, spawnAngle, seed);
    }

    public static Optional<class_2487> fixLevelData(class_2487 levelData) {
        Optional<class_2487> optional;
        int dataVersion = class_2512.method_48309((class_2487)levelData, (int)-1);
        DataFixer dataFixer = class_3551.method_15450();
        Dynamic dynamic = class_4284.field_19212.method_48128(dataFixer, new Dynamic((DynamicOps)class_2509.field_11560, (Object)levelData), dataVersion).update("Player", playerDynamic -> class_4284.field_19213.method_48128(dataFixer, playerDynamic, dataVersion)).update("WorldGenSettings", worldGenDynamic -> class_4284.field_24640.method_48128(dataFixer, worldGenDynamic, dataVersion));
        Object object = dynamic.getValue();
        if (object instanceof class_2487) {
            class_2487 compoundTag = (class_2487)object;
            optional = Optional.of(compoundTag);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    private static Optional<WorldConfig> createWorldConfig(MinecraftServer server, class_2487 overworld, int spawnX, int spawnY, int spawnZ, float spawnAngle, long seed) {
        try {
            WorldConfig config = (WorldConfig)((Pair)WorldConfig.CODEC.decode((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)server.method_30611()), (Object)overworld).getOrThrow(IllegalStateException::new)).getFirst();
            WorldData worldData = new WorldData();
            worldData.spawnLocation = Optional.of(new Location(new class_243((double)spawnX, (double)spawnY, (double)spawnZ), new class_241(spawnAngle, 0.0f)));
            config.seed = seed;
            config.data = worldData;
            return Optional.of(config);
        }
        catch (IllegalStateException e) {
            WorldManager.LOGGER.error("Failed to decode level.dat", (Throwable)e);
            return Optional.empty();
        }
    }
}

